/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.util.PanelBuilderRegistry;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.ActionSupport;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelItemTreeNode<T extends ModelItem>
implements SoapUITreeNode,
PropertyChangeListener {
    private final T modelItem;
    private JPopupMenu popup;
    private boolean popupInitialized;
    private final ModelItem parentItem;
    private final SoapUITreeModel treeModel;
    private List<? extends SoapUITreeNode> orderItems;
    private String orderSetting;
    private SettingsListener settingsListener;
    private InternalSettingsListener internalSettingsListener;

    protected AbstractModelItemTreeNode(T modelItem, ModelItem parentItem, SoapUITreeModel treeModel) {
        this.modelItem = modelItem;
        this.parentItem = parentItem;
        this.treeModel = treeModel;
        this.initPopup();
        modelItem.addPropertyChangeListener(this);
    }

    public SoapUITreeModel getTreeModel() {
        return this.treeModel;
    }

    public Component getOverviewPanel() {
        return PanelBuilderRegistry.getPanelBuilder(this.modelItem).buildOverviewPanel(this.modelItem);
    }

    public T getModelItem() {
        return this.modelItem;
    }

    @Override
    public boolean valueChanged(Object newValue) {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public int getChildCount() {
        return this.orderItems == null ? 0 : this.orderItems.size();
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        return this.orderItems == null ? null : this.orderItems.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.orderItems == null ? -1 : this.orderItems.indexOf(child);
    }

    public String toString() {
        return this.modelItem.getName();
    }

    @Override
    public JPopupMenu getPopup() {
        if (!this.popupInitialized) {
            this.initPopup();
        }
        return this.popup;
    }

    @Override
    public SoapUITreeNode getParentTreeNode() {
        return this.treeModel.getTreeNode(this.parentItem);
    }

    protected void initPopup() {
        ActionList actions = this.modelItem.getActions();
        if (actions == null || actions.getActionCount() == 0) {
            return;
        }
        this.popup = ActionSupport.buildPopup(actions);
        this.popupInitialized = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TreePath nodePath;
        JTree mainTree;
        Rectangle rowBounds;
        String propertyName = evt.getPropertyName();
        if (propertyName.equals(ModelItem.ACTIONS_PROPERTY)) {
            if (this.popupInitialized) {
                this.initPopup();
            }
        } else if ((propertyName.equals(ModelItem.NAME_PROPERTY) || propertyName.equals(ModelItem.ICON_PROPERTY)) && (rowBounds = (mainTree = SoapUI.getNavigator().getMainTree()).getPathBounds(nodePath = this.getTreeModel().getPath(this))) != null) {
            mainTree.repaint(rowBounds);
        }
    }

    @Override
    public void release() {
        this.modelItem.removePropertyChangeListener(this);
        if (this.settingsListener != null) {
            this.modelItem.getSettings().removeSettingsListener(this.settingsListener);
        }
    }

    public <T2 extends SoapUITreeNode> void initOrdering(List<T2> items, String setting) {
        this.orderItems = items;
        this.orderSetting = setting;
        this.internalSettingsListener = new InternalSettingsListener(this, setting);
        SoapUI.getSettings().addSettingsListener(this.internalSettingsListener);
        this.sortModelItems(items, setting);
    }

    @Override
    public void reorder(boolean notify) {
        if (this.orderItems != null) {
            this.sortModelItems(this.orderItems, this.orderSetting);
            if (notify) {
                this.getTreeModel().notifyStructureChanged(new TreeModelEvent((Object)this, this.getTreeModel().getPath(this)));
            }
        }
    }

    public <T2 extends SoapUITreeNode> void sortModelItems(List<T2> modelItems, final String setting) {
        Collections.sort(modelItems, new Comparator<T2>(){

            @Override
            public int compare(T2 o1, T2 o2) {
                if (setting != null && SoapUI.getSettings().getBoolean(setting)) {
                    return o1.getModelItem().getName().compareToIgnoreCase(o2.getModelItem().getName());
                }
                return o1.getModelItem().getName().compareTo(o2.getModelItem().getName());
            }
        });
    }

    public class ReorderPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent arg0) {
            AbstractModelItemTreeNode.this.reorder(true);
            SoapUI.getNavigator().selectModelItem((ModelItem)arg0.getSource());
        }
    }

    private final class InternalSettingsListener
    implements SettingsListener {
        private final AbstractModelItemTreeNode node;
        private final String setting;

        public InternalSettingsListener(AbstractModelItemTreeNode node, String setting) {
            this.node = node;
            this.setting = setting;
        }

        public void settingChanged(String name, String newValue, String oldValue) {
            if (name.equals(this.setting)) {
                if (oldValue == null) {
                    oldValue = "false";
                }
                if (newValue == null) {
                    newValue = "false";
                }
                if (!oldValue.equals(newValue)) {
                    TreePath path = AbstractModelItemTreeNode.this.getTreeModel().getPath(AbstractModelItemTreeNode.this);
                    this.node.reorder(SoapUI.getNavigator().isVisible(path) && SoapUI.getNavigator().isExpanded(path));
                }
            }
        }
    }
}

