/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.registry;

import com.eviware.soapui.impl.wsdl.teststeps.registry.DelayStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.GotoStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.GroovyScriptStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.PropertiesStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.TransferValuesStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestRequestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import java.util.HashMap;
import java.util.Map;

public class WsdlTestStepRegistry {
    private static WsdlTestStepRegistry instance;
    private Map<String, WsdlTestStepFactory> factoryMap = new HashMap<String, WsdlTestStepFactory>();

    public WsdlTestStepRegistry() {
        this.addFactory(new WsdlTestRequestStepFactory());
        this.addFactory(new TransferValuesStepFactory());
        this.addFactory(new GotoStepFactory());
        this.addFactory(new DelayStepFactory());
        this.addFactory(new PropertiesStepFactory());
        this.addFactory(new GroovyScriptStepFactory());
    }

    public WsdlTestStepFactory getFactory(String type) {
        return this.factoryMap.get(type);
    }

    public void addFactory(WsdlTestStepFactory factory) {
        this.factoryMap.put(factory.getType(), factory);
    }

    public static synchronized WsdlTestStepRegistry getInstance() {
        if (instance == null) {
            instance = new WsdlTestStepRegistry();
        }
        return instance;
    }

    public WsdlTestStepFactory[] getFactories() {
        return this.factoryMap.values().toArray(new WsdlTestStepFactory[this.factoryMap.size()]);
    }
}

