/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.teststeps.TransferResponseValuesTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.support.DefaultDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ShowTransferValuesResultsAction
extends AbstractAction {
    private final TransferResponseValuesTestStep.ValueTransferResult result;
    private DefaultDesktopPanel desktopPanel;

    public ShowTransferValuesResultsAction(WsdlTestStepResult result) {
        this.result = (TransferResponseValuesTestStep.ValueTransferResult)result;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.result.isDiscarded()) {
                UISupport.showInfoMessage("Request has been discarded..");
            } else {
                UISupport.showDesktopPanel(this.buildFrame());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DesktopPanel buildFrame() {
        if (this.desktopPanel == null) {
            this.desktopPanel = new DefaultDesktopPanel("TestStep Result", "TestStep result for " + this.result.getTestStep().getName(), this.buildContent());
        }
        return this.desktopPanel;
    }

    private JComponent buildContent() {
        JPanel panel = new JPanel(new BorderLayout());
        JTable table = new JTable(new TransfersTableModel());
        table.getColumnModel().getColumn(0).setPreferredWidth(150);
        table.getColumnModel().getColumn(1).setPreferredWidth(400);
        panel.add((Component)new JScrollPane(table), "Center");
        panel.setPreferredSize(new Dimension(550, 300));
        return panel;
    }

    private class TransfersTableModel
    extends AbstractTableModel {
        private TransfersTableModel() {
        }

        public int getRowCount() {
            return ShowTransferValuesResultsAction.this.result.getTransferCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Transfer Name";
                }
                case 1: {
                    return "Transferred Values";
                }
            }
            return null;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ShowTransferValuesResultsAction.this.result.getTransferAt(rowIndex).getName();
                }
                case 1: {
                    return Arrays.toString(ShowTransferValuesResultsAction.this.result.getTransferredValuesAt(rowIndex));
                }
            }
            return null;
        }
    }
}

