/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.actions.ShowDesktopPanelAction;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.actions.teststep.DeleteTestStepAction;
import com.eviware.soapui.impl.wsdl.actions.teststep.RenameTestStepAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepListener;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepRegistry;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepProperty;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.action.DefaultActionList;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WsdlTestStep
extends AbstractWsdlModelItem<TestStepConfig>
implements TestStep {
    private final WsdlTestCase testCase;
    private Map<String, TestStepProperty> properties;
    private Set<WsdlTestStepListener> listeners = new HashSet<WsdlTestStepListener>();

    protected WsdlTestStep(WsdlTestCase testCase, TestStepConfig config, boolean hasEditor) {
        super(config, testCase, null);
        this.testCase = testCase;
        if (hasEditor) {
            this.addAction(new ShowDesktopPanelAction("Open Editor", "Opens the Editor for this TestStep", this));
        }
        DefaultActionList createActions = new DefaultActionList("Insert Step");
        WsdlTestStepRegistry registry = WsdlTestStepRegistry.getInstance();
        WsdlTestStepFactory[] factories = registry.getFactories();
        for (int c = 0; c < factories.length; ++c) {
            if (!factories[c].canCreate()) continue;
            createActions.addAction(new InsertTestStepAction(factories[c]));
        }
        this.addAction(new ActionSupport.ActionListAction(createActions));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new RenameTestStepAction(this));
        this.addAction(new DeleteTestStepAction(this));
    }

    public void postInit(TestStepConfig config) {
    }

    protected PanelBuilder createPanelBuilder() {
        return null;
    }

    @Override
    public WsdlTestCase getTestCase() {
        return this.testCase;
    }

    public void resetConfigOnMove(TestStepConfig config) {
        this.setConfig(config);
    }

    @Override
    public boolean cancel() {
        return false;
    }

    @Override
    public String[] getPropertyNames() {
        if (this.properties == null) {
            return new String[0];
        }
        String[] result = new String[this.properties.size()];
        int ix = 0;
        for (TestStepProperty property : this.properties.values()) {
            result[ix++] = property.getName();
        }
        return result;
    }

    @Override
    public TestStepProperty getProperty(String name) {
        return this.properties == null || name == null ? null : this.properties.get(name.toUpperCase());
    }

    @Override
    public String getPropertyValue(String name) {
        if (this.properties == null) {
            return null;
        }
        TestStepProperty testStepProperty = this.properties.get(name.toUpperCase());
        return testStepProperty == null ? null : testStepProperty.getValue();
    }

    @Override
    public void setPropertyValue(String name, String value) {
        if (this.properties == null) {
            return;
        }
        TestStepProperty testStepProperty = this.properties.get(name.toUpperCase());
        if (testStepProperty != null) {
            testStepProperty.setValue(value);
        }
    }

    protected void addProperty(TestStepProperty property) {
        if (this.properties == null) {
            this.properties = new HashMap<String, TestStepProperty>();
        }
        this.properties.put(property.getName().toUpperCase(), property);
    }

    protected void deleteProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name.toUpperCase());
        }
    }

    protected void propertyRenamed(String oldName) {
        if (this.properties == null) {
            return;
        }
        TestStepProperty testStepProperty = this.properties.get(oldName.toUpperCase());
        if (testStepProperty == null) {
            return;
        }
        this.properties.remove(oldName.toUpperCase());
        String newName = testStepProperty.getName();
        this.properties.put(newName.toUpperCase(), testStepProperty);
        this.firePropertyRenamed(oldName, newName);
    }

    public void addTestStepListener(WsdlTestStepListener listener) {
        this.listeners.add(listener);
    }

    public void removeTestStepListener(WsdlTestStepListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyAdded(String name) {
        WsdlTestStepListener[] array;
        for (WsdlTestStepListener listener : array = this.listeners.toArray(new WsdlTestStepListener[this.listeners.size()])) {
            listener.propertyAdded(name);
        }
    }

    protected void firePropertyRemoved(String name) {
        WsdlTestStepListener[] array;
        for (WsdlTestStepListener listener : array = this.listeners.toArray(new WsdlTestStepListener[this.listeners.size()])) {
            listener.propertyRemoved(name);
        }
    }

    protected void firePropertyRenamed(String oldName, String newName) {
        WsdlTestStepListener[] array;
        for (WsdlTestStepListener listener : array = this.listeners.toArray(new WsdlTestStepListener[this.listeners.size()])) {
            listener.propertyRenamed(oldName, newName);
        }
    }

    protected void firePropertyValueChanged(String name, String oldValue, String newValue) {
        WsdlTestStepListener[] array;
        if (oldValue == null && newValue == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        for (WsdlTestStepListener listener : array = this.listeners.toArray(new WsdlTestStepListener[this.listeners.size()])) {
            listener.propertyValueChanged(name, oldValue, newValue);
        }
    }

    public boolean dependsOn(AbstractWsdlModelItem modelItem) {
        return false;
    }

    public String getTestStepTitle() {
        return this.getTestCase().getTestSuite().getName() + "#" + this.getTestCase().getName();
    }

    public WsdlTestStep clone(WsdlTestCase targetTestCase, String name) {
        TestStepConfig newConfig = (TestStepConfig)((TestStepConfig)this.getConfig()).copy();
        newConfig.setName(name);
        return targetTestCase.addTestStep(newConfig);
    }

    @Override
    public void finish(TestRunner testRunner, TestRunContext testRunContext) {
    }

    @Override
    public void prepare(TestRunner testRunner, TestRunContext testRunContext) {
    }

    public class InsertTestStepAction
    extends AbstractAction {
        private final WsdlTestStepFactory factory;

        public InsertTestStepAction(WsdlTestStepFactory factory) {
            super(factory.getTestStepName());
            this.putValue("ShortDescription", factory.getTestStepDescription());
            this.putValue("SmallIcon", factory.getTestStepIcon());
            this.factory = factory;
        }

        public void actionPerformed(ActionEvent e) {
            TestStepConfig newTestStepConfig;
            String name = UISupport.prompt("Specify name for new step", "Insert Step", this.factory.getTestStepName());
            if (name != null && (newTestStepConfig = this.factory.createNewTestStep(WsdlTestStep.this.testCase, name)) != null) {
                int ix = WsdlTestStep.this.getTestCase().getIndexOfTestStep(WsdlTestStep.this);
                WsdlTestStep testStep = WsdlTestStep.this.testCase.insertTestStep(newTestStepConfig, ix);
                UISupport.selectAndShow(testStep);
            }
        }
    }
}

