/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;

public class WsdlTestRequestStepResult
extends WsdlTestStepResult
implements MessageExchange {
    private SoftReference<String> requestContent;
    private SoftReference<WsdlResponse> response;
    private String domain;
    private String username;
    private String endpoint;
    private String encoding;
    private String password;
    private StringToStringMap properties;

    public WsdlTestRequestStepResult(WsdlTestRequestStep step) {
        super(step);
    }

    public String getRequestContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        if (this.requestContent != null && this.requestContent.get() == null) {
            return "<garbage-collected>";
        }
        return this.requestContent == null ? null : this.requestContent.get();
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = new SoftReference<String>(requestContent);
    }

    public WsdlResponse getResponse() {
        if (this.isDiscarded()) {
            return null;
        }
        return this.response == null ? null : this.response.get();
    }

    public ActionList getActions() {
        ActionList actions = super.getActions();
        if (actions == null) {
            if (this.isDiscarded()) {
                return actions;
            }
            this.addAction(new ShowMessageExchangeAction(this, "TestStep"), true);
            return super.getActions();
        }
        return actions;
    }

    public void setResponse(WsdlResponse response) {
        this.response = new SoftReference<WsdlResponse>(response);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.addProperty("domain", domain);
    }

    private void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(key, value);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.addProperty("encoding", encoding);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        this.addProperty("endpoint", endpoint);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.addProperty("password", password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.addProperty("username", username);
    }

    public void discard() {
        super.discard();
        this.requestContent = null;
        this.response = null;
        this.properties = null;
    }

    public void writeTo(PrintWriter writer) {
        String request;
        super.writeTo(writer);
        writer.println("----------------------------------------------------");
        writer.println("Encoding: " + this.getEncoding());
        writer.println("Endpoint: " + this.getEndpoint());
        writer.println("Username: " + this.getUsername());
        writer.println("Password: " + this.getPassword());
        writer.println("Domain: " + this.getDomain());
        WsdlResponse resp = this.response == null ? null : this.response.get();
        writer.println("---------------- Request ---------------------------");
        String string = request = this.requestContent == null ? null : this.requestContent.get();
        if (request != null) {
            writer.println(XmlUtils.prettyPrintXml(request));
        } else {
            writer.println("- missing request / garbage collected -");
        }
        if (resp != null) {
            writer.println("Request Headers: " + resp.getRequestHeaders().toString());
        }
        writer.println("---------------- Response --------------------------");
        if (resp != null) {
            String respContent = resp.getContentAsString();
            if (respContent != null) {
                writer.println(XmlUtils.prettyPrintXml(respContent));
            }
            writer.println("Response Headers: " + resp.getResponseHeaders().toString());
        } else {
            writer.println("- missing response / garbage collected -");
        }
    }

    public StringToStringMap getProperties() {
        return this.properties;
    }

    public Attachment[] getRequestAttachments() {
        if (this.isDiscarded() || this.response == null || this.response.get() == null) {
            return null;
        }
        return this.response.get().getRequest().getAttachments();
    }

    public StringToStringMap getRequestHeaders() {
        if (this.isDiscarded() || this.response == null || this.response.get() == null) {
            return null;
        }
        return this.response.get().getRequestHeaders();
    }

    public Attachment[] getResponseAttachments() {
        if (this.isDiscarded() || this.response == null || this.response.get() == null) {
            return null;
        }
        return this.response.get().getAttachments();
    }

    public String getResponseContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        if (this.response == null) {
            return "<missing response>";
        }
        if (this.response != null && this.response.get() == null) {
            return "<garbage-collected>";
        }
        return this.response.get().getContentAsString();
    }

    public StringToStringMap getResponseHeaders() {
        if (this.isDiscarded() || this.response == null || this.response.get() == null) {
            return null;
        }
        return this.response.get().getResponseHeaders();
    }

    public long getTimestamp() {
        if (this.isDiscarded() || this.response == null || this.response.get() == null) {
            return -1L;
        }
        return this.response.get().getTimestamp();
    }
}

