/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.ValueTransferConfig;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransferException;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepListenerAdapter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepProperty;
import com.eviware.soapui.support.PropertyChangeNotifier;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyTransfer
implements PropertyChangeNotifier {
    private static final Logger log = Logger.getLogger(PropertyTransfer.class);
    public static final String SOURCE_PATH_PROPERTY = PropertyTransfer.class.getName() + "@sourcePath";
    public static final String SOURCE_TYPE_PROPERTY = PropertyTransfer.class.getName() + "@sourceProperty";
    public static final String SOURCE_STEP_PROPERTY = PropertyTransfer.class.getName() + "@sourceStep";
    public static final String TARGET_PATH_PROPERTY = PropertyTransfer.class.getName() + "@targetPath";
    public static final String TARGET_TYPE_PROPERTY = PropertyTransfer.class.getName() + "@targetProperty";
    public static final String TARGET_STEP_PROPERTY = PropertyTransfer.class.getName() + "@targetStep";
    public static final String NAME_PROPERTY = PropertyTransfer.class.getName() + "@name";
    public static final String CONFIG_PROPERTY = PropertyTransfer.class.getName() + "@config";
    private TestStep testStep;
    private ValueTransferConfig config;
    private String sourcePath;
    private String sourceType;
    private String targetPath;
    private String name;
    private String targetType;
    private String sourceStep;
    private String targetStep;
    private TestStep currentTargetStep;
    private TestStep currentSourceStep;
    private TestStepProperty currentTargetProperty;
    private TestStepProperty currentSourceProperty;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private StepNameChangeListener stepNameChangeListener = new StepNameChangeListener();
    private PropertyNameChangeListener propertyNameChangeListener = new PropertyNameChangeListener();
    private TestCase testCase;
    private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();

    public PropertyTransfer(TestStep testStep) {
        this(testStep, ValueTransferConfig.Factory.newInstance());
    }

    public PropertyTransfer(TestStep testStep, ValueTransferConfig config) {
        this.testStep = testStep;
        if (testStep != null) {
            this.testCase = testStep.getTestCase();
            this.testCase.getTestSuite().addTestSuiteListener(this.testSuiteListener);
        }
        this.setConfig(config);
    }

    void setConfigOnMove(ValueTransferConfig config) {
        this.config = config;
    }

    void setConfig(ValueTransferConfig config) {
        this.releaseListeners();
        this.config = config;
        if (!config.isSetSetNullOnMissingSource()) {
            config.setSetNullOnMissingSource(true);
        }
        if (!config.isSetTransferTextContent()) {
            config.setTransferTextContent(true);
        }
        this.sourceStep = config.getSourceStep();
        if (this.sourceStep == null) {
            this.sourceStep = this.getSourceStepName();
            if (this.sourceStep != null) {
                config.setSourceStep(this.sourceStep);
            }
        }
        this.currentSourceStep = this.sourceStep == null || this.testCase == null ? null : this.testCase.getTestStepByName(this.sourceStep);
        this.sourceType = config.getSourceType();
        this.currentSourceProperty = this.currentSourceStep == null || this.sourceType == null ? null : this.currentSourceStep.getProperty(this.sourceType);
        this.sourcePath = config.getSourcePath();
        this.targetStep = config.getTargetStep();
        if (this.targetStep == null) {
            this.targetStep = this.getTargetStepName();
            if (this.targetStep != null) {
                config.setTargetStep(this.targetStep);
            }
        }
        this.currentTargetStep = this.targetStep == null || this.testCase == null ? null : this.testCase.getTestStepByName(this.targetStep);
        this.targetType = config.getTargetType();
        this.currentTargetProperty = this.currentTargetStep == null || this.targetType == null ? null : this.currentTargetStep.getProperty(this.targetType);
        this.targetPath = config.getTargetPath();
        this.name = config.getName();
        this.initListeners();
        this.propertyChangeSupport.firePropertyChange(CONFIG_PROPERTY, null, null);
    }

    private void initListeners() {
        if (this.currentSourceStep != null) {
            this.currentSourceStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            ((WsdlTestStep)this.currentSourceStep).addTestStepListener(this.propertyNameChangeListener);
        }
        if (this.currentTargetStep != null) {
            this.currentTargetStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            ((WsdlTestStep)this.currentTargetStep).addTestStepListener(this.propertyNameChangeListener);
        }
    }

    public void releaseListeners() {
        PropertyChangeListener[] listeners;
        if (this.currentSourceStep != null) {
            this.currentSourceStep.removePropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            ((WsdlTestStep)this.currentSourceStep).removeTestStepListener(this.propertyNameChangeListener);
        }
        if (this.currentTargetStep != null) {
            this.currentTargetStep.removePropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            ((WsdlTestStep)this.currentTargetStep).removeTestStepListener(this.propertyNameChangeListener);
        }
        for (PropertyChangeListener listener : listeners = this.propertyChangeSupport.getPropertyChangeListeners()) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public void release() {
        this.releaseListeners();
        this.testCase.getTestSuite().removeTestSuiteListener(this.testSuiteListener);
    }

    public ValueTransferConfig getConfig() {
        return this.config;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public TestStepProperty getSourceProperty() {
        if (this.sourceType == null) {
            return null;
        }
        if (this.currentSourceProperty != null) {
            return this.currentSourceProperty;
        }
        TestStep actualSourceStep = this.getSourceStep();
        return actualSourceStep == null ? null : actualSourceStep.getProperty(this.sourceType);
    }

    public String[] transferProperties(SubmitContext context) throws PropertyTransferException {
        TestStepProperty sourceProperty = this.getSourceProperty();
        TestStepProperty targetProperty = this.getTargetProperty();
        try {
            if (sourceProperty == null) {
                throw new Exception("Missing source property");
            }
            if (targetProperty == null) {
                throw new Exception("Missing target property");
            }
            if (sourceProperty.getValue() == null && !this.getSetNullOnMissingSource() && !this.getIgnoreEmpty()) {
                throw new Exception("Source property is null");
            }
            if (!this.hasSourcePath() && !this.hasTargetPath()) {
                if (!this.getIgnoreEmpty() || sourceProperty.getValue() != null && sourceProperty.getValue().length() > 0) {
                    return this.transferStringToString(sourceProperty, targetProperty);
                }
            } else {
                if (this.hasSourcePath() && this.hasTargetPath()) {
                    return this.transferXmlToXml(sourceProperty, targetProperty, context);
                }
                if (this.hasSourcePath() && !this.hasTargetPath()) {
                    return new String[]{this.transferXmlToString(sourceProperty, targetProperty, context)};
                }
                if (!this.hasSourcePath() && this.hasTargetPath() && (!this.getIgnoreEmpty() || sourceProperty.getValue() != null && sourceProperty.getValue().length() > 0)) {
                    return this.transferStringToXml(sourceProperty, targetProperty, context);
                }
            }
        }
        catch (Exception e) {
            throw new PropertyTransferException(e.toString(), this.getSourceStepName(), sourceProperty, this.getTargetStepName(), targetProperty);
        }
        return new String[0];
    }

    private boolean hasTargetPath() {
        String path = this.getTargetPath();
        return path != null && path.trim().length() > 0;
    }

    private boolean hasSourcePath() {
        String path = this.getSourcePath();
        return path != null && path.trim().length() > 0;
    }

    protected String[] transferStringToString(TestStepProperty sourceProperty, TestStepProperty targetProperty) {
        String value = sourceProperty.getValue();
        targetProperty.setValue(value);
        return new String[]{value};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] transferXmlToXml(TestStepProperty sourceProperty, TestStepProperty targetProperty, SubmitContext context) throws XmlException, Exception {
        String sourcePropertyValue = sourceProperty.getValue();
        XmlObject sourceXmlObject = XmlObject.Factory.parse((String)sourcePropertyValue);
        XmlCursor sourceXml = sourceXmlObject.newCursor();
        String targetPropertyValue = targetProperty.getValue();
        XmlObject targetXmlObject = XmlObject.Factory.parse((String)targetPropertyValue);
        XmlCursor targetXml = targetXmlObject.newCursor();
        XmlCursor lastSource = null;
        try {
            ArrayList<String> result = new ArrayList<String>();
            targetXml.selectPath(PropertyExpansionRequestFilter.expandProperties(context, this.getTargetPath()));
            if (!targetXml.hasNextSelection()) {
                throw new Exception("Missing match for Target path [" + this.getTargetPath() + "]");
            }
            sourceXml.selectPath(PropertyExpansionRequestFilter.expandProperties(context, this.getSourcePath()));
            if (!sourceXml.hasNextSelection()) {
                if (this.getSetNullOnMissingSource()) {
                    while (targetXml.toNextSelection()) {
                        result.add(this.setNodeValue(null, targetXml.getDomNode()));
                        if (this.getTransferToAll()) continue;
                        break;
                    }
                } else if (!this.getIgnoreEmpty()) {
                    throw new Exception("Missing match for Source path [" + this.getSourcePath() + "]");
                }
            } else {
                boolean hasSource = sourceXml.toNextSelection();
                boolean hasTarget = targetXml.toNextSelection();
                while (hasSource && hasTarget) {
                    if (lastSource != null) {
                        lastSource.dispose();
                    }
                    lastSource = sourceXml.newCursor();
                    result.add(this.transferXmlValue(sourceXml, targetXml));
                    hasSource = sourceXml.toNextSelection();
                    hasTarget = targetXml.toNextSelection();
                }
                if (this.getTransferToAll() && !hasSource && hasTarget && lastSource != null) {
                    while (hasTarget) {
                        result.add(this.transferXmlValue(lastSource, targetXml));
                        hasTarget = targetXml.toNextSelection();
                    }
                }
            }
            if (result.size() > 0) {
                targetProperty.setValue(targetXmlObject.xmlText(new XmlOptions().setSaveAggressiveNamespaces()));
            }
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        finally {
            sourceXml.dispose();
            targetXml.dispose();
            if (lastSource != null) {
                lastSource.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] transferStringToXml(TestStepProperty sourceProperty, TestStepProperty targetProperty, SubmitContext context) throws XmlException, Exception {
        XmlObject targetXml = XmlObject.Factory.parse((String)targetProperty.getValue());
        XmlCursor targetCursor = targetXml.newCursor();
        try {
            ArrayList<String> result = new ArrayList<String>();
            targetCursor.selectPath(PropertyExpansionRequestFilter.expandProperties(context, this.getTargetPath()));
            if (!targetCursor.toNextSelection()) {
                throw new Exception("Missing match for Target path [" + this.getTargetPath() + "]");
            }
            String value = sourceProperty.getValue();
            Node targetNode = targetCursor.getDomNode();
            this.setNodeValue(value, targetNode);
            result.add(value);
            if (this.getTransferToAll()) {
                while (targetCursor.toNextSelection()) {
                    targetNode = targetCursor.getDomNode();
                    this.setNodeValue(value, targetNode);
                    result.add(value);
                }
            }
            targetProperty.setValue(targetXml.xmlText(new XmlOptions().setSaveAggressiveNamespaces()));
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        finally {
            targetCursor.dispose();
        }
    }

    private String setNodeValue(String value, Node node) throws Exception {
        short targetNodeType = node.getNodeType();
        if (targetNodeType == 11) {
            if ((node = ((DocumentFragment)node).getFirstChild()) != null) {
                targetNodeType = node.getNodeType();
            } else {
                throw new Exception("Missing source value for " + this.getSourcePropertyName());
            }
        }
        if (targetNodeType == 3 || targetNodeType == 2) {
            node.setNodeValue(value);
        } else if (targetNodeType == 1) {
            XmlUtils.setElementText((Element)node, value);
        } else {
            throw new Exception("Failed to set value to node [" + node.toString() + "] of type [" + targetNodeType + "]");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String transferXmlToString(TestStepProperty sourceProperty, TestStepProperty targetProperty, SubmitContext context) throws XmlException, Exception {
        XmlObject sourceXml = XmlObject.Factory.parse((String)sourceProperty.getValue());
        XmlCursor sourceCursor = sourceXml.newCursor();
        try {
            String value = null;
            sourceCursor.selectPath(PropertyExpansionRequestFilter.expandProperties(context, this.getSourcePath()));
            if (!sourceCursor.toNextSelection()) {
                if (!this.getSetNullOnMissingSource() && !this.getIgnoreEmpty()) {
                    throw new Exception("Missing match for Source path [" + this.getSourcePath() + "]");
                }
            } else {
                Node sourceNode = sourceCursor.getDomNode();
                short sourceNodeType = sourceNode.getNodeType();
                if (sourceNodeType == 11) {
                    if ((sourceNode = ((DocumentFragment)sourceNode).getFirstChild()) != null) {
                        sourceNodeType = sourceNode.getNodeType();
                    } else {
                        throw new Exception("Missing source value for " + this.getSourcePropertyName());
                    }
                }
                if (sourceNodeType == 3 || sourceNodeType == 2) {
                    value = sourceNode.getNodeValue();
                } else if (sourceNodeType == 1) {
                    value = XmlUtils.getElementText((Element)sourceNode);
                }
            }
            if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                targetProperty.setValue(value);
            } else {
                value = "";
            }
            String string = value;
            return string;
        }
        finally {
            sourceCursor.dispose();
        }
    }

    private String transferXmlValue(XmlCursor source, XmlCursor dest) throws Exception {
        Node destNode = dest.getDomNode();
        Node sourceNode = source.getDomNode();
        short destNodeType = destNode.getNodeType();
        short sourceNodeType = sourceNode.getNodeType();
        String value = null;
        if (sourceNodeType == 11) {
            if ((sourceNode = ((DocumentFragment)sourceNode).getFirstChild()) != null) {
                sourceNodeType = sourceNode.getNodeType();
            } else {
                throw new Exception("Missing source value for " + source);
            }
        }
        if (destNodeType == sourceNodeType) {
            if (destNodeType == 3 || destNodeType == 2) {
                value = sourceNode.getNodeValue();
                if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                    destNode.setNodeValue(value);
                }
            } else if (this.config.getTransferTextContent() && destNodeType == 1) {
                value = XmlUtils.getElementText((Element)sourceNode);
                if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                    XmlUtils.setElementText((Element)destNode, value);
                }
            } else {
                destNode = destNode.getParentNode().replaceChild(destNode.getOwnerDocument().importNode(sourceNode, true), destNode);
                value = dest.xmlText();
            }
        } else if (sourceNodeType == 3 && destNodeType == 2 || sourceNodeType == 2 && destNodeType == 3) {
            value = sourceNode.getNodeValue();
            if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                destNode.setNodeValue(value);
            }
        } else if (sourceNodeType == 1 && destNodeType == 2 || destNodeType == 3) {
            value = XmlUtils.getElementText((Element)sourceNode);
            if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                destNode.setNodeValue(value);
            }
        } else if (destNodeType == 1 && sourceNodeType == 2 || sourceNodeType == 3) {
            value = sourceNode.getNodeValue();
            if (!this.getIgnoreEmpty() || value != null && value.length() > 0) {
                XmlUtils.setElementText((Element)destNode, value);
            }
        }
        return value;
    }

    public String getSourcePropertyName() {
        if (this.sourceType == null) {
            return null;
        }
        if (this.currentSourceProperty != null) {
            return this.currentSourceProperty.getName();
        }
        TestStep actualSourceStep = this.getSourceStep();
        if (actualSourceStep == null) {
            return this.sourceType;
        }
        TestStepProperty property = actualSourceStep.getProperty(this.sourceType);
        return property == null ? this.sourceType : property.getName();
    }

    public void setSourcePropertyName(String name) {
        String old = this.getSourcePropertyName();
        if (name == null && old == null || name != null && old != null && name.equals(old)) {
            return;
        }
        this.sourceType = name;
        this.config.setSourceType(name);
        TestStep sourceStep2 = this.getSourceStep();
        this.currentSourceProperty = sourceStep2 != null && this.sourceType != null ? sourceStep2.getProperty(this.sourceType) : null;
        this.propertyChangeSupport.firePropertyChange(SOURCE_TYPE_PROPERTY, old, name);
    }

    public TestStepProperty getTargetProperty() {
        if (this.targetType == null) {
            return null;
        }
        if (this.currentTargetProperty != null) {
            return this.currentTargetProperty;
        }
        TestStep actualTargetStep = this.getTargetStep();
        return actualTargetStep == null ? null : actualTargetStep.getProperty(this.targetType);
    }

    public String getTargetPropertyName() {
        if (this.targetType == null) {
            return null;
        }
        if (this.currentTargetProperty != null) {
            return this.currentTargetProperty.getName();
        }
        TestStep actualTargetStep = this.getTargetStep();
        TestStepProperty property = actualTargetStep == null ? null : actualTargetStep.getProperty(this.targetType);
        return actualTargetStep == null || property == null ? this.targetType : property.getName();
    }

    public void setTargetPropertyName(String name) {
        String old = this.getTargetPropertyName();
        if (name == null && old == null || name != null && old != null && name.equals(old)) {
            return;
        }
        this.targetType = name;
        this.config.setTargetType(name);
        TestStep targetStep2 = this.getTargetStep();
        this.currentTargetProperty = targetStep2 != null && this.targetType != null ? targetStep2.getProperty(this.targetType) : null;
        this.propertyChangeSupport.firePropertyChange(TARGET_TYPE_PROPERTY, old, name);
    }

    public String getName() {
        return this.config.getName();
    }

    public void setSourcePath(String path) {
        String old = this.sourcePath;
        this.sourcePath = path;
        this.config.setSourcePath(path);
        this.propertyChangeSupport.firePropertyChange(SOURCE_PATH_PROPERTY, old, path);
    }

    public void setTargetPath(String path) {
        String old = this.targetPath;
        this.targetPath = path;
        this.config.setTargetPath(path);
        this.propertyChangeSupport.firePropertyChange(TARGET_PATH_PROPERTY, old, path);
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.config.setName(name);
        this.propertyChangeSupport.firePropertyChange(NAME_PROPERTY, old, name);
    }

    public TestStep getSourceStep() {
        String sourceStepName = this.getSourceStepName();
        return sourceStepName == null ? null : this.testCase.getTestStepByName(sourceStepName);
    }

    public String getSourceStepName() {
        if (this.sourceStep != null) {
            return this.sourceStep;
        }
        if (this.testCase == null) {
            return null;
        }
        TestStep step = this.testCase.findPreviousStepOfType(this.testStep, WsdlTestRequestStep.class);
        return step == null ? null : step.getName();
    }

    public void setSourceStepName(String sourceStep) {
        String old = this.getSourceStepName();
        if (sourceStep == null && old == null || sourceStep != null && old != null && sourceStep.equals(old)) {
            return;
        }
        if (sourceStep == null) {
            log.debug((Object)("Setting sourceStep for transfer [" + this.getName() + "] to null"));
        }
        this.sourceStep = sourceStep;
        this.config.setSourceStep(sourceStep);
        if (this.currentSourceStep != null) {
            this.currentSourceStep.removePropertyChangeListener(this.stepNameChangeListener);
            ((WsdlTestStep)this.currentSourceStep).removeTestStepListener(this.propertyNameChangeListener);
        }
        this.currentSourceStep = (WsdlTestStep)(sourceStep == null ? null : this.testStep.getTestCase().getTestStepByName(sourceStep));
        if (this.currentSourceStep != null) {
            this.currentSourceStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            ((WsdlTestStep)this.currentSourceStep).addTestStepListener(this.propertyNameChangeListener);
        }
        this.propertyChangeSupport.firePropertyChange(SOURCE_STEP_PROPERTY, old, sourceStep);
        this.setSourcePropertyName(null);
    }

    public TestStep getTargetStep() {
        String targetStepName = this.getTargetStepName();
        return targetStepName == null ? null : this.testCase.getTestStepByName(targetStepName);
    }

    public String getTargetStepName() {
        if (this.targetStep != null) {
            return this.targetStep;
        }
        if (this.testCase == null) {
            return null;
        }
        TestStep step = this.testCase.findNextStepOfType(this.testStep, WsdlTestRequestStep.class);
        return step == null ? null : step.getName();
    }

    public void setTargetStepName(String targetStep) {
        String old = this.getTargetStepName();
        if (targetStep == null && old == null || targetStep != null && old != null && targetStep.equals(old)) {
            return;
        }
        if (targetStep == null) {
            log.debug((Object)("Setting targetStep for transfer [" + this.getName() + "] to null"));
        }
        this.targetStep = targetStep;
        this.config.setTargetStep(targetStep);
        if (this.currentTargetStep != null) {
            this.currentTargetStep.removePropertyChangeListener(this.stepNameChangeListener);
            ((WsdlTestStep)this.currentTargetStep).removeTestStepListener(this.propertyNameChangeListener);
        }
        this.currentTargetStep = (WsdlTestStep)(targetStep == null ? null : this.testStep.getTestCase().getTestStepByName(targetStep));
        if (this.currentTargetStep != null) {
            this.currentTargetStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this.stepNameChangeListener);
            ((WsdlTestStep)this.currentTargetStep).addTestStepListener(this.propertyNameChangeListener);
        }
        this.propertyChangeSupport.firePropertyChange(TARGET_STEP_PROPERTY, old, targetStep);
        this.setTargetPropertyName(null);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public boolean getFailOnError() {
        return this.config.getFailOnError();
    }

    public void setFailOnError(boolean failOnError) {
        this.config.setFailOnError(failOnError);
    }

    public boolean getTransferToAll() {
        return this.config.getTransferToAll();
    }

    public void setTransferToAll(boolean transferToAll) {
        this.config.setTransferToAll(transferToAll);
    }

    public boolean getIgnoreEmpty() {
        return this.config.getIgnoreEmpty();
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.config.setIgnoreEmpty(ignoreEmpty);
    }

    public boolean getSetNullOnMissingSource() {
        return this.config.getSetNullOnMissingSource();
    }

    public void setSetNullOnMissingSource(boolean setNullOnMissingSource) {
        this.config.setSetNullOnMissingSource(setNullOnMissingSource);
    }

    public boolean getTransferTextContent() {
        return this.config.getTransferTextContent();
    }

    public void setTransferTextContent(boolean transferTextContent) {
        this.config.setTransferTextContent(transferTextContent);
    }

    private class PropertyNameChangeListener
    extends WsdlTestStepListenerAdapter {
        private PropertyNameChangeListener() {
        }

        public void propertyRenamed(String oldName, String newName) {
            if (oldName.equals(PropertyTransfer.this.sourceType)) {
                PropertyTransfer.this.sourceType = newName;
                PropertyTransfer.this.config.setSourceType(PropertyTransfer.this.sourceType);
                PropertyTransfer.this.propertyChangeSupport.firePropertyChange(SOURCE_TYPE_PROPERTY, oldName, PropertyTransfer.this.sourceType);
            }
            if (oldName.equals(PropertyTransfer.this.targetType)) {
                PropertyTransfer.this.targetType = newName;
                PropertyTransfer.this.config.setTargetType(PropertyTransfer.this.targetType);
                PropertyTransfer.this.propertyChangeSupport.firePropertyChange(TARGET_TYPE_PROPERTY, oldName, PropertyTransfer.this.targetType);
            }
        }

        public void propertyRemoved(String name) {
            if (name.equals(PropertyTransfer.this.sourceType)) {
                log.warn((Object)("source property for transfer [" + PropertyTransfer.this.getName() + "] in teststep [" + PropertyTransfer.this.testStep.getName() + "] set to null, was [" + name + "]"));
                PropertyTransfer.this.setSourcePropertyName(null);
            }
            if (name.equals(PropertyTransfer.this.targetType)) {
                log.warn((Object)("target property for transfer [" + PropertyTransfer.this.getName() + "] in teststep [" + PropertyTransfer.this.testStep.getName() + "] set to null, was [" + name + "]"));
                PropertyTransfer.this.setTargetPropertyName(null);
            }
        }
    }

    private class StepNameChangeListener
    implements PropertyChangeListener {
        private StepNameChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String oldName = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            if (newValue == null) {
                log.error((Object)"Tried to change stepname to null!");
                Thread.dumpStack();
                return;
            }
            if (oldName.equals(PropertyTransfer.this.sourceStep)) {
                PropertyTransfer.this.sourceStep = newValue;
                PropertyTransfer.this.config.setSourceStep(PropertyTransfer.this.sourceStep);
                PropertyTransfer.this.propertyChangeSupport.firePropertyChange(SOURCE_STEP_PROPERTY, oldName, PropertyTransfer.this.sourceStep);
            }
            if (oldName.equals(PropertyTransfer.this.targetStep)) {
                PropertyTransfer.this.targetStep = newValue;
                PropertyTransfer.this.config.setTargetStep(PropertyTransfer.this.targetStep);
                PropertyTransfer.this.propertyChangeSupport.firePropertyChange(TARGET_STEP_PROPERTY, oldName, PropertyTransfer.this.targetStep);
            }
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == PropertyTransfer.this.testCase) {
                String stepName = testStep.getName();
                if (stepName.equals(PropertyTransfer.this.sourceStep)) {
                    PropertyTransfer.this.setSourceStepName(null);
                }
                if (stepName.equals(PropertyTransfer.this.targetStep)) {
                    PropertyTransfer.this.setTargetStepName(null);
                }
            }
        }
    }
}

