/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.support.PropertiesMap;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.httpclient.HttpState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestCaseRunner
implements Runnable,
TestRunner {
    private TestRunListener[] listeners;
    private final WsdlTestCase testCase;
    private TestRunner.Status status;
    private Throwable error;
    private WsdlTestRunContext runContext;
    private List<TestStepResult> testStepResults = new ArrayList<TestStepResult>();
    private int gotoStepIndex;
    private long startTime;
    private String reason;
    private volatile Future<?> future;
    private int id;
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();
    private static int idCounter = 0;

    public WsdlTestCaseRunner(WsdlTestCase testCase, PropertiesMap properties) {
        this.testCase = testCase;
        this.status = TestRunner.Status.INITIALIZED;
        this.runContext = new WsdlTestRunContext(this, properties);
        this.id = ++idCounter;
    }

    public WsdlTestRunContext getRunContext() {
        return this.runContext;
    }

    @Override
    public void start(boolean async) {
        this.status = TestRunner.Status.RUNNING;
        if (async) {
            this.future = threadPool.submit(this);
        } else {
            this.run();
        }
    }

    @Override
    public void cancel(String reason) {
        if (this.status == TestRunner.Status.CANCELED || this.status == TestRunner.Status.FINISHED || this.status == TestRunner.Status.FAILED || this.runContext == null) {
            return;
        }
        TestStep currentStep = this.runContext.getCurrentStep();
        if (currentStep != null) {
            currentStep.cancel();
        }
        this.status = TestRunner.Status.CANCELED;
        this.reason = reason;
    }

    @Override
    public void fail(String reason) {
        if (this.status == TestRunner.Status.CANCELED || this.status == TestRunner.Status.FAILED || this.runContext == null) {
            return;
        }
        TestStep currentStep = this.runContext.getCurrentStep();
        if (currentStep != null) {
            currentStep.cancel();
        }
        this.status = TestRunner.Status.FAILED;
        this.reason = reason;
    }

    @Override
    public TestRunner.Status getStatus() {
        return this.status;
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        WsdlTestStep[] testSteps = this.testCase.getTestSteps();
        try {
            this.status = TestRunner.Status.RUNNING;
            this.startTime = System.currentTimeMillis();
            this.gotoStepIndex = -1;
            this.testStepResults.clear();
            this.listeners = this.testCase.getTestRunListeners();
            if (this.testCase.getKeepSession()) {
                this.runContext.setProperty("#HTTP_STATE", new HttpState());
            }
            for (WsdlTestStep testStep : testSteps) {
                testStep.prepare(this, this.runContext);
                if (this.status != TestRunner.Status.CANCELED && this.status != TestRunner.Status.FAILED) continue;
                return;
            }
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].beforeRun(this, this.runContext);
                if (this.status != TestRunner.Status.CANCELED && this.status != TestRunner.Status.FAILED) continue;
                return;
            }
            int currentStepIndex = this.runContext.getCurrentStepIndex();
            for (currentStepIndex = 0; this.status != TestRunner.Status.CANCELED && currentStepIndex < testSteps.length; ++currentStepIndex) {
                TestStep currentStep = this.runContext.getCurrentStep();
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].beforeStep(this, this.runContext);
                    if (this.status != TestRunner.Status.CANCELED && this.status != TestRunner.Status.FAILED) continue;
                    return;
                }
                TestStepResult stepResult = currentStep.run(this, this.runContext);
                this.testStepResults.add(stepResult);
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].afterStep(this, this.runContext, stepResult);
                }
                if (stepResult.getStatus() == TestStepResult.TestStepStatus.OK && this.testCase.getDiscardOkResults() && !stepResult.isDiscarded()) {
                    stepResult.discard();
                }
                if (stepResult.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                    if (this.testCase.getFailOnError()) {
                        this.fail("Cancelling due to failed test step");
                    } else {
                        this.runContext.setProperty(TestRunner.Status.class.getName(), (Object)TestRunner.Status.FAILED);
                    }
                }
                if (this.status == TestRunner.Status.CANCELED || this.status == TestRunner.Status.FAILED) {
                    return;
                }
                if (this.gotoStepIndex != -1) {
                    currentStepIndex = this.gotoStepIndex - 1;
                    this.gotoStepIndex = -1;
                }
                this.runContext.setCurrentStep(currentStepIndex + 1);
            }
            if (this.runContext.getProperty(TestRunner.Status.class.getName()) == TestRunner.Status.FAILED && this.testCase.getFailTestCaseOnErrors()) {
                this.fail("Failing due to failed test step");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof OutOfMemoryError && UISupport.confirm("Exit now without saving?", "Out of Memory Error")) {
                System.exit(0);
            }
            this.status = TestRunner.Status.FAILED;
            this.error = t;
        }
        finally {
            if (this.status == TestRunner.Status.RUNNING) {
                this.status = TestRunner.Status.FINISHED;
            }
            for (WsdlTestStep testStep : testSteps) {
                testStep.finish(this, this.runContext);
            }
            this.notifyAfterRun();
        }
    }

    private void notifyAfterRun() {
        if (this.listeners == null || this.listeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].afterRun(this, this.runContext);
        }
    }

    @Override
    public TestCase getTestCase() {
        return this.testCase;
    }

    @Override
    public synchronized TestRunner.Status waitUntilFinished() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                try {
                    this.future.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new RuntimeException("cannot wait on null future");
        }
        return this.getStatus();
    }

    @Override
    public long getTimeTaken() {
        long sum = 0L;
        for (int c = 0; c < this.testStepResults.size(); ++c) {
            TestStepResult testStepResult = this.testStepResults.get(c);
            if (testStepResult == null) continue;
            sum += testStepResult.getTimeTaken();
        }
        return sum;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public Throwable getError() {
        return this.error;
    }

    @Override
    public String getReason() {
        return this.reason == null ? (this.error == null ? null : this.error.toString()) : this.reason;
    }

    @Override
    public List<TestStepResult> getResults() {
        return Collections.unmodifiableList(this.testStepResults);
    }

    @Override
    public void gotoStep(int index) {
        this.gotoStepIndex = index;
    }

    @Override
    public void gotoStepByName(String stepName) {
        TestStep testStep = this.getTestCase().getTestStepByName(stepName);
        if (testStep != null) {
            this.gotoStep(this.getTestCase().getIndexOfTestStep(testStep));
        }
    }
}

