/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.Tools;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;

public class BodyPartAttachment
implements Attachment {
    private final BodyPart bodyPart;
    private File tempFile;

    public BodyPartAttachment(BodyPart bodyPart) {
        this.bodyPart = bodyPart;
    }

    public String getContentType() {
        try {
            return this.bodyPart.getContentType();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.bodyPart.getInputStream();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getName() {
        try {
            String[] header = this.bodyPart.getHeader("Content-Id");
            if (header == null || header.length == 0) {
                return "<missing name>";
            }
            if (header[0].startsWith("<") && header[0].endsWith(">")) {
                header[0] = header[0].substring(1, header[0].length() - 1);
            }
            return header[0];
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPart() {
        return this.getName();
    }

    public long getSize() {
        try {
            return this.bodyPart.getSize();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public String getUrl() {
        if (this.tempFile == null) {
            String contentType = this.getContentType();
            int ix = contentType.lastIndexOf(47);
            int iy = -1;
            if (ix != -1) {
                iy = contentType.indexOf(59, ix);
            }
            try {
                this.tempFile = File.createTempFile("response-attachment", ix == -1 ? ".dat" : "." + (iy == -1 ? contentType.substring(ix + 1) : contentType.substring(ix + 1, iy)));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
                InputStream inputStream = this.getInputStream();
                ((OutputStream)out).write(Tools.readAll(inputStream, 0L).toByteArray());
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                inputStream.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return this.tempFile.toURL().toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setContentType(String contentType) {
    }

    public void setPart(String part) {
    }

    public boolean isCached() {
        return true;
    }

    public Attachment.AttachmentType getAttachmentType() {
        return Attachment.AttachmentType.UNKNOWN;
    }

    public void release() {
    }

    public String getContentID() {
        try {
            String[] header = this.bodyPart.getHeader("Content-ID");
            if (header != null && header.length > 0) {
                return header[0];
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return null;
    }
}

