/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;

public abstract class WsdlMessageExchange
implements MessageExchange {
    private StringToStringMap properties;

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(name, value);
    }

    public StringToStringMap getProperties() {
        return this.properties;
    }

    public boolean hasResponse() {
        String responseContent = this.getResponseContent();
        return responseContent != null && responseContent.trim().length() > 0;
    }

    public abstract WsdlOperation getOperation();

    public Attachment[] getResponseAttachmentsForPart(String name) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment attachment : this.getResponseAttachments()) {
            if (!attachment.getPart().equals(name)) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    public Attachment[] getRequestAttachmentsForPart(String name) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment attachment : this.getRequestAttachments()) {
            if (!attachment.getPart().equals(name)) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    public boolean hasRequest(boolean ignoreEmpty) {
        String requestContent = this.getRequestContent();
        return requestContent != null && (!ignoreEmpty || requestContent.trim().length() != 0);
    }
}

