/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.TestRunComponentEnabler;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GotoTestStepsComboBoxModel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlGotoTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class GotoStepDesktopPanel
extends JPanel
implements DesktopPanel {
    private final WsdlGotoTestStep gotoStep;
    private DefaultListModel listModel;
    private JList conditionList;
    private JTextArea expressionArea;
    private JButton copyButton;
    private JButton deleteButton;
    private JButton declareButton;
    private GotoTestStepsComboBoxModel testStepsModel;
    private JComboBox testStepsCombo;
    private JButton testConditionButton;
    private TestRunComponentEnabler componentEnabler;
    private WsdlGotoTestStep.GotoCondition currentCondition;

    public GotoStepDesktopPanel(WsdlGotoTestStep testStep) {
        super(new BorderLayout());
        this.gotoStep = testStep;
        this.componentEnabler = new TestRunComponentEnabler(testStep.getTestCase());
        this.buildUI();
    }

    public TestRunComponentEnabler getComponentEnabler() {
        return this.componentEnabler;
    }

    public JList getConditionList() {
        return this.conditionList;
    }

    public JButton getCopyButton() {
        return this.copyButton;
    }

    public JButton getDeclareButton() {
        return this.declareButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JTextArea getExpressionArea() {
        return this.expressionArea;
    }

    public WsdlGotoTestStep getGotoStep() {
        return this.gotoStep;
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public JButton getTestConditionButton() {
        return this.testConditionButton;
    }

    public JComboBox getTestStepsCombo() {
        return this.testStepsCombo;
    }

    public GotoTestStepsComboBoxModel getTestStepsModel() {
        return this.testStepsModel;
    }

    private void buildUI() {
        JSplitPane splitPane = UISupport.createHorizontalSplit();
        this.listModel = new DefaultListModel();
        for (int c = 0; c < this.gotoStep.getConditionCount(); ++c) {
            this.listModel.addElement(this.gotoStep.getConditionAt(c).getName());
        }
        this.conditionList = new JList(this.listModel);
        this.conditionList.setSelectionMode(0);
        this.conditionList.addListSelectionListener(new ConditionListSelectionListener());
        JScrollPane listScrollPane = new JScrollPane(this.conditionList);
        listScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Conditions"), BorderFactory.createLineBorder(Color.GRAY)));
        splitPane.setLeftComponent(listScrollPane);
        this.expressionArea = new JUndoableTextArea();
        this.expressionArea.setEnabled(false);
        this.expressionArea.getDocument().addDocumentListener(new SourceAreaDocumentListener());
        JPanel expressionPanel = new JPanel(new BorderLayout());
        expressionPanel.add((Component)new JScrollPane(this.expressionArea), "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("<html><b>Condition XPath Expression</b></html>"));
        builder.addGlue();
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        expressionPanel.add((Component)builder.getPanel(), "North");
        expressionPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        builder = this.buildToolbar();
        expressionPanel.add((Component)builder.getPanel(), "South");
        splitPane.setRightComponent(expressionPanel);
        splitPane.setResizeWeight(0.1);
        splitPane.setDividerLocation(120);
        this.add((Component)splitPane, "Center");
        builder = new ButtonBarBuilder();
        JButton addButton = new JButton(new AddAction());
        builder.addFixed((JComponent)addButton);
        builder.addRelatedGap();
        this.copyButton = new JButton(new CopyAction());
        this.copyButton.setEnabled(false);
        builder.addFixed((JComponent)this.copyButton);
        builder.addRelatedGap();
        this.deleteButton = new JButton(new DeleteAction());
        this.deleteButton.setEnabled(false);
        builder.addFixed((JComponent)this.deleteButton);
        builder.addRelatedGap();
        this.declareButton = new JButton(new DeclareNamespacesAction());
        this.declareButton.setEnabled(false);
        builder.addFixed((JComponent)this.declareButton);
        builder.addRelatedGap();
        JButton runButton = new JButton(new RunAction());
        builder.addFixed((JComponent)runButton);
        builder.addGlue();
        builder.addFixed((JComponent)new JButton(new CloseAction()));
        builder.addRelatedGap();
        builder.addFixed((JComponent)UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/gotostep.html#The_Conditional_Goto_Editor")));
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)builder.getPanel(), "South");
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setPreferredSize(new Dimension(550, 300));
        if (this.listModel.getSize() > 0) {
            this.conditionList.setSelectedIndex(0);
        }
        this.componentEnabler.add(this.conditionList);
        this.componentEnabler.add(this.expressionArea);
        this.componentEnabler.add(this.testStepsCombo);
        this.componentEnabler.add(this.testConditionButton);
        this.componentEnabler.add(this.copyButton);
        this.componentEnabler.add(this.declareButton);
        this.componentEnabler.add(this.deleteButton);
        this.componentEnabler.add(addButton);
        this.componentEnabler.add(runButton);
    }

    protected ButtonBarBuilder buildToolbar() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.testStepsModel = new GotoTestStepsComboBoxModel(this.gotoStep.getTestCase(), null);
        this.testStepsCombo = new JComboBox(this.testStepsModel);
        this.testStepsCombo.setToolTipText("The step the test case will go to if the current condition is true");
        this.testStepsCombo.setEnabled(false);
        builder.addFixed((JComponent)new JLabel("<html><b>Target step:</b></html>"));
        builder.addRelatedGap();
        builder.addFixed((JComponent)this.testStepsCombo);
        builder.addGlue();
        this.testConditionButton = new JButton(new TestConditionAction());
        this.testConditionButton.setEnabled(false);
        builder.addFixed((JComponent)this.testConditionButton);
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return builder;
    }

    public WsdlGotoTestStep getModelItem() {
        return this.gotoStep;
    }

    public boolean onClose(boolean canCancel) {
        this.componentEnabler.release();
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.gotoStep || modelItem == this.gotoStep.getTestCase() || modelItem == this.gotoStep.getTestCase().getTestSuite() || modelItem == this.gotoStep.getTestCase().getTestSuite().getProject();
    }

    public String getTitle() {
        return this.gotoStep.getTestCase().getName() + " - " + this.gotoStep.getName();
    }

    public String getDescription() {
        return "Goto: [" + this.gotoStep.getName() + "] - " + this.gotoStep.getTestStepTitle();
    }

    public Icon getIcon() {
        return this.getModelItem().getIcon();
    }

    public WsdlGotoTestStep.GotoCondition getCurrentCondition() {
        return this.currentCondition;
    }

    protected void enableEditComponents(boolean b) {
        this.expressionArea.setEnabled(b);
        this.testStepsCombo.setEnabled(b);
        this.copyButton.setEnabled(b);
        this.deleteButton.setEnabled(b);
        this.declareButton.setEnabled(b);
        this.testConditionButton.setEnabled(b);
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getDesktop().closeDesktopPanel(GotoStepDesktopPanel.this.gotoStep);
        }
    }

    private final class TestConditionAction
    extends AbstractAction {
        public TestConditionAction() {
            super("Test Condition");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlTestRequestStep previousStep = (WsdlTestRequestStep)GotoStepDesktopPanel.this.gotoStep.getTestCase().findPreviousStepOfType((TestStep)GotoStepDesktopPanel.this.gotoStep, WsdlTestRequestStep.class);
            if (previousStep == null) {
                UISupport.showErrorMessage("Missing previous request step");
            } else {
                if (previousStep.getTestRequest().getResponse() == null || previousStep.getTestRequest().getResponse().getContentAsString().trim().length() == 0) {
                    UISupport.showErrorMessage("Missing response in previous request step [" + previousStep.getName() + "]");
                    return;
                }
                try {
                    WsdlGotoTestStep.GotoCondition condition = GotoStepDesktopPanel.this.gotoStep.getConditionAt(GotoStepDesktopPanel.this.conditionList.getSelectedIndex());
                    boolean evaluate = condition.evaluate(previousStep);
                    if (!evaluate) {
                        UISupport.showInfoMessage("Condition not true for current response in [" + previousStep.getName() + "]");
                    } else {
                        UISupport.showInfoMessage("Condition true for current response in [" + previousStep.getName() + "]");
                    }
                }
                catch (Exception e1) {
                    UISupport.showErrorMessage("Error checking condition: " + e1.getMessage());
                }
            }
        }
    }

    private final class RunAction
    extends AbstractAction {
        public RunAction() {
            super("Run");
        }

        public void actionPerformed(ActionEvent e) {
            if (GotoStepDesktopPanel.this.listModel.getSize() == 0) {
                UISupport.showErrorMessage("Missing conditions!");
                return;
            }
            WsdlTestRequestStep previousStep = (WsdlTestRequestStep)GotoStepDesktopPanel.this.gotoStep.getTestCase().findPreviousStepOfType((TestStep)GotoStepDesktopPanel.this.gotoStep, WsdlTestRequestStep.class);
            if (previousStep == null) {
                UISupport.showErrorMessage("Missing previous request step");
            } else {
                if (previousStep.getTestRequest().getResponse().getContentAsString() == null) {
                    UISupport.showErrorMessage("Missing response in previous message");
                    return;
                }
                WsdlGotoTestStep.GotoCondition target = GotoStepDesktopPanel.this.gotoStep.runConditions(previousStep);
                if (target == null) {
                    UISupport.showInfoMessage("No condition true for current response in [" + previousStep.getName() + "]");
                } else {
                    UISupport.showInfoMessage("Condition triggered for go to [" + target.getTargetStep() + "]");
                }
            }
        }
    }

    private final class DeclareNamespacesAction
    extends AbstractAction {
        public DeclareNamespacesAction() {
            super("Declare");
            this.putValue("ShortDescription", "Declare available response namespaces in condition expression");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                WsdlTestRequestStep previousStep = (WsdlTestRequestStep)GotoStepDesktopPanel.this.gotoStep.getTestCase().findPreviousStepOfType((TestStep)GotoStepDesktopPanel.this.gotoStep, WsdlTestRequestStep.class);
                if (previousStep != null) {
                    String xml;
                    WsdlResponse response = previousStep.getTestRequest().getResponse();
                    String string = xml = response == null ? null : response.getContentAsString();
                    if (xml != null && xml.trim().length() > 0) {
                        GotoStepDesktopPanel.this.expressionArea.setText(XmlUtils.declareXPathNamespaces(xml) + GotoStepDesktopPanel.this.expressionArea.getText());
                    } else {
                        UISupport.showErrorMessage("Missing response in previous request step [" + previousStep.getName() + "]");
                    }
                } else {
                    UISupport.showErrorMessage("Missing previous request step");
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private final class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
        }

        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Delete selected condition", "Delete Condition")) {
                int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
                GotoStepDesktopPanel.this.conditionList.setSelectedIndex(-1);
                GotoStepDesktopPanel.this.gotoStep.removeConditionAt(ix);
                GotoStepDesktopPanel.this.listModel.remove(ix);
                if (GotoStepDesktopPanel.this.listModel.getSize() > 0) {
                    GotoStepDesktopPanel.this.conditionList.setSelectedIndex(ix > GotoStepDesktopPanel.this.listModel.getSize() - 1 ? GotoStepDesktopPanel.this.listModel.getSize() - 1 : ix);
                }
            }
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
        }

        public void actionPerformed(ActionEvent e) {
            int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
            WsdlGotoTestStep.GotoCondition config = GotoStepDesktopPanel.this.gotoStep.getConditionAt(ix);
            String name = UISupport.prompt("Specify name for condition", "Copy Condition", config.getName());
            if (name == null || name.trim().length() == 0) {
                return;
            }
            WsdlGotoTestStep.GotoCondition condition = GotoStepDesktopPanel.this.gotoStep.addCondition(name);
            condition.setExpression(config.getExpression());
            condition.setTargetStep(config.getTargetStep());
            condition.setType(config.getType());
            GotoStepDesktopPanel.this.listModel.addElement(name);
            GotoStepDesktopPanel.this.conditionList.setSelectedIndex(GotoStepDesktopPanel.this.listModel.getSize() - 1);
        }
    }

    private final class AddAction
    extends AbstractAction {
        public AddAction() {
            super("Add");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify name for condition", "Add Condition", "Condition " + (GotoStepDesktopPanel.this.gotoStep.getConditionCount() + 1));
            if (name == null || name.trim().length() == 0) {
                return;
            }
            GotoStepDesktopPanel.this.gotoStep.addCondition(name);
            GotoStepDesktopPanel.this.listModel.addElement(name);
            GotoStepDesktopPanel.this.conditionList.setSelectedIndex(GotoStepDesktopPanel.this.listModel.getSize() - 1);
        }
    }

    private final class ConditionListSelectionListener
    implements ListSelectionListener {
        private ConditionListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
            if (ix == -1) {
                GotoStepDesktopPanel.this.expressionArea.setText("");
                GotoStepDesktopPanel.this.testStepsModel.setCondition(null);
                GotoStepDesktopPanel.this.currentCondition = null;
            } else {
                GotoStepDesktopPanel.this.currentCondition = GotoStepDesktopPanel.this.gotoStep.getConditionAt(ix);
                GotoStepDesktopPanel.this.expressionArea.setText(GotoStepDesktopPanel.this.currentCondition.getExpression());
                GotoStepDesktopPanel.this.testStepsModel.setCondition(GotoStepDesktopPanel.this.currentCondition);
            }
            boolean b = ix != -1;
            GotoStepDesktopPanel.this.enableEditComponents(b);
        }
    }

    private final class SourceAreaDocumentListener
    extends DocumentListenerAdapter {
        private SourceAreaDocumentListener() {
        }

        public void update(Document document) {
            int ix = GotoStepDesktopPanel.this.conditionList.getSelectedIndex();
            if (ix != -1) {
                GotoStepDesktopPanel.this.gotoStep.getConditionAt(ix).setExpression(GotoStepDesktopPanel.this.expressionArea.getText());
            }
        }
    }
}

