/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import java.awt.Color;
import javax.swing.JProgressBar;

public class ProgressBarAdapter {
    private final JProgressBar progressBar;
    private final WsdlTestCase testCase;
    private InternalTestRunListener internalTestRunListener;
    private InternalTestMonitorListener internalTestMonitorListener;

    public ProgressBarAdapter(JProgressBar progressBar, WsdlTestCase testCase) {
        this.progressBar = progressBar;
        this.testCase = testCase;
        this.setLoadTestingState();
        this.internalTestRunListener = new InternalTestRunListener();
        testCase.addTestRunListener(this.internalTestRunListener);
        this.internalTestMonitorListener = new InternalTestMonitorListener();
        SoapUI.getTestMonitor().addTestMonitorListener(this.internalTestMonitorListener);
    }

    private void setLoadTestingState() {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(this.testCase)) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setString("loadTesting");
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setString("");
        }
    }

    public class InternalTestRunListener
    implements TestRunListener {
        public void beforeRun(TestRunner testRunner, TestRunContext runContext) {
            if (ProgressBarAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            ProgressBarAdapter.this.progressBar.getModel().setMaximum(testRunner.getTestCase().getTestStepCount());
            ProgressBarAdapter.this.progressBar.setForeground(Color.GREEN.darker());
        }

        public void beforeStep(TestRunner testRunner, TestRunContext runContext) {
            if (ProgressBarAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            TestStep testStep = runContext.getCurrentStep();
            ProgressBarAdapter.this.progressBar.setString(testStep.getName());
            ProgressBarAdapter.this.progressBar.setValue(runContext.getCurrentStepIndex());
        }

        public void afterStep(TestRunner testRunner, TestRunContext runContext, TestStepResult result) {
            if (ProgressBarAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            if (result.getStatus() == TestStepResult.TestStepStatus.FAILED) {
                ProgressBarAdapter.this.progressBar.setForeground(Color.RED);
            } else if (!ProgressBarAdapter.this.testCase.getFailTestCaseOnErrors()) {
                ProgressBarAdapter.this.progressBar.setForeground(Color.GREEN.darker());
            }
            ProgressBarAdapter.this.progressBar.setValue(runContext.getCurrentStepIndex() + 1);
        }

        public void afterRun(TestRunner testRunner, TestRunContext runContext) {
            if (!ProgressBarAdapter.this.testCase.getFailOnError() && !ProgressBarAdapter.this.testCase.getFailTestCaseOnErrors()) {
                ProgressBarAdapter.this.progressBar.setForeground(Color.GREEN.darker());
            }
            if (ProgressBarAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            ProgressBarAdapter.this.progressBar.setString(testRunner.getStatus().toString());
        }
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        public void loadTestStarted(LoadTestRunner loadTestRunner) {
            ProgressBarAdapter.this.setLoadTestingState();
        }

        public void loadTestFinished(LoadTestRunner loadTestRunner) {
            ProgressBarAdapter.this.setLoadTestingState();
        }
    }
}

