/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.registry;

import com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.registry.XmlEditorViewFactory;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.source.XmlSourceEditorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XmlEditorViewRegistry {
    private static XmlEditorViewRegistry instance;
    private List<XmlEditorViewFactory> factories = new ArrayList<XmlEditorViewFactory>();

    public XmlEditorViewRegistry() {
        this.addFactory(new XmlSourceEditorFactory());
    }

    public void addFactory(XmlEditorViewFactory factory) {
        this.factories.add(factory);
    }

    public void setFactory(String viewId, XmlEditorViewFactory factory) {
        for (int c = 0; c < this.factories.size(); ++c) {
            if (!this.factories.get(c).getViewId().equals(viewId)) continue;
            this.factories.set(c, factory);
        }
    }

    public static final XmlEditorViewRegistry getInstance() {
        if (instance == null) {
            instance = new XmlEditorViewRegistry();
        }
        return instance;
    }

    public XmlEditorViewFactory[] getFactories() {
        return this.factories.toArray(new XmlEditorViewFactory[this.factories.size()]);
    }

    public XmlEditorViewFactory[] getFactoriesOfType(Class type) {
        ArrayList<XmlEditorViewFactory> result = new ArrayList<XmlEditorViewFactory>();
        for (XmlEditorViewFactory factory : this.factories) {
            if (!Arrays.asList(factory.getClass().getInterfaces()).contains(type)) continue;
            result.add(factory);
        }
        return result.toArray(new XmlEditorViewFactory[result.size()]);
    }
}

