/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation.actions;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.iface.AbstractSwingAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenRequestForMockOperationAction
extends AbstractSwingAction<WsdlMockOperation> {
    public OpenRequestForMockOperationAction(WsdlMockOperation mockOperation) {
        super("Open Request", "Opens/Creates a request for this MockOperation with correct endpoint", mockOperation);
        this.putValue("SmallIcon", UISupport.createImageIcon("/open_request.gif"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0, WsdlMockOperation mockOperation) {
        WsdlOperation operation = mockOperation.getOperation();
        if (operation == null) {
            UISupport.showErrorMessage("Missing operation for this mock response");
            return;
        }
        String[] names = ModelSupport.getNames(operation.getRequests(), new String[]{"-> Create New"});
        String name = UISupport.prompt("Select Request for Operation [" + operation.getName() + "] " + "to open or create", "Open Request", names);
        if (name != null) {
            WsdlRequest request = operation.getRequestByName(name);
            if (request == null) {
                name = UISupport.prompt("Specify name of new request", "Open Request", "Request " + (operation.getRequestCount() + 1));
                if (name == null) {
                    return;
                }
                boolean createOptional = operation.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS);
                if (!createOptional) {
                    createOptional = UISupport.confirm("Create optional elements from schema?", "Create Request");
                }
                request = operation.addNewRequest(name);
                String requestContent = operation.createRequest(createOptional);
                if (requestContent != null) {
                    request.setRequestContent(requestContent);
                }
            }
            request.setEndpoint(mockOperation.getMockService().getLocalEndpoint());
            UISupport.selectAndShow(request);
        }
    }
}

