/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation.actions;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public class CreateFaultMockResponseAction
extends AbstractAction {
    private final WsdlMockResponse mockResponse;

    public CreateFaultMockResponseAction(WsdlMockResponse mockResponse) {
        super("Create Fault");
        this.mockResponse = mockResponse;
        this.putValue("SmallIcon", UISupport.createImageIcon("/create_empty_fault.gif"));
        this.putValue("ShortDescription", "Creates an SOAP Fault response");
    }

    public void actionPerformed(ActionEvent e) {
        WsdlOperation operation = this.mockResponse.getMockOperation().getOperation();
        if (operation == null) {
            UISupport.showErrorMessage("Missing operation for this mock response");
            return;
        }
        if (UISupport.confirm("Overwrite current response with empty Fault message", "Create Fault")) {
            WsdlInterface iface = operation.getInterface();
            MessagePart[] faultParts = operation.getFaultParts();
            if (faultParts != null && faultParts.length > 0) {
                ArrayList<String> names = new ArrayList<String>();
                for (int c = 0; c < faultParts.length; ++c) {
                    names.add(faultParts[0].getName());
                }
                String faultName = (String)UISupport.prompt("Select fault detail to generate", "Create Fault", names);
                if (faultName != null) {
                    MessagePart.FaultPart faultPart = (MessagePart.FaultPart)faultParts[names.indexOf(faultName)];
                    this.mockResponse.setResponseContent(iface.getMessageBuilder().buildFault(faultPart));
                }
            } else {
                this.mockResponse.setResponseContent(iface.getMessageBuilder().buildEmptyFault());
            }
        }
    }
}

