/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.config.DispatchStyleConfig;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.actions.mockoperation.NewMockResponseAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.panels.mock.ModelItemListMouseListener;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.OpenRequestForMockOperationAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.util.ModelItemNames;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.ExtendedComboBoxModel;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockOperationDesktopPanel
extends ModelItemDesktopPanel<WsdlMockOperation> {
    private JList responseList;
    private JComboBox interfaceCombo;
    private JComboBox operationCombo;
    private JComboBox dispatchCombo;
    private JPanel dispatchPanel;
    private InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private InternalProjectListener projectListener = new InternalProjectListener();
    private WsdlInterface currentInterface;
    private JPanel groovyEditorPanel;
    private JPanel xpathEditorPanel;
    private JComboBox defaultResponseCombo;
    private JSplitPane splitPane;
    private ResponseListModel responseListModel;
    private GroovyEditor xpathEditor;
    private GroovyEditor groovyEditor;

    public WsdlMockOperationDesktopPanel(WsdlMockOperation mockOperation) {
        super(mockOperation);
        this.buildUI();
        this.setPreferredSize(new Dimension(600, 440));
        mockOperation.getMockService().getProject().addProjectListener(this.projectListener);
        WsdlOperation operation = ((WsdlMockOperation)this.getModelItem()).getOperation();
        if (operation != null) {
            this.currentInterface = operation.getInterface();
            this.currentInterface.addInterfaceListener(this.interfaceListener);
        }
    }

    private void buildUI() {
        this.add(this.buildToolbar(), "North");
        this.splitPane = UISupport.createVerticalSplit();
        this.splitPane.setTopComponent(this.buildResponseList());
        this.splitPane.setBottomComponent(this.buildDispatchEditor());
        this.splitPane.setDividerLocation(0.5);
        this.splitPane.setDividerLocation(150);
        this.add((Component)this.splitPane, "Center");
    }

    private Component buildResponseList() {
        this.responseListModel = new ResponseListModel();
        this.responseList = new JList(this.responseListModel);
        this.responseList.addMouseListener(new ModelItemListMouseListener());
        this.responseList.setCellRenderer(new ResponseListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.responseList);
        UISupport.addTitledBorder(scrollPane, "Reponses");
        return scrollPane;
    }

    private Component buildDispatchEditor() {
        this.buildGroovyEditor();
        this.buildXPathEditor();
        this.dispatchPanel = new JPanel(new BorderLayout());
        this.dispatchPanel.setOpaque(true);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JLabel("Dispatch: "));
        builder.addRelatedGap();
        this.dispatchCombo = new JComboBox<Object>(new Object[]{"Sequence", "Random", "XPath", "Script"});
        this.dispatchCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String item;
                if (WsdlMockOperationDesktopPanel.this.dispatchPanel.getComponentCount() > 1) {
                    WsdlMockOperationDesktopPanel.this.dispatchPanel.remove(1);
                }
                if ((item = (String)WsdlMockOperationDesktopPanel.this.dispatchCombo.getSelectedItem()).equalsIgnoreCase("Script")) {
                    ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDispatchStyle(DispatchStyleConfig.SCRIPT);
                    WsdlMockOperationDesktopPanel.this.dispatchPanel.add(WsdlMockOperationDesktopPanel.this.groovyEditorPanel);
                    WsdlMockOperationDesktopPanel.this.groovyEditor.getEditArea().setText(((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getDispatchPath());
                    WsdlMockOperationDesktopPanel.this.defaultResponseCombo.setEnabled(true);
                } else if (item.equalsIgnoreCase("XPath")) {
                    ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDispatchStyle(DispatchStyleConfig.XPATH);
                    WsdlMockOperationDesktopPanel.this.dispatchPanel.add(WsdlMockOperationDesktopPanel.this.xpathEditorPanel);
                    WsdlMockOperationDesktopPanel.this.xpathEditor.getEditArea().setText(((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getDispatchPath());
                    WsdlMockOperationDesktopPanel.this.defaultResponseCombo.setEnabled(true);
                } else if (item.equalsIgnoreCase("Sequence")) {
                    ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDispatchStyle(DispatchStyleConfig.SEQUENCE);
                    WsdlMockOperationDesktopPanel.this.defaultResponseCombo.setEnabled(false);
                } else if (item.equalsIgnoreCase("Random")) {
                    ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDispatchStyle(DispatchStyleConfig.RANDOM);
                    WsdlMockOperationDesktopPanel.this.defaultResponseCombo.setEnabled(false);
                }
                WsdlMockOperationDesktopPanel.this.dispatchPanel.revalidate();
                WsdlMockOperationDesktopPanel.this.dispatchPanel.repaint();
            }
        });
        builder.addFixed((JComponent)this.dispatchCombo);
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JLabel("Default Response: "));
        builder.addRelatedGap();
        ModelItemNames<MockResponse> names = new ModelItemNames<MockResponse>(((WsdlMockOperation)this.getModelItem()).getMockResponses());
        this.defaultResponseCombo = new JComboBox(new ExtendedComboBoxModel(names.getNames()));
        this.defaultResponseCombo.setPreferredSize(new Dimension(150, 20));
        this.defaultResponseCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object selectedItem = WsdlMockOperationDesktopPanel.this.defaultResponseCombo.getSelectedItem();
                ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDefaultResponse((String)selectedItem);
            }
        });
        builder.addFixed((JComponent)this.defaultResponseCombo);
        builder.setBorder(BorderFactory.createEmptyBorder(2, 3, 3, 3));
        this.dispatchPanel.add((Component)builder.getPanel(), "North");
        this.defaultResponseCombo.setSelectedItem(((WsdlMockOperation)this.getModelItem()).getDefaultResponse());
        DispatchStyleConfig.Enum dispatchStyle = ((WsdlMockOperation)this.getModelItem()).getDispatchStyle();
        if (dispatchStyle.equals(DispatchStyleConfig.SEQUENCE)) {
            this.dispatchCombo.setSelectedItem("Sequence");
            this.defaultResponseCombo.setEnabled(false);
        } else if (dispatchStyle.equals(DispatchStyleConfig.RANDOM)) {
            this.dispatchCombo.setSelectedItem("Random");
            this.defaultResponseCombo.setEnabled(false);
        } else if (dispatchStyle.equals(DispatchStyleConfig.SCRIPT)) {
            this.dispatchCombo.setSelectedItem("Script");
        } else if (dispatchStyle.equals(DispatchStyleConfig.XPATH)) {
            this.dispatchCombo.setSelectedItem("XPath");
        }
        return this.dispatchPanel;
    }

    private void buildXPathEditor() {
        this.xpathEditorPanel = new JPanel(new BorderLayout());
        DispatchXPathGroovyEditorModel editorModel = new DispatchXPathGroovyEditorModel();
        this.xpathEditor = new GroovyEditor(editorModel);
        this.xpathEditorPanel.add((Component)new JScrollPane(this.xpathEditor), "Center");
        this.xpathEditorPanel.add((Component)this.buildXPathEditorToolbar(editorModel), "First");
    }

    public GroovyEditor getXPathEditor() {
        return this.xpathEditor;
    }

    protected JXToolBar buildXPathEditorToolbar(DispatchXPathGroovyEditorModel editorModel) {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(UISupport.createToolbarButton(editorModel.getRunAction()));
        toolbar.addGlue();
        toolbar.addFixed(this.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/operations.html#XPath_Dispatching"), true));
        return toolbar;
    }

    private void buildGroovyEditor() {
        this.groovyEditorPanel = new JPanel(new BorderLayout());
        DispatchScriptGroovyEditorModel editorModel = new DispatchScriptGroovyEditorModel();
        this.groovyEditor = new GroovyEditor(editorModel);
        this.groovyEditorPanel.add((Component)new JScrollPane(this.groovyEditor), "Center");
        this.groovyEditorPanel.add((Component)this.buildGroovyEditorToolbar(editorModel), "First");
    }

    protected JXToolBar buildGroovyEditorToolbar(DispatchScriptGroovyEditorModel editorModel) {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(UISupport.createToolbarButton(editorModel.getRunAction()));
        toolbar.addGlue();
        JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code>, <code>mockRequest</code> and <code>mockResponse</code> variables</html>");
        label.setToolTipText(label.getText());
        label.setMaximumSize(label.getPreferredSize());
        toolbar.add(label);
        toolbar.addFixed(this.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/operations.html#Script_Dispatching"), true));
        return toolbar;
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addSpace(3);
        toolbar.addFixed(UISupport.createToolbarButton(new NewMockResponseAction((WsdlMockOperation)this.getModelItem())));
        toolbar.addFixed(UISupport.createToolbarButton(new OpenRequestForMockOperationAction((WsdlMockOperation)this.getModelItem())));
        toolbar.addUnrelatedGap();
        ModelItemNames<Interface> names = new ModelItemNames<Interface>(((WsdlMockOperation)this.getModelItem()).getMockService().getProject().getInterfaces());
        this.interfaceCombo = new JComboBox<String>(names.getNames());
        this.interfaceCombo.setSelectedIndex(-1);
        this.interfaceCombo.addItemListener(new InterfaceComboListener());
        toolbar.addLabeledFixed("Interface", this.interfaceCombo);
        toolbar.addUnrelatedGap();
        this.operationCombo = new JComboBox(new ExtendedComboBoxModel());
        this.operationCombo.setPreferredSize(new Dimension(150, 20));
        this.operationCombo.addItemListener(new OperationComboListener());
        toolbar.addLabeledFixed("Operation", this.operationCombo);
        WsdlOperation operation = ((WsdlMockOperation)this.getModelItem()).getOperation();
        this.interfaceCombo.setSelectedItem(operation == null ? null : operation.getInterface().getName());
        this.operationCombo.setSelectedItem(operation == null ? null : operation.getName());
        toolbar.addGlue();
        toolbar.addFixed(this.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/operations.html"), true));
        return toolbar;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (this.currentInterface != null) {
            this.currentInterface.removeInterfaceListener(this.interfaceListener);
        }
        ((WsdlMockOperation)this.getModelItem()).getMockService().getProject().removeProjectListener(this.projectListener);
        this.responseListModel.release();
        return true;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlMockOperation)this.getModelItem()).getMockService() || modelItem == ((WsdlMockOperation)this.getModelItem()).getMockService().getProject();
    }

    private class RunXPathAction
    extends AbstractAction {
        public RunXPathAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Evaluates this xpath expression against the latest request");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlMockResult lastMockResult = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getLastMockResult();
            if (lastMockResult == null) {
                UISupport.showErrorMessage("Missing last request to select from");
                return;
            }
            try {
                XmlObject[] retVal = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).evaluateDispatchXPath(lastMockResult.getMockRequest());
                StringList list = new StringList();
                for (XmlObject xmlObject : retVal) {
                    list.add(XmlUtils.getNodeValue(xmlObject.getDomNode()));
                }
                UISupport.showInfoMessage("XPath returned " + list.toString());
            }
            catch (XmlException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class RunScriptAction
    extends AbstractAction {
        public RunScriptAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Runs this script using a mockRequest and context");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlMockResult lastMockResult = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getLastMockResult();
            WsdlMockRequest mockRequest = lastMockResult == null ? null : lastMockResult.getMockRequest();
            try {
                Object retVal = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).evaluateDispatchScript(mockRequest);
                UISupport.showInfoMessage("Script returned [" + retVal + "]");
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private static final class ResponseListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ResponseListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MockResponse testStep = (MockResponse)value;
            this.setText(testStep.getName());
            this.setIcon(testStep.getIcon());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            return this;
        }
    }

    public class ResponseListModel
    extends AbstractListModel
    implements ListModel,
    MockServiceListener,
    PropertyChangeListener {
        private List<WsdlMockResponse> responses = new ArrayList<WsdlMockResponse>();

        public ResponseListModel() {
            for (int c = 0; c < ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockResponseCount(); ++c) {
                WsdlMockResponse mockResponse = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockResponseAt(c);
                mockResponse.addPropertyChangeListener(this);
                this.responses.add(mockResponse);
            }
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().addMockServiceListener(this);
        }

        public Object getElementAt(int arg0) {
            return this.responses.get(arg0);
        }

        public int getSize() {
            return this.responses.size();
        }

        public void mockOperationAdded(MockOperation operation) {
        }

        public void mockOperationRemoved(MockOperation operation) {
        }

        public void mockResponseAdded(MockResponse response) {
            this.responses.add((WsdlMockResponse)response);
            response.addPropertyChangeListener(this);
            this.fireIntervalAdded(this, this.responses.size() - 1, this.responses.size() - 1);
            WsdlMockOperationDesktopPanel.this.defaultResponseCombo.addItem(response.getName());
        }

        public void mockResponseRemoved(MockResponse response) {
            int ix = this.responses.indexOf(response);
            this.responses.remove(ix);
            response.removePropertyChangeListener(this);
            this.fireIntervalRemoved(this, ix, ix);
            WsdlMockOperationDesktopPanel.this.defaultResponseCombo.removeItem(response.getName());
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getPropertyName().equals(WsdlMockOperation.NAME_PROPERTY)) {
                int ix = this.responses.indexOf(arg0.getSource());
                this.fireContentsChanged(this, ix, ix);
                ExtendedComboBoxModel model = (ExtendedComboBoxModel)WsdlMockOperationDesktopPanel.this.defaultResponseCombo.getModel();
                model.setElementAt(arg0.getNewValue(), ix);
                if (model.getSelectedItem().equals(arg0.getOldValue())) {
                    model.setSelectedItem(arg0.getNewValue());
                }
            }
        }

        public void release() {
            for (WsdlMockResponse operation : this.responses) {
                operation.removePropertyChangeListener(this);
            }
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().removeMockServiceListener(this);
        }
    }

    public class DispatchXPathGroovyEditorModel
    implements GroovyEditorModel {
        private RunXPathAction runXPathAction;

        public DispatchXPathGroovyEditorModel() {
            this.runXPathAction = new RunXPathAction();
        }

        public String[] getKeywords() {
            return new String[]{"define", "namespace"};
        }

        public Action getRunAction() {
            return this.runXPathAction;
        }

        public String getScript() {
            return ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getDispatchPath();
        }

        public Settings getSettings() {
            return ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getSettings();
        }

        public void setScript(String text) {
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDispatchPath(text);
        }
    }

    public class DispatchScriptGroovyEditorModel
    implements GroovyEditorModel {
        private RunScriptAction runScriptAction;

        public DispatchScriptGroovyEditorModel() {
            this.runScriptAction = new RunScriptAction();
        }

        public String[] getKeywords() {
            return new String[]{"mockRequest", "context"};
        }

        public Action getRunAction() {
            return this.runScriptAction;
        }

        public String getScript() {
            return ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getDispatchPath();
        }

        public Settings getSettings() {
            return ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getSettings();
        }

        public void setScript(String text) {
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setDispatchPath(text);
        }
    }

    private final class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        private InternalInterfaceListener() {
        }

        public void operationAdded(Operation operation) {
            WsdlMockOperationDesktopPanel.this.operationCombo.addItem(operation.getName());
        }

        public void operationRemoved(Operation operation) {
            Object selectedItem = WsdlMockOperationDesktopPanel.this.operationCombo.getSelectedItem();
            WsdlMockOperationDesktopPanel.this.operationCombo.removeItem(operation.getName());
            if (selectedItem.equals(operation.getName())) {
                ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(null);
                WsdlMockOperationDesktopPanel.this.interfaceCombo.setSelectedIndex(-1);
            }
        }

        public void operationUpdated(Operation operation) {
            ExtendedComboBoxModel model = (ExtendedComboBoxModel)WsdlMockOperationDesktopPanel.this.operationCombo.getModel();
            int ix = model.getIndexOf(operation.getName());
            if (ix != -1) {
                model.setElementAt(operation.getName(), ix);
            }
        }
    }

    private final class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        public void interfaceAdded(Interface iface) {
            WsdlMockOperationDesktopPanel.this.interfaceCombo.addItem(iface.getName());
        }

        public void interfaceRemoved(Interface iface) {
            if (WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem().equals(iface.getName())) {
                ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(null);
            }
        }
    }

    private final class InterfaceComboListener
    implements ItemListener {
        private InterfaceComboListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            Object selectedItem;
            if (WsdlMockOperationDesktopPanel.this.currentInterface != null) {
                WsdlMockOperationDesktopPanel.this.currentInterface.removeInterfaceListener(WsdlMockOperationDesktopPanel.this.interfaceListener);
            }
            if ((selectedItem = WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem()) == null) {
                WsdlMockOperationDesktopPanel.this.operationCombo.setModel(new DefaultComboBoxModel());
                WsdlMockOperationDesktopPanel.this.currentInterface = null;
            } else {
                WsdlMockOperationDesktopPanel.this.currentInterface = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().getProject().getInterfaceByName(selectedItem.toString());
                ModelItemNames<Operation> names = new ModelItemNames<Operation>(WsdlMockOperationDesktopPanel.this.currentInterface.getOperations());
                WsdlMockOperationDesktopPanel.this.operationCombo.setModel(new DefaultComboBoxModel<String>(names.getNames()));
                WsdlMockOperationDesktopPanel.this.currentInterface.addInterfaceListener(WsdlMockOperationDesktopPanel.this.interfaceListener);
            }
        }
    }

    private final class OperationComboListener
    implements ItemListener {
        private OperationComboListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            WsdlInterface iface = ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).getMockService().getProject().getInterfaceByName(WsdlMockOperationDesktopPanel.this.interfaceCombo.getSelectedItem().toString());
            WsdlOperation operation = iface.getOperationByName(WsdlMockOperationDesktopPanel.this.operationCombo.getSelectedItem().toString());
            ((WsdlMockOperation)WsdlMockOperationDesktopPanel.this.getModelItem()).setOperation(operation);
        }
    }
}

