/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.loadtest;

import com.eviware.soapui.impl.wsdl.loadtest.LoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.LoadTestListener;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.LoadTestAssertionRegistry;
import com.eviware.soapui.impl.wsdl.support.Configurable;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class JLoadTestAssertionsTable
extends JPanel {
    private JXTable table;
    private final WsdlLoadTest loadTest;
    private ConfigureAssertionAction configureAssertionAction;
    private RemoveAssertionAction removeAssertionAction;
    private AddLoadTestAssertionAction addLoadTestAssertionAction;
    private LoadTestAssertionsTableModel tableModel;
    private JPopupMenu assertionPopup;
    private InternalLoadTestListener internalLoadTestListener = new InternalLoadTestListener();

    public JLoadTestAssertionsTable(WsdlLoadTest wsdlLoadTest) {
        super(new BorderLayout());
        this.loadTest = wsdlLoadTest;
        this.loadTest.addLoadTestListener(this.internalLoadTestListener);
        this.tableModel = new LoadTestAssertionsTableModel();
        this.table = new JXTable((TableModel)this.tableModel);
        this.table.setSelectionMode(0);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setMaxWidth(16);
        columnModel.getColumn(0).setCellRenderer(new IconTableCellRenderer());
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(2).setPreferredWidth(100);
        columnModel.getColumn(3).setPreferredWidth(200);
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.add((Component)scrollPane, "Center");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                int ix = JLoadTestAssertionsTable.this.table.getSelectedRow();
                if (ix == -1) {
                    return;
                }
                ix = JLoadTestAssertionsTable.this.table.convertRowIndexToModel(ix);
                LoadTestAssertion obj = JLoadTestAssertionsTable.this.loadTest.getAssertionAt(ix);
                if (obj instanceof Configurable) {
                    ((Configurable)((Object)obj)).configure();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.add((Component)this.buildToolbar(), "North");
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int ix = JLoadTestAssertionsTable.this.table.getSelectedRow();
                JLoadTestAssertionsTable.this.configureAssertionAction.setEnabled(ix >= 0);
                JLoadTestAssertionsTable.this.removeAssertionAction.setEnabled(ix >= 0);
                if (ix == -1) {
                    return;
                }
                ix = JLoadTestAssertionsTable.this.table.convertRowIndexToModel(ix);
                JLoadTestAssertionsTable.this.configureAssertionAction.setEnabled(JLoadTestAssertionsTable.this.loadTest.getAssertionAt(ix) instanceof Configurable);
            }
        });
        this.assertionPopup = new JPopupMenu();
        this.assertionPopup.add(this.configureAssertionAction);
        this.assertionPopup.addSeparator();
        this.assertionPopup.add(this.addLoadTestAssertionAction);
        this.assertionPopup.add(this.removeAssertionAction);
        this.setComponentPopupMenu(this.assertionPopup);
        scrollPane.setInheritsPopupMenu(true);
        this.table.setComponentPopupMenu(this.assertionPopup);
    }

    public void addNotify() {
        super.addNotify();
        this.loadTest.removeLoadTestListener(this.internalLoadTestListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.loadTest.removeLoadTestListener(this.internalLoadTestListener);
    }

    public void release() {
        this.tableModel.release();
    }

    private JComponent buildToolbar() {
        this.configureAssertionAction = new ConfigureAssertionAction();
        this.removeAssertionAction = new RemoveAssertionAction();
        this.addLoadTestAssertionAction = new AddLoadTestAssertionAction();
        JXToolBar toolbar = UISupport.createToolbar();
        JButton button = UISupport.createToolbarButton(this.addLoadTestAssertionAction);
        button.setText(null);
        toolbar.addFixed(button);
        button = UISupport.createToolbarButton(this.removeAssertionAction);
        button.setText(null);
        toolbar.addFixed(button);
        button = UISupport.createToolbarButton(this.configureAssertionAction);
        button.setText(null);
        toolbar.addFixed(button);
        toolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        return toolbar;
    }

    public class InternalLoadTestListener
    implements LoadTestListener {
        public void assertionAdded(LoadTestAssertion assertion) {
            JLoadTestAssertionsTable.this.tableModel.assertionAdded(assertion);
            JLoadTestAssertionsTable.this.table.getSelectionModel().setSelectionInterval(JLoadTestAssertionsTable.this.tableModel.getRowCount() - 1, JLoadTestAssertionsTable.this.tableModel.getRowCount() - 1);
        }

        public void assertionRemoved(LoadTestAssertion assertion) {
            JLoadTestAssertionsTable.this.tableModel.assertionRemoved(assertion);
        }
    }

    public class RemoveAssertionAction
    extends AbstractAction {
        public RemoveAssertionAction() {
            super("Remove Assertion");
            this.putValue("ShortDescription", "Removes the selected assertion from this LoadTest");
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_assertion.gif"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int ix = JLoadTestAssertionsTable.this.table.getSelectedRow();
            if (ix == -1) {
                return;
            }
            ix = JLoadTestAssertionsTable.this.table.convertRowIndexToModel(ix);
            LoadTestAssertion assertion = JLoadTestAssertionsTable.this.loadTest.getAssertionAt(ix);
            if (UISupport.confirm("Remove assertion [" + assertion.getName() + "]", "Remove Assertion")) {
                JLoadTestAssertionsTable.this.loadTest.removeAssertion(assertion);
            }
        }
    }

    public class ConfigureAssertionAction
    extends AbstractAction {
        ConfigureAssertionAction() {
            super("Configure");
            this.putValue("ShortDescription", "Configures the selection assertion");
            this.putValue("SmallIcon", UISupport.createImageIcon("/options.gif"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int ix = JLoadTestAssertionsTable.this.table.getSelectedRow();
            if (ix == -1) {
                return;
            }
            ix = JLoadTestAssertionsTable.this.table.convertRowIndexToModel(ix);
            LoadTestAssertion obj = JLoadTestAssertionsTable.this.loadTest.getAssertionAt(ix);
            if (obj instanceof Configurable) {
                ((Configurable)((Object)obj)).configure();
                JLoadTestAssertionsTable.this.tableModel.fireTableRowsUpdated(ix, ix);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public class AddLoadTestAssertionAction
    extends AbstractAction {
        public AddLoadTestAssertionAction() {
            super("Add Assertion");
            this.putValue("ShortDescription", "Adds an assertion to this LoadTest");
            this.putValue("SmallIcon", UISupport.createImageIcon("/addAssertion.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            String[] types = LoadTestAssertionRegistry.getAvailableAssertions();
            String type = UISupport.prompt("Select assertion type to add", "Add Assertion", types);
            if (type != null) {
                JLoadTestAssertionsTable.this.loadTest.addAssertion(type, "- Any -", true);
            }
        }
    }

    private static final class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        private IconTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setIcon((Icon)value);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadTestAssertionsTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public LoadTestAssertionsTableModel() {
            for (int c = 0; c < JLoadTestAssertionsTable.this.loadTest.getAssertionCount(); ++c) {
                JLoadTestAssertionsTable.this.loadTest.getAssertionAt(c).addPropertyChangeListener(LoadTestAssertion.CONFIGURATION_PROPERTY, this);
            }
        }

        public void release() {
            for (int c = 0; c < JLoadTestAssertionsTable.this.loadTest.getAssertionCount(); ++c) {
                JLoadTestAssertionsTable.this.loadTest.getAssertionAt(c).removePropertyChangeListener(LoadTestAssertion.CONFIGURATION_PROPERTY, this);
            }
        }

        @Override
        public int getRowCount() {
            return JLoadTestAssertionsTable.this.loadTest.getAssertionCount();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ImageIcon.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Step";
                }
                case 3: {
                    return "Details";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            LoadTestAssertion assertion = JLoadTestAssertionsTable.this.loadTest.getAssertionAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return assertion.getIcon();
                }
                case 1: {
                    return assertion.getName();
                }
                case 2: {
                    return assertion.getTargetStep();
                }
                case 3: {
                    return assertion.getDescription();
                }
            }
            return null;
        }

        public void assertionRemoved(LoadTestAssertion assertion) {
            assertion.removePropertyChangeListener(LoadTestAssertion.CONFIGURATION_PROPERTY, this);
            this.fireTableDataChanged();
        }

        public void assertionAdded(LoadTestAssertion assertion) {
            assertion.addPropertyChangeListener(LoadTestAssertion.CONFIGURATION_PROPERTY, this);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireTableDataChanged();
        }
    }
}

