/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.attachments;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.attachments.AttachmentTableModel;
import com.eviware.soapui.impl.wsdl.panels.attachments.ContentTypeHandler;
import com.eviware.soapui.impl.wsdl.support.WsdlAttachment;
import com.eviware.soapui.model.iface.Attachment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class MockAttachmentTableModel
extends AbstractTableModel
implements PropertyChangeListener,
AttachmentTableModel {
    private boolean isResponse = false;
    private WsdlMockResponse mockResponse;

    public MockAttachmentTableModel(WsdlMockResponse mockOperation2, boolean isResponse) {
        this.mockResponse = mockOperation2;
        this.isResponse = isResponse;
        this.mockResponse.addPropertyChangeListener(WsdlMockResponse.MOCKRESULT_PROPERTY, this);
        this.mockResponse.addPropertyChangeListener(WsdlMockResponse.ATTACHMENTS_PROPERTY, this);
    }

    public void release() {
        this.mockResponse.removePropertyChangeListener(this);
    }

    public void addFile(File file, boolean cacheInRequest) throws IOException {
        if (this.isResponse) {
            Attachment attachment = this.mockResponse.attachFile(file, cacheInRequest);
            attachment.setContentType(ContentTypeHandler.getContentTypeFromFilename(file.getName()));
            this.fireTableRowsInserted(this.mockResponse.getAttachmentCount(), this.mockResponse.getAttachmentCount());
        }
    }

    public void removeAttachment(int[] rowIndexes) {
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            this.removeAttachment(rowIndexes[i]);
        }
    }

    public void removeAttachment(int rowIndex) {
        if (this.isResponse) {
            this.mockResponse.removeAttachment(this.mockResponse.getAttachmentAt(rowIndex));
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    public int getRowCount() {
        if (this.isResponse) {
            return this.mockResponse.getAttachmentCount();
        }
        try {
            return this.mockResponse.getMockResult().getMockRequest().getRequestAttachments().length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getColumnCount() {
        return this.isResponse ? 6 : 5;
    }

    public Attachment getAttachmentAt(int rowIndex) {
        if (this.isResponse) {
            return this.mockResponse.getAttachmentAt(rowIndex);
        }
        return this.mockResponse.getMockResult().getMockRequest().getRequestAttachments()[rowIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount()) {
            return null;
        }
        Attachment att = null;
        att = this.isResponse ? this.mockResponse.getAttachmentAt(rowIndex) : this.mockResponse.getMockResult().getMockRequest().getRequestAttachments()[rowIndex];
        switch (columnIndex) {
            case 0: {
                return att.getName();
            }
            case 1: {
                return att.getContentType();
            }
            case 2: {
                return att.getSize();
            }
            case 3: {
                return att.getPart();
            }
            case 4: {
                return att.getAttachmentType();
            }
            case 5: {
                return att.getContentID();
            }
        }
        return null;
    }

    public int findColumn(String columnName) {
        if (columnName.equals("Name")) {
            return 0;
        }
        if (columnName.equals("Content type")) {
            return 1;
        }
        if (columnName.equals("Size")) {
            return 2;
        }
        if (columnName.equals("Part")) {
            return 3;
        }
        if (columnName.equals("Type")) {
            return 4;
        }
        return -1;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Content type";
        }
        if (column == 2) {
            return "Size";
        }
        if (column == 3) {
            return "Part";
        }
        if (column == 4) {
            return "Type";
        }
        if (column == 5) {
            return "ContentID";
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isResponse && (columnIndex == 1 || columnIndex == 3 || columnIndex == 5);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isResponse) {
            return;
        }
        WsdlAttachment att = this.mockResponse.getAttachmentAt(rowIndex);
        if (columnIndex == 1) {
            att.setContentType((String)aValue);
        } else if (columnIndex == 3) {
            att.setPart((String)aValue);
        } else if (columnIndex == 5) {
            att.setContentID((String)aValue);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }
}

