/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.config.MockOperationConfig;
import com.eviware.soapui.config.MockServiceConfig;
import com.eviware.soapui.impl.actions.ShowDesktopPanelAction;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.mockservice.AddNewMockOperationAction;
import com.eviware.soapui.impl.wsdl.actions.mockservice.CloneMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.mockservice.RemoveMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.mockservice.RenameMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.support.ModelItemIconAnimator;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunListener;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.support.ScriptingSupport;
import com.eviware.soapui.support.action.ActionSupport;
import groovy.lang.GroovyShell;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlMockService
extends AbstractWsdlModelItem<MockServiceConfig>
implements MockService {
    private static final String REQUIRE_SOAP_VERSION = WsdlMockService.class.getName() + "@require-soap-version";
    private List<WsdlMockOperation> mockOperations = new ArrayList<WsdlMockOperation>();
    private Set<MockRunListener> mockRunListeners = new HashSet<MockRunListener>();
    private Set<MockServiceListener> mockServiceListeners = new HashSet<MockServiceListener>();
    private MockServiceIconAnimator iconAnimator;
    private WsdlMockRunner mockRunner;
    private GroovyShell shell;

    public WsdlMockService(Project project, MockServiceConfig config) {
        super(config, project, "/mockService.gif");
        List testStepConfigs = config.getMockOperationList();
        for (MockOperationConfig tsc : testStepConfigs) {
            WsdlMockOperation testStep = new WsdlMockOperation(this, tsc);
            this.mockOperations.add(testStep);
        }
        if (!config.isSetPort() || config.getPort() < 1) {
            config.setPort(8080);
        }
        if (!config.isSetPath()) {
            config.setPath("/");
        }
        this.addAction(new ShowDesktopPanelAction("Open MockService Editor", "Opens the MockService Editor for this MockService", this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new AddNewMockOperationAction(this));
        this.addAction(new CloneMockServiceAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new RenameMockServiceAction(this));
        this.addAction(new RemoveMockServiceAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/services.html"));
        this.iconAnimator = new MockServiceIconAnimator();
        this.addMockRunListener(this.iconAnimator);
        this.shell = ScriptingSupport.createGroovyShell(null);
    }

    @Override
    public void addMockRunListener(MockRunListener listener) {
        this.mockRunListeners.add(listener);
    }

    @Override
    public String getPath() {
        return ((MockServiceConfig)this.getConfig()).getPath();
    }

    @Override
    public WsdlMockOperation getMockOperationAt(int index) {
        return this.mockOperations.get(index);
    }

    @Override
    public WsdlMockOperation getMockOperationByName(String name) {
        return (WsdlMockOperation)this.getWsdlModelItemByName(this.mockOperations, name);
    }

    @Override
    public int getMockOperationCount() {
        return this.mockOperations.size();
    }

    @Override
    public WsdlProject getProject() {
        return (WsdlProject)this.getParent();
    }

    @Override
    public int getPort() {
        return ((MockServiceConfig)this.getConfig()).getPort();
    }

    @Override
    public void removeMockRunListener(MockRunListener listener) {
        this.mockRunListeners.remove(listener);
    }

    public WsdlMockRunner start(WsdlTestRunContext context) throws Exception {
        String path = this.getPath();
        if (path == null || path.trim().length() == 0 || path.trim().charAt(0) != '/') {
            throw new Exception("Invalid path; must start with '/'");
        }
        this.mockRunner = new WsdlMockRunner(this, context);
        return this.mockRunner;
    }

    public WsdlMockRunner getMockRunner() {
        return this.mockRunner;
    }

    public boolean hasMockOperation(Operation operation) {
        for (int c = 0; c < this.getMockOperationCount(); ++c) {
            WsdlMockOperation mockOperation = this.mockOperations.get(c);
            if (mockOperation.getOperation() != operation) continue;
            return true;
        }
        return false;
    }

    public WsdlMockOperation addNewMockOperation(WsdlOperation operation) {
        if (this.hasMockOperation(operation)) {
            return null;
        }
        MockOperationConfig config = ((MockServiceConfig)this.getConfig()).addNewMockOperation();
        config.setName(operation.getName());
        WsdlMockOperation mockOperation = new WsdlMockOperation(this, config, operation);
        this.mockOperations.add(mockOperation);
        this.fireMockOperationAdded(mockOperation);
        return mockOperation;
    }

    public void setPort(int port) {
        int oldPort = this.getPort();
        if (port != oldPort) {
            ((MockServiceConfig)this.getConfig()).setPort(port);
            this.notifyPropertyChanged(PORT_PROPERTY, oldPort, port);
        }
    }

    @Override
    public void release() {
        super.release();
        for (WsdlMockOperation operation : this.mockOperations) {
            operation.release();
        }
    }

    public void setPath(String path) {
        String oldPath = this.getPath();
        if (!path.equals(oldPath)) {
            ((MockServiceConfig)this.getConfig()).setPath(path);
            this.notifyPropertyChanged(PATH_PROPERTY, oldPath, path);
        }
    }

    public MockRunListener[] getMockRunListeners() {
        return this.mockRunListeners.toArray(new MockRunListener[this.mockRunListeners.size()]);
    }

    public void removeMockOperation(WsdlMockOperation mockOperation) {
        int ix = this.mockOperations.indexOf(mockOperation);
        if (ix == -1) {
            throw new RuntimeException("Unkonws MockOperation specified to removeMockOperation");
        }
        this.mockOperations.remove(ix);
        this.fireMockOperationRemoved(mockOperation);
        mockOperation.release();
        ((MockServiceConfig)this.getConfig()).removeMockOperation(ix);
    }

    @Override
    public void addMockServiceListener(MockServiceListener listener) {
        this.mockServiceListeners.add(listener);
    }

    @Override
    public void removeMockServiceListener(MockServiceListener listener) {
        this.mockServiceListeners.remove(listener);
    }

    protected void fireMockOperationAdded(WsdlMockOperation mockOperation) {
        MockServiceListener[] listeners;
        for (MockServiceListener listener : listeners = this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()])) {
            listener.mockOperationAdded(mockOperation);
        }
    }

    protected void fireMockOperationRemoved(WsdlMockOperation mockOperation) {
        MockServiceListener[] listeners;
        for (MockServiceListener listener : listeners = this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()])) {
            listener.mockOperationRemoved(mockOperation);
        }
    }

    protected void fireMockResponseAdded(WsdlMockResponse mockResponse) {
        MockServiceListener[] listeners;
        for (MockServiceListener listener : listeners = this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()])) {
            listener.mockResponseAdded(mockResponse);
        }
    }

    protected void fireMockResponseRemoved(WsdlMockResponse mockResponse) {
        MockServiceListener[] listeners;
        for (MockServiceListener listener : listeners = this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()])) {
            listener.mockResponseRemoved(mockResponse);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.iconAnimator.getIcon();
    }

    public String getLocalEndpoint() {
        return "http://127.0.0.1:" + this.getPort() + this.getPath();
    }

    public GroovyShell getScriptShell() {
        return this.shell;
    }

    public boolean isRequireSoapVersion() {
        return this.getSettings().getBoolean(REQUIRE_SOAP_VERSION);
    }

    public void setRequireSoapVersion(boolean requireSoapVersion) {
        this.getSettings().setBoolean(REQUIRE_SOAP_VERSION, requireSoapVersion);
    }

    @Override
    public WsdlMockRunner start() throws Exception {
        return this.start(null);
    }

    private class MockServiceIconAnimator
    extends ModelItemIconAnimator
    implements MockRunListener {
        public MockServiceIconAnimator() {
            super(WsdlMockService.this, "/mockService.gif", new String[]{"/mockService_1.gif", "/mockService_2.gif", "/mockService_3.gif", "/mockService_4.gif"});
        }

        public void onMockRequest(MockRunner runner, HttpServletRequest request, HttpServletResponse response) {
        }

        public void onMockResult(MockResult result) {
        }

        public void onMockRunnerStart(MockRunner mockRunner) {
            this.start();
        }

        public void onMockRunnerStop(MockRunner mockRunner) {
            this.stop();
            WsdlMockService.this.mockRunner = null;
        }
    }
}

