/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.WsdlMockResultMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.Response;

public class WsdlMockResult
implements MockResult {
    private WsdlMockResponse mockResponse;
    private String responseContent;
    private long timeTaken;
    private long timestamp;
    private DefaultActionList actions;
    private StringToStringMap responseHeaders = new StringToStringMap();
    private WsdlMockRequest mockRequest;
    private HttpServletResponse response;

    public WsdlMockResult(WsdlMockRequest request, HttpServletResponse response) throws Exception {
        this.response = response;
        this.timestamp = System.currentTimeMillis();
        this.mockRequest = request;
    }

    public WsdlMockRequest getMockRequest() {
        return this.mockRequest;
    }

    public ActionList getActions() {
        if (this.actions == null) {
            this.actions = new DefaultActionList("MockResult");
            this.actions.setDefaultAction(new ShowMessageExchangeAction(new WsdlMockResultMessageExchange(this), "MockResult"));
        }
        return this.actions;
    }

    public WsdlMockResponse getMockResponse() {
        return this.mockResponse;
    }

    public String getResponseContent() {
        return this.responseContent;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public StringToStringMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setMockResponse(WsdlMockResponse mockResponse) {
        this.mockResponse = mockResponse;
    }

    public void setReponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public void finish() {
        HttpFields httpFields = ((Response)this.response).getHttpFields();
        Enumeration e = httpFields.getFieldNames();
        while (e.hasMoreElements()) {
            String nextElement = (String)e.nextElement();
            this.responseHeaders.put(nextElement, httpFields.getStringField(nextElement));
        }
        this.response = null;
    }

    public void addHeader(String name, String value) {
        if (this.response != null) {
            this.response.addHeader(name, value);
        } else {
            this.responseHeaders.put(name, value);
        }
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void setContentType(String string) {
        this.response.setContentType(string);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public void initResponse() {
        this.response.setStatus(200);
    }

    public boolean isDiscarded() {
        return false;
    }
}

