/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.data.actions;

import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogEntry;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;

public class ExportLoadTestLogAction
extends AbstractAction {
    private final LoadTestLog loadTestLog;

    public ExportLoadTestLogAction(LoadTestLog loadTestLog) {
        this.loadTestLog = loadTestLog;
        this.putValue("SmallIcon", UISupport.createImageIcon("/export.gif"));
        this.putValue("ShortDescription", "Export current loadtest log to a file");
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.loadTestLog.getSize() == 0) {
                UISupport.showErrorMessage("No data to export!");
                return;
            }
            File file = UISupport.getFileDialogs().saveAs(this, "Select file for log export");
            if (file == null) {
                return;
            }
            int cnt = this.exportToFile(file);
            UISupport.showInfoMessage("Saved " + cnt + " log entries to file [" + file.getName() + "]");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public int exportToFile(File file) throws IOException {
        PrintWriter writer = new PrintWriter(file);
        this.writeHeader(writer);
        int cnt = this.writeLog(writer);
        writer.flush();
        writer.close();
        return cnt;
    }

    private int writeLog(PrintWriter writer) {
        int c;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (c = 0; c < this.loadTestLog.getSize(); ++c) {
            LoadTestLogEntry logEntry = (LoadTestLogEntry)this.loadTestLog.getElementAt(c);
            writer.write(sdf.format(new Date(logEntry.getTimeStamp())));
            writer.write(44);
            writer.write(logEntry.getType());
            writer.write(44);
            TestStep targetStep = logEntry.getTargetStep();
            if (targetStep != null) {
                writer.write(targetStep.getName());
            }
            writer.write(",\"");
            writer.write(logEntry.getMessage());
            writer.write(34);
            writer.println();
        }
        return c;
    }

    private void writeHeader(PrintWriter writer) {
        writer.println("time,type,step,message");
    }
}

