/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest;

import com.eviware.soapui.config.LoadStrategyConfig;
import com.eviware.soapui.config.LoadTestAssertionConfig;
import com.eviware.soapui.config.LoadTestConfig;
import com.eviware.soapui.config.LoadTestLimitTypesConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.actions.loadtest.CloneLoadTestAction;
import com.eviware.soapui.impl.wsdl.actions.loadtest.RemoveLoadTestAction;
import com.eviware.soapui.impl.wsdl.actions.loadtest.RenameLoadTestAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.loadtest.LoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.LoadTestListener;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestRunner;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.AbstractLoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.assertions.LoadTestAssertionRegistry;
import com.eviware.soapui.impl.wsdl.loadtest.data.LoadTestStatistics;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogErrorEntry;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.BurstLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyRegistry;
import com.eviware.soapui.impl.wsdl.support.Configurable;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.action.ActionSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlLoadTest
extends AbstractWsdlModelItem<LoadTestConfig>
implements LoadTest {
    public static final String THREADCOUNT_PROPERTY = WsdlLoadTest.class.getName() + "@threadcount";
    public static final String STARTDELAY_PROPERTY = WsdlLoadTest.class.getName() + "@startdelay";
    public static final String TESTLIMIT_PROPERTY = WsdlLoadTest.class.getName() + "@testlimit";
    public static final String LIMITTYPE_PROPERRY = WsdlLoadTest.class.getName() + "@limittype";
    public static final String SAMPLEINTERVAL_PROPERRY = WsdlLoadTest.class.getName() + "@sample-interval";
    private static final Logger logger = Logger.getLogger(WsdlLoadTest.class);
    private InternalTestRunListener internalTestRunListener = new InternalTestRunListener();
    private WsdlTestCase testCase;
    private LoadTestStatistics statisticsModel;
    private LoadStrategy loadStrategy = new BurstLoadStrategy();
    private LoadTestLog loadTestLog;
    private LoadStrategyConfigurationChangeListener loadStrategyListener = new LoadStrategyConfigurationChangeListener();
    private List<LoadTestAssertion> assertions = new ArrayList<LoadTestAssertion>();
    private ConfigurationChangePropertyListener configurationChangeListener = new ConfigurationChangePropertyListener();
    private Set<LoadTestListener> listeners = new HashSet<LoadTestListener>();
    private Set<LoadTestRunListener> runListeners = new HashSet<LoadTestRunListener>();
    private WsdlLoadTestRunner runner;

    public WsdlLoadTest(WsdlTestCase testCase, LoadTestConfig config) {
        super(config, testCase, "/loadTest.gif");
        LoadStrategyFactory factory;
        this.testCase = testCase;
        if (((LoadTestConfig)this.getConfig()).getThreadCount() < 1) {
            ((LoadTestConfig)this.getConfig()).setThreadCount(5);
        }
        if (((LoadTestConfig)this.getConfig()).getLimitType() == null) {
            ((LoadTestConfig)this.getConfig()).setLimitType(LoadTestLimitTypesConfig.TIME);
            ((LoadTestConfig)this.getConfig()).setTestLimit(60L);
        }
        this.addAction(new RenameLoadTestAction(this));
        this.addAction(new RemoveLoadTestAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new CloneLoadTestAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/loadtest/index.html"));
        this.addLoadTestRunListener(this.internalTestRunListener);
        LoadStrategyConfig ls = ((LoadTestConfig)this.getConfig()).getLoadStrategy();
        if (ls == null) {
            ls = ((LoadTestConfig)this.getConfig()).addNewLoadStrategy();
            ls.setType("Simple");
        }
        if ((factory = LoadStrategyRegistry.getInstance().getFactory(ls.getType())) == null) {
            ls.setType("Simple");
            factory = LoadStrategyRegistry.getInstance().getFactory(ls.getType());
        }
        this.loadStrategy = factory.build(ls.getConfig());
        this.loadStrategy.addConfigurationChangeListener(this.loadStrategyListener);
        this.addLoadTestRunListener(this.loadStrategy);
        this.statisticsModel = new LoadTestStatistics(this);
        if (((LoadTestConfig)this.getConfig()).xgetSampleInterval() == null) {
            this.setSampleInterval(250);
        }
        this.statisticsModel.setUpdateFrequency(this.getSampleInterval());
        List assertionList = ((LoadTestConfig)this.getConfig()).getAssertionList();
        for (LoadTestAssertionConfig assertionConfig : assertionList) {
            AbstractLoadTestAssertion assertion = LoadTestAssertionRegistry.buildAssertion(assertionConfig, this);
            if (assertion != null) {
                this.assertions.add(assertion);
                assertion.addPropertyChangeListener(LoadTestAssertion.CONFIGURATION_PROPERTY, this.configurationChangeListener);
                continue;
            }
            logger.warn((Object)("Failed to build LoadTestAssertion from getConfig() [" + assertionConfig + "]"));
        }
        if (((LoadTestConfig)this.getConfig()).xgetResetStatisticsOnThreadCountChange() == null) {
            ((LoadTestConfig)this.getConfig()).setResetStatisticsOnThreadCountChange(true);
        }
        if (((LoadTestConfig)this.getConfig()).xgetCalculateTPSOnTimePassed() == null) {
            ((LoadTestConfig)this.getConfig()).setCalculateTPSOnTimePassed(false);
        }
        this.loadTestLog = new LoadTestLog(this);
    }

    public LoadTestStatistics getStatisticsModel() {
        return this.statisticsModel;
    }

    public long getThreadCount() {
        return ((LoadTestConfig)this.getConfig()).getThreadCount();
    }

    public void setThreadCount(long threadCount) {
        if (threadCount < 1L || threadCount == this.getThreadCount()) {
            return;
        }
        long oldCount = this.getThreadCount();
        ((LoadTestConfig)this.getConfig()).setThreadCount((int)threadCount);
        this.notifyPropertyChanged(THREADCOUNT_PROPERTY, oldCount, threadCount);
    }

    public boolean getResetStatisticsOnThreadCountChange() {
        return ((LoadTestConfig)this.getConfig()).getResetStatisticsOnThreadCountChange();
    }

    public void setResetStatisticsOnThreadCountChange(boolean value) {
        ((LoadTestConfig)this.getConfig()).setResetStatisticsOnThreadCountChange(value);
    }

    public boolean getCalculateTPSOnTimePassed() {
        return ((LoadTestConfig)this.getConfig()).getCalculateTPSOnTimePassed();
    }

    public void setCalculateTPSOnTimePassed(boolean value) {
        ((LoadTestConfig)this.getConfig()).setCalculateTPSOnTimePassed(value);
    }

    public int getStartDelay() {
        return ((LoadTestConfig)this.getConfig()).getStartDelay();
    }

    public void setStartDelay(int startDelay) {
        if (startDelay < 0) {
            return;
        }
        int oldDelay = this.getStartDelay();
        ((LoadTestConfig)this.getConfig()).setStartDelay(startDelay);
        this.notifyPropertyChanged(STARTDELAY_PROPERTY, oldDelay, startDelay);
    }

    public long getTestLimit() {
        return ((LoadTestConfig)this.getConfig()).getTestLimit();
    }

    public void setTestLimit(long testLimit) {
        if (testLimit < 0L) {
            return;
        }
        long oldLimit = this.getTestLimit();
        ((LoadTestConfig)this.getConfig()).setTestLimit(testLimit);
        this.notifyPropertyChanged(TESTLIMIT_PROPERTY, oldLimit, testLimit);
    }

    public long getSampleInterval() {
        return ((LoadTestConfig)this.getConfig()).getSampleInterval();
    }

    public void setSampleInterval(int sampleInterval) {
        if (sampleInterval < 0) {
            return;
        }
        long oldInterval = this.getSampleInterval();
        ((LoadTestConfig)this.getConfig()).setSampleInterval(sampleInterval);
        this.statisticsModel.setUpdateFrequency(sampleInterval);
        this.notifyPropertyChanged(TESTLIMIT_PROPERTY, oldInterval, (Object)sampleInterval);
    }

    public LoadTestLimitTypesConfig.Enum getLimitType() {
        return ((LoadTestConfig)this.getConfig()).getLimitType();
    }

    public void setLimitType(LoadTestLimitTypesConfig.Enum limitType) {
        if (limitType == null) {
            return;
        }
        LoadTestLimitTypesConfig.Enum oldType = this.getLimitType();
        ((LoadTestConfig)this.getConfig()).setLimitType(limitType);
        this.notifyPropertyChanged(LIMITTYPE_PROPERRY, oldType, limitType);
    }

    @Override
    public WsdlTestCase getTestCase() {
        return this.testCase;
    }

    @Override
    public synchronized LoadTestRunner run() {
        if (this.runner != null && this.runner.getStatus() == LoadTestRunner.Status.RUNNING) {
            return null;
        }
        this.runner = new WsdlLoadTestRunner(this);
        this.runner.start();
        return this.runner;
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public void setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy.removeConfigurationChangeListener(this.loadStrategyListener);
        this.removeLoadTestRunListener(this.loadStrategy);
        this.loadStrategy = loadStrategy;
        this.loadStrategy.addConfigurationChangeListener(this.loadStrategyListener);
        this.addLoadTestRunListener(this.loadStrategy);
        ((LoadTestConfig)this.getConfig()).getLoadStrategy().setType(loadStrategy.getType());
        ((LoadTestConfig)this.getConfig()).getLoadStrategy().setConfig(loadStrategy.getConfig());
    }

    public LoadTestAssertion addAssertion(String type, String targetStep, boolean showConfig) {
        LoadTestAssertion assertion = LoadTestAssertionRegistry.createAssertion(type, this);
        assertion.setTargetStep(targetStep);
        if (assertion instanceof Configurable && showConfig && !((Configurable)((Object)assertion)).configure()) {
            return null;
        }
        this.assertions.add(assertion);
        ((LoadTestConfig)this.getConfig()).addNewAssertion().set(assertion.getConfiguration());
        assertion.addPropertyChangeListener(LoadTestAssertion.CONFIGURATION_PROPERTY, this.configurationChangeListener);
        this.fireAssertionAdded(assertion);
        return assertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssertion(LoadTestAssertion assertion) {
        int ix = this.assertions.indexOf(assertion);
        if (ix >= 0) {
            try {
                this.assertions.remove(ix);
                this.fireAssertionRemoved(assertion);
            }
            finally {
                assertion.removePropertyChangeListener(this.configurationChangeListener);
                assertion.release();
                ((LoadTestConfig)this.getConfig()).removeAssertion(ix);
            }
        }
    }

    private void fireAssertionRemoved(LoadTestAssertion assertion) {
        if (!this.listeners.isEmpty()) {
            LoadTestListener[] l;
            for (LoadTestListener listener : l = this.listeners.toArray(new LoadTestListener[this.listeners.size()])) {
                listener.assertionRemoved(assertion);
            }
        }
    }

    private void fireAssertionAdded(LoadTestAssertion assertion) {
        if (!this.listeners.isEmpty()) {
            LoadTestListener[] l;
            for (LoadTestListener listener : l = this.listeners.toArray(new LoadTestListener[this.listeners.size()])) {
                listener.assertionAdded(assertion);
            }
        }
    }

    public int getAssertionCount() {
        return this.assertions.size();
    }

    public LoadTestAssertion getAssertionAt(int index) {
        return this.assertions.get(index);
    }

    public LoadTestLog getLoadTestLog() {
        return this.loadTestLog;
    }

    public List<LoadTestAssertion> getAssertionList() {
        return this.assertions;
    }

    public void addLoadTestListener(LoadTestListener listener) {
        this.listeners.add(listener);
    }

    public void removeLoadTestListener(LoadTestListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addLoadTestRunListener(LoadTestRunListener listener) {
        this.runListeners.add(listener);
    }

    @Override
    public void removeLoadTestRunListener(LoadTestRunListener listener) {
        this.runListeners.remove(listener);
    }

    public LoadTestRunListener[] getLoadTestRunListeners() {
        return this.runListeners.toArray(new LoadTestRunListener[this.runListeners.size()]);
    }

    @Override
    public void release() {
        super.release();
        this.statisticsModel.release();
        this.loadTestLog.release();
        for (LoadTestAssertion assertion : this.assertions) {
            assertion.release();
        }
    }

    public boolean isRunning() {
        return this.runner != null && this.runner.getStatus() == LoadTestRunner.Status.RUNNING;
    }

    public WsdlLoadTestRunner getRunner() {
        return this.runner;
    }

    private class ConfigurationChangePropertyListener
    implements PropertyChangeListener {
        private ConfigurationChangePropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int ix = WsdlLoadTest.this.assertions.indexOf(evt.getSource());
            if (ix >= 0) {
                ((LoadTestConfig)WsdlLoadTest.this.getConfig()).getAssertionArray(ix).set(((LoadTestAssertion)WsdlLoadTest.this.assertions.get(ix)).getConfiguration());
            }
        }
    }

    private class LoadStrategyConfigurationChangeListener
    implements PropertyChangeListener {
        private LoadStrategyConfigurationChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ((LoadTestConfig)WsdlLoadTest.this.getConfig()).getLoadStrategy().setConfig(WsdlLoadTest.this.loadStrategy.getConfig());
        }
    }

    private class InternalTestRunListener
    extends LoadTestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        public void afterTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext) {
            if (!WsdlLoadTest.this.assertions.isEmpty()) {
                for (LoadTestAssertion assertion : WsdlLoadTest.this.assertions) {
                    String error = assertion.assertResults(loadTestRunner, context, testRunner, runContext);
                    if (error == null) continue;
                    WsdlLoadTest.this.loadTestLog.addEntry(new LoadTestLogErrorEntry(assertion.getName(), error, assertion.getIcon()));
                    WsdlLoadTest.this.statisticsModel.addError(-1);
                }
            }
        }

        public void afterTestStep(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext, TestStepResult result) {
            if (!WsdlLoadTest.this.assertions.isEmpty()) {
                boolean added = false;
                for (LoadTestAssertion assertion : WsdlLoadTest.this.assertions) {
                    String error = assertion.assertResult(loadTestRunner, context, result, testRunner, runContext);
                    if (error == null) continue;
                    int indexOfTestStep = testRunner.getTestCase().getIndexOfTestStep(result.getTestStep());
                    WsdlLoadTest.this.loadTestLog.addEntry(new LoadTestLogErrorEntry(assertion.getName(), error, result, assertion.getIcon()));
                    WsdlLoadTest.this.statisticsModel.addError(indexOfTestStep);
                    added = true;
                }
                if (!added) {
                    result.discard();
                }
            } else {
                result.discard();
            }
        }
    }
}

