/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class AddNewMockServiceAction
extends AbstractAction {
    private final WsdlProject project;

    public AddNewMockServiceAction(WsdlProject project) {
        super("New MockService");
        this.project = project;
        this.putValue("ShortDescription", "Creates a new MockService in this project");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu O"));
    }

    public void actionPerformed(ActionEvent e) {
        this.createMockService();
    }

    public WsdlMockService createMockService() {
        String name = UISupport.prompt("Specify name of MockService", "New MockService", "MockService " + (this.project.getMockServiceCount() + 1));
        if (name == null) {
            return null;
        }
        WsdlMockService mockService = this.project.addNewMockService(name);
        SoapUI.selectModelItem(mockService);
        return mockService;
    }
}

