/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class AddInterfaceActionFromURL
extends AbstractAction {
    private final WsdlProject project;

    public AddInterfaceActionFromURL(WsdlProject project) {
        super("Add WSDL from URL");
        this.project = project;
        this.putValue("ShortDescription", "Adds all interfaces in a specified WSDL URL to the current project");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu U"));
    }

    public void actionPerformed(ActionEvent e) {
        String url = UISupport.prompt("Enter WSDL URL", "Add WSDL from URL", "");
        if (url == null) {
            return;
        }
        try {
            Boolean createRequests = UISupport.confirmOrCancel("Create default requests for all operations", "Import WSDL");
            if (createRequests == null) {
                return;
            }
            WsdlInterface[] ifaces = this.project.importWsdl(url, createRequests);
            if (ifaces.length > 0) {
                SoapUI.selectModelItem(ifaces[0]);
            }
        }
        catch (Exception ex) {
            UISupport.showErrorMessage(ex.getMessage() + ":" + ex.getCause());
        }
    }
}

