/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.loadtest;

import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RemoveLoadTestAction
extends AbstractAction {
    private final WsdlLoadTest loadTest;
    private final InternalLoadTestRunListener internalLoadTestRunListener = new InternalLoadTestRunListener();

    public RemoveLoadTestAction(WsdlLoadTest loadTest) {
        super("Remove");
        this.loadTest = loadTest;
        this.putValue("ShortDescription", "Removes this Test Schedule from the test-case");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("DELETE"));
        loadTest.addLoadTestRunListener(this.internalLoadTestRunListener);
    }

    public void actionPerformed(ActionEvent e) {
        if (UISupport.confirm("Remove LoadTest [" + this.loadTest.getName() + "] from test-casee", "Remove LoadTest")) {
            this.loadTest.getTestCase().removeLoadTest(this.loadTest);
        }
    }

    private final class InternalLoadTestRunListener
    extends LoadTestRunListenerAdapter {
        private InternalLoadTestRunListener() {
        }

        public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
            RemoveLoadTestAction.this.setEnabled(false);
        }

        public void afterLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
            RemoveLoadTestAction.this.setEnabled(true);
        }
    }
}

