/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.xmlbeans;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.settings.ToolsSupport;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeans2Action
extends AbstractToolsAction<Interface> {
    private static final String XSBTARGET = "class/xsb target";
    private static final String SRCTARGET = "src target";
    private static final String SRCONLY = "src only";
    private static final String JARFILE = "out jar";
    private static final String DOWNLOADS = "downloads";
    private static final String NOUPA = "noupa";
    private static final String NOPVR = "nopvr";
    private static final String NOANN = "noann";
    private static final String NOVDOC = "novdoc";
    private static final String VERBOSE = "verbose";
    private static final String JAVASOURCE = "javasource";
    private static final String DEBUG = "debug";
    private static final String ALLOWMDEF = "allowmdef";
    private static final String CATALOG = "catalog file";
    private static final String XSDCONFIG = "xsdconfig";
    private String output;

    public XmlBeans2Action(Interface iface) {
        super(iface, "XmlBeans Classes", "Generates XmlBeans classes");
    }

    @Override
    protected StringToStringMap initValues() {
        StringToStringMap values = super.initValues();
        if (this.output != null) {
            values.put(SRCTARGET, this.output);
        }
        return values;
    }

    @Override
    protected XFormDialog buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("XmlBeans Classes");
        XForm mainForm = builder.createForm("Basic");
        this.addWSDLFields(mainForm);
        mainForm.addTextField(XSBTARGET, "Target directory for CLASS and XSB files", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(SRCTARGET, "Target directory for generated JAVA files", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(JARFILE, "The name of the output JAR that will contain the result of compilation", XForm.FieldType.PROJECT_FILE);
        mainForm.addCheckBox(SRCONLY, "(Do not compile JAVA files or jar the output)");
        mainForm.addCheckBox(DOWNLOADS, "(Permit network downloads for imports and includes)");
        mainForm.addCheckBox(NOUPA, "(Do not enforce the unique particle attribution rule)");
        mainForm.addCheckBox(NOPVR, "(Do not enforce the particle valid (restriction) rule)");
        mainForm.addCheckBox(NOANN, "(Ignore annotations)");
        mainForm.addCheckBox(NOVDOC, "(Do not validate contents of <documentation> elements)");
        mainForm.addCheckBox(DEBUG, "(Compile with debug symbols)");
        mainForm.addComboBox(JAVASOURCE, new String[]{"1.5", "1.4"}, "Generate Java source compatible for the specified Java version");
        mainForm.addTextField(ALLOWMDEF, "Ignore multiple defs in given namespaces. Use  ##local  to specify the no-namespace in that list", XForm.FieldType.TEXT);
        mainForm.addTextField(CATALOG, "Catalog file to use for resolving external entities", XForm.FieldType.PROJECT_FILE);
        mainForm.addTextField(XSDCONFIG, "Path to .xsdconfig file containing type-mapping information", XForm.FieldType.PROJECT_FILE);
        mainForm.addCheckBox(VERBOSE, "(Print more informational messages)");
        this.buildArgsForm(builder, false, "scomp");
        return builder.buildDialog(this.buildDefaultActions("http://xmlbeans.apache.org/docs/2.0.0/guide/tools.html#scomp"), "Specify arguments for XmlBeans 2.X scomp", UISupport.TOOL_ICON);
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost) throws Exception {
        String xbDir = SoapUI.getSettings().getString(ToolsSettings.XMLBEANS_LOCATION, null);
        if (Tools.isEmpty(xbDir)) {
            UISupport.showErrorMessage("XmlBeans location must be set in global preferences");
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(this.buildArgs().getArgs());
        builder.directory(new File(xbDir + File.separatorChar + "bin"));
        toolHost.run(new ProcessToolRunner(builder, "XmlBeans", this.modelItem));
    }

    private ArgumentBuilder buildArgs() {
        StringToStringMap values = this.dialog.getValues();
        ArgumentBuilder builder = new ArgumentBuilder(values);
        values.put(XSBTARGET, Tools.ensureDir((String)values.get(XSBTARGET), ""));
        values.put(SRCTARGET, Tools.ensureDir((String)values.get(SRCTARGET), ""));
        builder.startScript("scomp", ".cmd", "");
        builder.addString(XSBTARGET, "-d");
        builder.addString(SRCTARGET, "-src");
        builder.addString(JARFILE, "-out");
        builder.addBoolean(SRCONLY, "-srconly");
        builder.addBoolean(DOWNLOADS, "-dl");
        builder.addBoolean(NOUPA, "-noupa");
        builder.addBoolean(NOPVR, "-nopvr");
        builder.addBoolean(NOANN, "-noann");
        builder.addBoolean(NOVDOC, "-novdoc");
        builder.addBoolean(DEBUG, "-debug");
        builder.addString(JAVASOURCE, "-javasource");
        builder.addString(ALLOWMDEF, "-allowmdef");
        builder.addString(CATALOG, "-catalog");
        builder.addBoolean(VERBOSE, "-verbose");
        String javac = ToolsSupport.getToolLocator().getJavacLocation(false);
        if (javac != null) {
            builder.addArgs("-compiler", javac + File.separatorChar + "javac");
        }
        this.addToolArgs(values, builder);
        builder.addString(XSDCONFIG, null);
        builder.addArgs(this.getWsdlUrl(values));
        return builder;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

