/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.support;

import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.RunnerContext;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolRunner;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import java.io.InputStream;
import java.util.List;

public class ProcessToolRunner
implements ToolRunner {
    private final ProcessBuilder[] builders;
    private boolean running;
    private Process process;
    private RunnerContext context;
    private final String name;
    private final ModelItem modelItem;
    private boolean canCancel = true;
    private boolean showLog = true;

    public ProcessToolRunner(ProcessBuilder builder, String name, ModelItem modelItem) {
        this(new ProcessBuilder[]{builder}, name, modelItem);
    }

    public ProcessToolRunner(ProcessBuilder[] builders, String name, ModelItem modelItem) {
        this.builders = builders;
        this.name = name;
        this.modelItem = modelItem;
    }

    public ProcessBuilder[] getBuilders() {
        return this.builders;
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void cancel() {
        this.getProcess().destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int exitCode = -1;
            this.beforeRun(this.context);
            for (int c = 0; c < this.builders.length; ++c) {
                this.beforeProcess(this.process, this.context);
                this.logRunInfo(this.builders[c]);
                this.process = this.builders[c].start();
                if (c == 0) {
                    this.context.setStatus(RunnerContext.RunnerStatus.RUNNING);
                }
                this.running = true;
                InputStream in = this.process.getInputStream();
                InputStream err = this.process.getErrorStream();
                exitCode = -1;
                while (exitCode == -1 && this.running) {
                    byte[] data;
                    try {
                        exitCode = this.process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException e) {
                        while (in.available() > 0) {
                            data = new byte[in.available()];
                            in.read(data);
                            this.context.log(new String(data));
                        }
                        while (err.available() > 0) {
                            data = new byte[err.available()];
                            err.read(data);
                            this.context.logError(new String(data));
                        }
                    }
                    finally {
                        while (in.available() > 0) {
                            data = new byte[in.available()];
                            in.read(data);
                            this.context.log(new String(data));
                        }
                        while (err.available() > 0) {
                            data = new byte[err.available()];
                            err.read(data);
                            this.context.logError(new String(data));
                        }
                    }
                    Thread.sleep(25L);
                }
                this.afterProcess(this.process, this.context);
            }
            this.context.setStatus(RunnerContext.RunnerStatus.FINISHED);
            if (this.running) {
                this.running = false;
                this.afterRun(exitCode, this.context);
            }
        }
        catch (Exception ex) {
            this.context.setStatus(RunnerContext.RunnerStatus.ERROR);
            UISupport.showErrorMessage(ex);
            this.running = false;
            this.afterRun(-1, this.context);
        }
        finally {
            this.context.disposeContext();
        }
    }

    protected void beforeRun(RunnerContext context) {
    }

    protected void beforeProcess(Process process2, RunnerContext context) {
    }

    protected void afterProcess(Process process2, RunnerContext context) {
    }

    protected void afterRun(int exitCode, RunnerContext context) {
        if (exitCode == 0) {
            UISupport.showInfoMessage("Execution finished successfully", context.getTitle());
        } else {
            UISupport.showInfoMessage("Execution finished with errorCode " + exitCode + ",\r\nplease check log for error messages", context.getTitle());
        }
    }

    private void logRunInfo(ProcessBuilder builder) {
        List<String> args = builder.command();
        StringBuffer buf = new StringBuffer();
        for (int c = 0; c < args.size(); ++c) {
            if (c > 0) {
                buf.append(' ');
            }
            buf.append(args.get(c));
        }
        this.context.log("directory: " + builder.directory().getAbsolutePath() + "\r\n");
        this.context.log("command: " + buf.toString() + "\r\n");
    }

    public void setContext(RunnerContext context) {
        this.context = context;
    }

    public ModelItem getModelItem() {
        return this.modelItem;
    }

    public String getName() {
        return this.name;
    }

    public boolean canCancel() {
        return this.canCancel;
    }

    public boolean showLog() {
        return this.showLog;
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    public String getDescription() {
        return null;
    }
}

