/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.actions.iface.RemoveInterfaceAction;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class UpdateInterfaceAction
extends AbstractAction {
    private final WsdlInterface iface;

    public UpdateInterfaceAction(WsdlInterface iface) {
        super("Update Definition");
        this.iface = iface;
        this.putValue("ShortDescription", "Reloads the definition for this interface and its operations");
        this.putValue("SmallIcon", UISupport.createImageIcon("/updateDefinition.gif"));
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("F5"));
    }

    public void actionPerformed(ActionEvent e) {
        if (RemoveInterfaceAction.hasDependingTests(this.iface)) {
            UISupport.showErrorMessage("Cannot update Interface due to running depending tests");
            return;
        }
        String url = UISupport.prompt("Refresh from specified url:", "Update Definition", this.iface.getDefinition());
        if (url == null) {
            return;
        }
        boolean createRequests = UISupport.confirm("Create default requests for new methods?", "Update Definition");
        try {
            if (this.iface.updateDefinition(url, createRequests)) {
                UISupport.showInfoMessage("Update of interface successfull!", "Update Definition");
            } else {
                UISupport.showInfoMessage("Update of interface failed", "Update Definition");
            }
        }
        catch (Exception e1) {
            UISupport.showInfoMessage("Failed to update interface: [" + e1 + "]", "Update Definition");
            e1.printStackTrace();
        }
    }
}

