/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RemoveInterfaceAction
extends AbstractAction {
    private final WsdlInterface iface;

    public RemoveInterfaceAction(WsdlInterface iface) {
        super("Remove");
        this.iface = iface;
        this.putValue("ShortDescription", "Removes this interface from the project");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("DELETE"));
    }

    public void actionPerformed(ActionEvent e) {
        if (RemoveInterfaceAction.hasDependingTests(this.iface)) {
            UISupport.showErrorMessage("Cannot remove Interface due to running depending tests");
            return;
        }
        if (UISupport.confirm("Remove interface [" + this.iface.getName() + "] from project [" + this.iface.getProject().getName() + "]?", "Remove Interface")) {
            WsdlProject project = this.iface.getProject();
            project.removeInterface(this.iface);
        }
    }

    static boolean hasDependingTests(WsdlInterface iface) {
        if (SoapUI.getTestMonitor() == null) {
            return false;
        }
        for (int c = 0; c < iface.getProject().getTestSuiteCount(); ++c) {
            WsdlTestSuite testSuite = iface.getProject().getTestSuiteAt(c);
            for (int i = 0; i < testSuite.getTestCaseCount(); ++i) {
                TestCase testCase = testSuite.getTestCaseAt(i);
                if (!SoapUI.getTestMonitor().hasRunningTest(testCase)) continue;
                for (int j = 0; j < testCase.getTestStepCount(); ++j) {
                    WsdlTestStep testStep = (WsdlTestStep)testCase.getTestStepAt(j);
                    if (!testStep.dependsOn(iface)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

