/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestRequestStepFactory;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class GenerateTestSuiteAction
extends AbstractAction {
    private final WsdlInterface iface;

    public GenerateTestSuiteAction(WsdlInterface iface) {
        super("Generate TestSuite");
        this.putValue("ShortDescription", "Generates TestSuite with TestCase(s) for all Operations in this Interface");
        this.iface = iface;
    }

    public void actionPerformed(ActionEvent e) {
        this.generateTestSuite(this.iface);
    }

    public WsdlTestSuite generateTestSuite(WsdlInterface iface) {
        XFormDialog dialog = ADialogBuilder.buildDialog(GenerateForm.class);
        WsdlProject project = iface.getProject();
        Object[] testSuites = ModelSupport.getNames(new String[]{"<create>"}, project.getTestSuites());
        dialog.setOptions("TestSuite", testSuites);
        if (dialog.show()) {
            String testSuiteName = dialog.getValue("TestSuite");
            if (testSuiteName.equals("<create>")) {
                testSuiteName = UISupport.prompt("Enter name of TestSuite to create", "Generate TestSuite", iface.getName() + " TestSuite");
            }
            if (testSuiteName != null && testSuiteName.trim().length() > 0) {
                int style;
                WsdlTestSuite testSuite = project.getTestSuiteByName(testSuiteName);
                if (testSuite == null) {
                    testSuite = project.addNewTestSuite(testSuiteName);
                }
                if ((style = dialog.getValueIndex("Style")) == 0) {
                    this.generateMulipleTestCases(testSuite, iface);
                } else if (style == 1) {
                    this.generateSingleTestCase(testSuite, iface);
                }
                return testSuite;
            }
        }
        return null;
    }

    private void generateSingleTestCase(WsdlTestSuite testSuite, WsdlInterface iface) {
        WsdlTestCase testCase = testSuite.addNewTestCase(iface.getName() + " TestSuite");
        for (int i = 0; i < iface.getOperationCount(); ++i) {
            WsdlOperation operation = iface.getOperationAt(i);
            testCase.addTestStep(WsdlTestRequestStepFactory.createConfig(operation, operation.getName()));
        }
        UISupport.showDesktopPanel(testCase);
    }

    private void generateMulipleTestCases(WsdlTestSuite testSuite, WsdlInterface iface) {
        for (int i = 0; i < iface.getOperationCount(); ++i) {
            WsdlOperation operation = iface.getOperationAt(i);
            WsdlTestCase testCase = testSuite.addNewTestCase(operation.getName() + " TestCase");
            testCase.addTestStep(WsdlTestRequestStepFactory.createConfig(operation, operation.getName()));
        }
        UISupport.showDesktopPanel(testSuite);
    }

    @AForm(name="Generate TestSuite", description="Generates TestSuite with TestCase(s) for all Operations in this Interface")
    private class GenerateForm {
        @AField(name="TestSuite", description="The TestSuite to create or use", type=AField.AFieldType.ENUMERATION)
        public static final String TESTSUITE = "TestSuite";
        @AField(name="Style", description="Select the style of TestCases to create", type=AField.AFieldType.ENUMERATION, values={"One TestCase for each Operation", "Single TestCase with one Request for each Operation"})
        public static final String STYLE = "Style";

        private GenerateForm() {
        }
    }
}

