/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.config.CallConfig;
import com.eviware.soapui.config.OperationConfig;
import com.eviware.soapui.config.PartsConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.operation.AddToMockServiceAction;
import com.eviware.soapui.impl.wsdl.actions.operation.NewRequestAction;
import com.eviware.soapui.impl.wsdl.actions.operation.RelabelOperationAction;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.support.soap.SoapMessageBuilder;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.iface.MessagePart;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlOperation
extends AbstractWsdlModelItem<OperationConfig>
implements Operation {
    public static final String STYLE_DOCUMENT = "Document";
    public static final String STYLE_RPC = "RPC";
    private List<WsdlRequest> requests = new ArrayList<WsdlRequest>();
    private WsdlInterface iface;
    private ImageIcon oneWayIcon;

    public WsdlOperation(WsdlInterface iface, OperationConfig operationConfig) {
        super(operationConfig, iface, "/operation.gif");
        this.iface = iface;
        if (operationConfig.isSetIsOneWay()) {
            operationConfig.setIsOneWay(false);
        }
        List requestConfigs = ((OperationConfig)this.getConfig()).getCallList();
        for (CallConfig config : requestConfigs) {
            this.requests.add(new WsdlRequest(this, config));
        }
        this.addAction(new AddToMockServiceAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new NewRequestAction(this));
        this.addAction(new RelabelOperationAction(this));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/interfaces.html#Operations"));
        this.oneWayIcon = UISupport.createImageIcon("/onewayoperation.gif");
    }

    @Override
    public String getAction() {
        return ((OperationConfig)this.getConfig()).getAction();
    }

    @Override
    public WsdlRequest getRequestAt(int index) {
        return this.requests.get(index);
    }

    @Override
    public WsdlRequest getRequestByName(String requestName) {
        return (WsdlRequest)this.getWsdlModelItemByName(this.requests, requestName);
    }

    @Override
    public int getRequestCount() {
        return this.requests.size();
    }

    @Override
    public ImageIcon getIcon() {
        if (this.isOneWay()) {
            return this.oneWayIcon;
        }
        return super.getIcon();
    }

    public WsdlRequest addNewRequest(String name) {
        WsdlRequest requestImpl = new WsdlRequest(this, ((OperationConfig)this.getConfig()).addNewCall());
        requestImpl.setName(name);
        this.requests.add(requestImpl);
        this.getInterface().fireRequestAdded(requestImpl);
        return requestImpl;
    }

    @Override
    public WsdlInterface getInterface() {
        return this.iface;
    }

    public void setAction(String soapAction) {
        String old = this.getAction();
        ((OperationConfig)this.getConfig()).setAction(soapAction);
        this.notifyPropertyChanged(ACTION_PROPERTY, old, soapAction);
    }

    public String createRequest(boolean buildOptional) {
        if (this.iface.getBindingName() == null) {
            UISupport.showErrorMessage("Missing binding name, please try to refresh Interface\nfor request generation to work correctly");
            return null;
        }
        if (this.getBindingOperationName() == null) {
            UISupport.showErrorMessage("Missing bindingOperation name, please try to refresh Interface\nfor request generation to work correctly");
            return null;
        }
        try {
            SoapMessageBuilder builder = this.iface.getMessageBuilder();
            BindingOperation bindingOperation = this.findBindingOperation(this.iface.getWsdlContext().getDefinition());
            if (bindingOperation == null) {
                UISupport.showErrorMessage("Failed to find bindingOperation, please try to refresh Interface\nfor request generation to work correctly");
                return null;
            }
            return builder.buildSoapRequest(bindingOperation, buildOptional);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createResponse(boolean buildOptional) {
        if (this.iface.getBindingName() == null) {
            UISupport.showErrorMessage("Missing binding name, please try to refresh Interface\nfor request generation to work correctly");
            return null;
        }
        if (this.getBindingOperationName() == null) {
            UISupport.showErrorMessage("Missing bindingOperation name, please try to refresh Interface\nfor request generation to work correctly");
            return null;
        }
        try {
            SoapMessageBuilder builder = this.iface.getMessageBuilder();
            BindingOperation bindingOperation = this.findBindingOperation(this.iface.getWsdlContext().getDefinition());
            if (bindingOperation == null) {
                UISupport.showErrorMessage("Failed to find bindingOperation, please try to refresh Interface\nfor request generation to work correctly");
                return null;
            }
            return builder.buildSoapResponse(bindingOperation, buildOptional);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BindingOperation findBindingOperation(Definition definition) {
        BindingOperation result;
        Binding binding = definition.getBinding(this.iface.getBindingName());
        if (binding == null) {
            return null;
        }
        String inputName = this.getInputName();
        String outputName = this.getOutputName();
        if (inputName == null) {
            inputName = ":none";
        }
        if (outputName == null) {
            outputName = ":none";
        }
        if ((result = binding.getBindingOperation(((OperationConfig)this.getConfig()).getBindingOperationName(), inputName, outputName)) == null && (inputName.equals(":none") || outputName.equals(":none"))) {
            result = binding.getBindingOperation(((OperationConfig)this.getConfig()).getBindingOperationName(), inputName.equals(":none") ? null : inputName, outputName.equals(":none") ? null : outputName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(WsdlRequest request) {
        int ix = this.requests.indexOf(request);
        this.requests.remove(ix);
        try {
            this.getInterface().fireRequestRemoved(request);
        }
        finally {
            request.release();
            ((OperationConfig)this.getConfig()).removeCall(ix);
        }
    }

    public String getBindingOperationName() {
        return ((OperationConfig)this.getConfig()).getBindingOperationName();
    }

    public void setBindingOperationName(String name) {
        ((OperationConfig)this.getConfig()).setBindingOperationName(name);
    }

    public void setInputName(String name) {
        ((OperationConfig)this.getConfig()).setInputName(name);
    }

    public String getInputName() {
        String inputName = ((OperationConfig)this.getConfig()).getInputName();
        return inputName == null || inputName.trim().length() == 0 ? null : inputName;
    }

    public void setOutputName(String name) {
        if (name == null) {
            if (((OperationConfig)this.getConfig()).isSetOutputName()) {
                ((OperationConfig)this.getConfig()).unsetOutputName();
            }
        } else {
            ((OperationConfig)this.getConfig()).setOutputName(name);
        }
    }

    public String getOutputName() {
        String outputName = ((OperationConfig)this.getConfig()).getOutputName();
        return outputName == null || outputName.trim().length() == 0 ? null : outputName;
    }

    public void setOneWay(boolean isOneWay) {
        ((OperationConfig)this.getConfig()).setIsOneWay(isOneWay);
    }

    public boolean isOneWay() {
        return ((OperationConfig)this.getConfig()).getIsOneWay();
    }

    public void initFromBindingOperation(BindingOperation operation, boolean notifyUpdate) {
        this.setAction(WsdlUtils.getSoapAction(operation));
        this.setName(operation.getOperation().getName());
        this.setBindingOperationName(operation.getName());
        this.setInputName(operation.getBindingInput().getName());
        BindingOutput bindingOutput = operation.getBindingOutput();
        if (bindingOutput != null) {
            this.setOutputName(bindingOutput.getName());
        } else {
            this.setOutputName(null);
        }
        this.setOneWay(bindingOutput == null);
        this.initAttachments(operation);
        if (notifyUpdate) {
            this.iface.fireOperationUpdated(this);
        }
    }

    private void initAttachments(BindingOperation operation) {
        BindingOutput bindingOutput;
        if (((OperationConfig)this.getConfig()).isSetRequestParts()) {
            ((OperationConfig)this.getConfig()).unsetRequestParts();
        }
        if (((OperationConfig)this.getConfig()).isSetResponseParts()) {
            ((OperationConfig)this.getConfig()).unsetResponseParts();
        }
        if ((bindingOutput = operation.getBindingOutput()) != null) {
            MIMEMultipartRelated multipartOutput = WsdlUtils.getExtensiblityElement(bindingOutput.getExtensibilityElements(), MIMEMultipartRelated.class);
            ((OperationConfig)this.getConfig()).setReceivesAttachments(multipartOutput != null);
        }
        MIMEMultipartRelated multipartInput = WsdlUtils.getExtensiblityElement(operation.getBindingInput().getExtensibilityElements(), MIMEMultipartRelated.class);
        ((OperationConfig)this.getConfig()).setSendsAttachments(multipartInput != null);
        if (multipartInput != null) {
            List parts = multipartInput.getMIMEParts();
            HashMap<String, PartsConfig.Part> partMap = new HashMap<String, PartsConfig.Part>();
            for (int c = 0; c < parts.size(); ++c) {
                List<MIMEContent> contentParts = WsdlUtils.getExtensiblityElements(((MIMEPart)parts.get(c)).getExtensibilityElements(), MIMEContent.class);
                for (MIMEContent content : contentParts) {
                    PartsConfig.Part part = (PartsConfig.Part)partMap.get(content.getPart());
                    if (part != null) {
                        if (part.getContentTypeList().contains(content.getType())) continue;
                        part.addContentType(content.getType());
                        continue;
                    }
                    if (!((OperationConfig)this.getConfig()).isSetRequestParts()) {
                        ((OperationConfig)this.getConfig()).addNewRequestParts();
                    }
                    PartsConfig.Part requestPart = ((OperationConfig)this.getConfig()).getRequestParts().addNewPart();
                    requestPart.addContentType(content.getType());
                    requestPart.setName(content.getPart());
                    partMap.put(requestPart.getName(), requestPart);
                }
            }
        }
    }

    public boolean getReceivesAttachments() {
        return ((OperationConfig)this.getConfig()).getReceivesAttachments();
    }

    public boolean getSendsAttachments() {
        return ((OperationConfig)this.getConfig()).getSendsAttachments();
    }

    public QName getRequestBodyElementQName() throws Exception {
        BindingOperation bindingOperation;
        WsdlInterface iface = this.getInterface();
        Definition definition = iface.getWsdlContext().getDefinition();
        if (WsdlUtils.isRpc(definition, bindingOperation = this.findBindingOperation(definition))) {
            String ns = WsdlUtils.getSoapBodyNamespace(bindingOperation.getBindingInput().getExtensibilityElements());
            if (ns == null) {
                ns = definition.getTargetNamespace();
            }
            return new QName(ns, bindingOperation.getName());
        }
        List parts = bindingOperation.getOperation().getInput().getMessage().getOrderedParts(null);
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        Part part = (Part)parts.get(0);
        if (part.getElementName() != null) {
            return part.getElementName();
        }
        return new QName(definition.getTargetNamespace(), part.getName());
    }

    public QName getResponseBodyElementQName() throws Exception {
        BindingOperation bindingOperation;
        if (this.isOneWay()) {
            return null;
        }
        WsdlInterface iface = this.getInterface();
        Definition definition = iface.getWsdlContext().getDefinition();
        if (WsdlUtils.isRpc(definition, bindingOperation = this.findBindingOperation(definition))) {
            String ns = WsdlUtils.getSoapBodyNamespace(bindingOperation.getBindingOutput().getExtensibilityElements());
            if (ns == null) {
                ns = definition.getTargetNamespace();
            }
            return new QName(ns, bindingOperation.getName() + "Response");
        }
        List parts = bindingOperation.getOperation().getOutput().getMessage().getOrderedParts(null);
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        Part part = (Part)parts.get(0);
        if (part.getElementName() != null) {
            return part.getElementName();
        }
        return new QName(definition.getTargetNamespace(), part.getName());
    }

    public String getStyle() {
        WsdlContext wsdlContext = this.iface.getWsdlContext();
        if (!wsdlContext.isLoaded()) {
            return "<not loaded>";
        }
        try {
            Definition definition = wsdlContext.getDefinition();
            BindingOperation bindingOperation = this.findBindingOperation(definition);
            if (bindingOperation == null) {
                return "<missing bindingOperation>";
            }
            if (WsdlUtils.isRpc(definition, bindingOperation)) {
                return STYLE_RPC;
            }
            return STYLE_DOCUMENT;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<error>";
        }
    }

    @Override
    public void release() {
        super.release();
        for (WsdlRequest request : this.requests) {
            request.release();
        }
    }

    public BindingOperation getBindingOperation() {
        try {
            return this.findBindingOperation(this.getInterface().getWsdlContext().getDefinition());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Request> getRequests() {
        return new ArrayList<Request>(this.requests);
    }

    public MessagePart[] getFaultParts() {
        BindingOperation bindingOperation = this.getBindingOperation();
        Map bindingFaults = bindingOperation.getBindingFaults();
        ArrayList<WsdlFaultPart> result = new ArrayList<WsdlFaultPart>();
        for (Object key : bindingFaults.keySet()) {
            result.add(new WsdlFaultPart((String)key));
        }
        return result.toArray(new MessagePart[result.size()]);
    }

    private class WsdlFaultPart
    extends MessagePart.FaultPart {
        private final String name;

        public WsdlFaultPart(String name) {
            this.name = name;
        }

        public Part[] getWsdlParts() {
            return WsdlUtils.getFaultParts(WsdlOperation.this.getBindingOperation(), this.name);
        }

        public QName getPartElement() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public SchemaType getSchemaType() {
            return null;
        }
    }
}

