/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.ModelItemConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.support.UISupport;
import java.util.Collection;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWsdlModelItem<T extends ModelItemConfig>
extends AbstractModelItem {
    private XmlBeansSettingsImpl settings;
    private T config;
    private ImageIcon icon;
    private final ModelItem parent;

    protected AbstractWsdlModelItem(T config, ModelItem parent, String icon) {
        this.parent = parent;
        if (config != null) {
            this.setConfig(config);
        }
        if (icon != null) {
            this.icon = UISupport.createImageIcon(icon);
        }
    }

    public ModelItem getParent() {
        return this.parent;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        if (icon == this.icon) {
            return;
        }
        ImageIcon oldIcon = this.icon;
        this.icon = icon;
        this.notifyPropertyChanged(ICON_PROPERTY, oldIcon, icon);
    }

    @Override
    public String getDescription() {
        return this.config.isSetDescription() ? this.config.getDescription() : this.getClass().getSimpleName().substring(4) + ": " + this.getName();
    }

    public void setDescription(String description) {
        String old = this.getDescription();
        this.config.setDescription(description);
        this.notifyPropertyChanged(DESCRIPTION_PROPERTY, old, description);
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    public void setName(String name) {
        String old = this.getName();
        this.config.setName(name);
        this.notifyPropertyChanged(NAME_PROPERTY, old, name);
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public final T getConfig() {
        return this.config;
    }

    public final void setConfig(T config) {
        this.config = config;
        if (this.settings != null) {
            this.settings.release();
        }
        if (!config.isSetSettings()) {
            config.addNewSettings();
        }
        this.settings = new XmlBeansSettingsImpl(this, this.parent == null ? SoapUI.getSettings() : this.parent.getSettings(), this.config.getSettings());
    }

    protected void setSettings(XmlBeansSettingsImpl settings) {
        if (this.settings != null) {
            this.settings.release();
        }
        this.settings = settings;
    }

    public AbstractWsdlModelItem getWsdlModelItemByName(Collection<? extends AbstractWsdlModelItem> items, String name) {
        for (AbstractWsdlModelItem abstractWsdlModelItem : items) {
            if (!abstractWsdlModelItem.getName().equals(name)) continue;
            return abstractWsdlModelItem;
        }
        return null;
    }

    public void release() {
        if (this.settings != null) {
            this.settings.release();
        }
    }
}

