/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.AnnotatedSettingsPrefs;
import com.eviware.soapui.actions.HttpPrefs;
import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.actions.ToolsPrefs;
import com.eviware.soapui.actions.UIPrefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.settings.WSISettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SwingConfigurationDialogImpl;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;

public class SoapUIPreferencesAction
extends AbstractAction {
    public static final String WS_I_SETTINGS = "WS-I Settings";
    public static final String WSDL_SETTINGS = "WSDL Settings";
    public static final String UI_SETTINGS = "UI Settings";
    public static final String PROXY_SETTINGS = "Proxy Settings";
    public static final String HTTP_SETTINGS = "HTTP Settings";
    public static final String SSL_SETTINGS = "SSL Settings";
    public static final String INTEGRATED_TOOLS = "Tools";
    private SwingConfigurationDialogImpl dialog;
    private Prefs uiPrefs;
    private Prefs wsiPrefs;
    private Prefs proxyPrefs;
    private Prefs wsdlPrefs;
    private Prefs toolsPrefs;
    private Prefs httpPrefs;
    private Prefs sslPrefs;
    private JTabbedPane tabs;
    private static SoapUIPreferencesAction instance;

    public SoapUIPreferencesAction() {
        super("Preferences");
        this.putValue("ShortDescription", "Sets global soapUI preferences");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt P"));
        this.wsiPrefs = new AnnotatedSettingsPrefs(WSISettings.class, WS_I_SETTINGS);
        this.proxyPrefs = new AnnotatedSettingsPrefs(ProxySettings.class, PROXY_SETTINGS);
        this.wsdlPrefs = new AnnotatedSettingsPrefs(WsdlSettings.class, WSDL_SETTINGS);
        this.sslPrefs = new AnnotatedSettingsPrefs(SSLSettings.class, SSL_SETTINGS);
        this.uiPrefs = new UIPrefs(UI_SETTINGS);
        this.toolsPrefs = new ToolsPrefs(INTEGRATED_TOOLS);
        this.httpPrefs = new HttpPrefs(HTTP_SETTINGS);
        instance = this;
    }

    public static SoapUIPreferencesAction getInstance() {
        if (instance == null) {
            instance = new SoapUIPreferencesAction();
        }
        return instance;
    }

    public void actionPerformed(ActionEvent e) {
        this.show(HTTP_SETTINGS);
    }

    public boolean show(String initialTab) {
        int ix;
        if (this.dialog == null) {
            this.buildDialog();
        }
        Settings settings = SoapUI.getSettings();
        this.httpPrefs.setFormValues(settings);
        this.toolsPrefs.setFormValues(settings);
        this.proxyPrefs.setFormValues(settings);
        this.wsiPrefs.setFormValues(settings);
        this.wsdlPrefs.setFormValues(settings);
        this.uiPrefs.setFormValues(settings);
        this.sslPrefs.setFormValues(settings);
        if (initialTab != null && (ix = this.tabs.indexOfTab(initialTab)) != -1) {
            this.tabs.setSelectedIndex(ix);
        }
        if (this.dialog.show(new StringToStringMap())) {
            this.httpPrefs.getFormValues(settings);
            this.toolsPrefs.getFormValues(settings);
            this.uiPrefs.getFormValues(settings);
            this.proxyPrefs.getFormValues(settings);
            this.wsiPrefs.getFormValues(settings);
            this.wsdlPrefs.getFormValues(settings);
            this.sslPrefs.getFormValues(settings);
            return true;
        }
        return false;
    }

    private void buildDialog() {
        this.dialog = new SwingConfigurationDialogImpl("soapUI Preferences", "http://www.soapui.org/userguide/preferences.html", "Set global soapUI settings", UISupport.OPTIONS_ICON);
        this.tabs = new JTabbedPane();
        this.tabs.addTab(HTTP_SETTINGS, this.httpPrefs.getForm().getPanel());
        this.tabs.addTab(PROXY_SETTINGS, this.proxyPrefs.getForm().getPanel());
        this.tabs.addTab(SSL_SETTINGS, this.sslPrefs.getForm().getPanel());
        this.tabs.addTab(UI_SETTINGS, this.uiPrefs.getForm().getPanel());
        this.tabs.addTab(INTEGRATED_TOOLS, this.toolsPrefs.getForm().getPanel());
        this.tabs.addTab(WSDL_SETTINGS, this.wsdlPrefs.getForm().getPanel());
        this.tabs.addTab(WS_I_SETTINGS, this.wsiPrefs.getForm().getPanel());
        this.dialog.setContent(UISupport.createTabPanel(this.tabs, false));
    }
}

