/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.client;

import it.javalinux.wise.core.client.WSEndpoint;
import it.javalinux.wise.core.exceptions.WiseConnectionException;
import it.javalinux.wise.core.exceptions.WiseRuntimeException;
import it.javalinux.wise.core.utils.JavaUtils;
import it.javalinux.wise.core.utils.WiseProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.tools.WSContractConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class WSDynamicClient
implements Serializable {
    private static final long serialVersionUID = -7185945063107035243L;
    public static final String WISE_TARGET_PACKAGE = "it.javalinux.wise";
    final String[] needeJars = new String[]{"jboss-jaxws.jar", "jaxb-api.jar", "jaxb-impl.jar"};
    private final WiseProperties wiseProperties;
    @GuardedBy(value="this")
    private Class serviceClass;
    @GuardedBy(value="this")
    private Object service;
    @GuardedBy(value="this")
    private URLClassLoader classLoader;

    public WSDynamicClient(WiseProperties wiseProperties) {
        this.wiseProperties = wiseProperties;
    }

    public void init(String wsdlURL, String cid, String userName, String password) throws WiseConnectionException {
        String tmpDir = this.wiseProperties.getProperty("wise.tmpDir");
        if (tmpDir == null) {
            tmpDir = this.getCurrentTmpDeployDir();
        }
        this.init(wsdlURL, cid, userName, password, tmpDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String wsdlURL, String symbolicName, String userName, String password, String tmpDir) throws WiseConnectionException {
        try {
            String targetPackage = this.wiseProperties.getProperty("wise.targetPackage", WISE_TARGET_PACKAGE);
            File outputDir = new File(tmpDir + "/" + symbolicName + "/");
            File sourceDir = new File(tmpDir + "/src/" + symbolicName + "/");
            boolean reimportObject = Boolean.parseBoolean(this.wiseProperties.getProperty("wise.forceImportObject"));
            if (!outputDir.exists()) {
                outputDir.mkdir();
                reimportObject = true;
            }
            if (reimportObject) {
                this.importObjectFromWsdl(wsdlURL, outputDir, sourceDir, targetPackage);
            }
            String[] classNames = this.getClassNames(outputDir, targetPackage);
            this.setClassLoader(new URLClassLoader(new URL[]{outputDir.toURL()}, Thread.currentThread().getContextClassLoader()));
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
                JavaUtils.loadJavaType("com.sun.xml.ws.spi.ProviderImpl", this.getClassLoader());
                for (int i = 0; i < classNames.length; ++i) {
                    Class clazz = JavaUtils.loadJavaType(targetPackage + "." + classNames[i], this.getClassLoader());
                    this.setServiceClass(clazz);
                    if (Service.class.isAssignableFrom(clazz)) break;
                }
                this.setService(this.getServiceClass().newInstance());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        catch (Exception e) {
            WiseRuntimeException.rethrow("Error occurred while consuming wsdl: " + wsdlURL, e);
        }
    }

    private void importObjectFromWsdl(String wsdlURL, File outputDir, File sourceDir, String targetPackage) throws MalformedURLException {
        WSContractConsumer wsImporter = WSContractConsumer.newInstance((ClassLoader)Thread.currentThread().getContextClassLoader());
        wsImporter.setGenerateSource(Boolean.parseBoolean(this.wiseProperties.getProperty("wise.keepGeneratedSources", "false")));
        wsImporter.setOutputDirectory(outputDir);
        wsImporter.setSourceDirectory(sourceDir);
        if (Boolean.parseBoolean(this.wiseProperties.getProperty("wise.wsImporter.verbose"))) {
            wsImporter.setMessageStream(System.out);
        }
        wsImporter.setAdditionalCompilerClassPath(this.defineAdditionalCompilerClassPath());
        wsImporter.setTargetPackage(targetPackage);
        wsImporter.consume(wsdlURL);
    }

    String[] getClassNames(File outputDir, String targetPackage) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        };
        File scanDir = new File(outputDir.getAbsolutePath() + "/" + targetPackage.replaceAll("\\.", "/") + "/");
        String[] children = scanDir.list(filter);
        for (int i = 0; i < children.length; ++i) {
            children[i] = children[i].substring(0, children[i].length() - 6);
        }
        return children;
    }

    List<String> defineAdditionalCompilerClassPath() throws WiseRuntimeException {
        LinkedList<String> cp = new LinkedList<String>();
        for (String jar : this.needeJars) {
            try {
                cp.add(Thread.currentThread().getContextClassLoader().getResource(jar).getPath());
            }
            catch (NullPointerException npe) {
                throw new WiseRuntimeException("Didnt't find jar needed by wsImport API:" + jar);
            }
        }
        return cp;
    }

    private String getCurrentTmpDeployDir() {
        String tmpDepDir = Thread.currentThread().getContextClassLoader().getResource("Wise.ejb3").getPath().substring(5);
        tmpDepDir = tmpDepDir.substring(0, tmpDepDir.lastIndexOf("!")) + "-contents/";
        return tmpDepDir;
    }

    public Map<String, WSEndpoint> processEndpoints() {
        HashMap<String, WSEndpoint> endpoints = new HashMap<String, WSEndpoint>();
        for (Method method : this.getServiceClass().getMethods()) {
            WebEndpoint annotation = method.getAnnotation(WebEndpoint.class);
            if (annotation == null) continue;
            WSEndpoint ep = this.getWiseEndpoint(annotation, method);
            endpoints.put(ep.getName(), ep);
        }
        return endpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSEndpoint getWiseEndpoint(WebEndpoint annotation, Method method) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        WSEndpoint ep = new WSEndpoint();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            ep.setName(annotation.name());
            ep.setClassLoader(this.getClassLoader());
            ep.setInstance(this.getServiceClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this.getService(), (Object[])null));
            ep.setClazz(this.getServiceClass().getMethod(method.getName(), method.getParameterTypes()).getReturnType());
        }
        catch (Exception e) {
            WiseRuntimeException.rethrow("Error while reading an endpoint!", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        return ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object instanceXmlElementDecl(String name, Class scope, String namespace, Object value) {
        try {
            Class objectFatoryClass = null;
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
                JavaUtils.loadJavaType("com.sun.xml.ws.spi.ProviderImpl", this.getClassLoader());
                objectFatoryClass = JavaUtils.loadJavaType("it.javalinux.wise.ObjectFactory", this.getClassLoader());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
            Method[] methods = objectFatoryClass.getMethods();
            Method methodToUse = null;
            for (int i = 0; i < methods.length; ++i) {
                XmlElementDecl annotation = methods[i].getAnnotation(XmlElementDecl.class);
                if (annotation == null || !name.equals(annotation.name()) || annotation.namespace() != null && !annotation.namespace().equals(namespace) || annotation.scope() != null && !annotation.scope().equals(scope)) continue;
                methodToUse = methods[i];
                break;
            }
            Object obj = objectFatoryClass.newInstance();
            if (methodToUse != null) {
                Logger.getLogger(this.getClass()).debug((Object)(methodToUse + " with value=" + value));
                return methodToUse.invoke(obj, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private final synchronized Class getServiceClass() {
        return this.serviceClass;
    }

    private final synchronized void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public final synchronized URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    private final synchronized void setClassLoader(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private final synchronized Object getService() {
        return this.service;
    }

    private final synchronized void setService(Object service) {
        this.service = service;
    }
}

