/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.client;

import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.soapbinding.QueryClient;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Request;
import com.sun.identity.xacml.context.Response;
import com.sun.identity.xacml.saml2.XACMLAuthzDecisionQuery;
import com.sun.identity.xacml.saml2.XACMLAuthzDecisionStatement;
import java.util.Date;
import java.util.List;

public class XACMLRequestProcessor {
    private XACMLRequestProcessor() {
    }

    public static XACMLRequestProcessor getInstance() throws XACMLException {
        return new XACMLRequestProcessor();
    }

    public Response processRequest(Request xacmlRequest, String pdpEntityId, String pepEntityId) throws XACMLException, SAML2Exception {
        if (XACMLSDKUtils.debug.messageEnabled()) {
            XACMLSDKUtils.debug.message("XACMLRequestProcessor.processRequest(), entering:pdpEntityId=" + pdpEntityId + ":pepEntityId=" + pepEntityId + ":xacmlRequest=\n" + xacmlRequest.toXMLString(true, true));
        }
        XACMLAuthzDecisionQuery samlpQuery = this.createXACMLAuthzDecisionQuery(xacmlRequest);
        samlpQuery.setInputContextOnly(true);
        samlpQuery.setReturnContext(true);
        if (XACMLSDKUtils.debug.messageEnabled()) {
            XACMLSDKUtils.debug.message("XACMLRequestProcessor.processRequest(),samlpQuery=\n" + samlpQuery.toXMLString(true, true));
        }
        com.sun.identity.saml2.protocol.Response samlpResponse = QueryClient.processXACMLQuery(samlpQuery, pepEntityId, pdpEntityId);
        if (XACMLSDKUtils.debug.messageEnabled()) {
            XACMLSDKUtils.debug.message("XACMLRequestProcessor.processRequest(),:samlpResponse=\n" + samlpResponse.toXMLString(true, true));
        }
        List assertions = samlpResponse.getAssertion();
        Assertion assertion = (Assertion)assertions.get(0);
        List statements = assertion.getStatements();
        String statementString = (String)statements.get(0);
        XACMLAuthzDecisionStatement statement = ContextFactory.getInstance().createXACMLAuthzDecisionStatement(statementString);
        if (XACMLSDKUtils.debug.messageEnabled()) {
            XACMLSDKUtils.debug.message("XACMLRequestProcessor.processRequest(),:xacmlAuthzDecisionStatement=\n" + statement.toXMLString(true, true));
        }
        Response xacmlResponse = statement.getResponse();
        if (XACMLSDKUtils.debug.messageEnabled()) {
            XACMLSDKUtils.debug.message("XACMLRequestProcessor.processRequest(), returning:xacmlResponse=\n" + xacmlResponse.toXMLString(true, true));
        }
        return xacmlResponse;
    }

    private XACMLAuthzDecisionQuery createXACMLAuthzDecisionQuery(Request xacmlRequest) throws XACMLException, SAML2Exception {
        XACMLAuthzDecisionQuery query = ContextFactory.getInstance().createXACMLAuthzDecisionQuery();
        query.setID("query-1");
        query.setVersion("2.0");
        query.setIssueInstant(new Date());
        query.setDestination("destination-uri");
        query.setConsent("consent-uri");
        Issuer issuer = AssertionFactory.getInstance().createIssuer();
        issuer.setValue("issuer-1");
        issuer.setNameQualifier("name-qualifier");
        issuer.setSPNameQualifier("sp-name-qualifier");
        issuer.setSPNameQualifier("sp-name-qualifier");
        issuer.setFormat("format");
        query.setIssuer(issuer);
        query.setRequest(xacmlRequest);
        return query;
    }
}

