/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider;

import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.ProviderUtils;
import com.sun.identity.wss.provider.TrustAuthorityConfig;
import com.sun.identity.wss.security.SecurityMechanism;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class ProviderConfig {
    public static final String WSC = "WSCAgent";
    public static final String WSP = "WSPAgent";
    public static final String WSS_PROVIDER_CONFIG_PLUGIN = "com.sun.identity.wss.provider.config.plugin";
    protected List secMech = null;
    protected String serviceURI = null;
    protected String providerName = null;
    protected String wspEndpoint = null;
    protected String wssProxyEndpoint = null;
    protected String providerType = null;
    protected KeyStore keyStore = null;
    protected String privateKeyAlias = null;
    protected String privateKeyType = null;
    protected String publicKeyAlias = null;
    protected boolean isResponseSigned = false;
    protected boolean isResponseEncrypted = false;
    protected boolean isRequestSigned = true;
    protected boolean isRequestEncrypted = false;
    protected boolean isRequestHeaderEncrypted = false;
    protected List trustAuthorities = null;
    protected String ksPasswd = null;
    protected String keyPasswd = null;
    protected String ksFile = null;
    protected Properties properties = new Properties();
    protected List usercredentials = null;
    protected String serviceType = null;
    protected boolean isDefaultKeyStore = false;
    protected boolean forceAuthn = false;
    protected boolean preserveSecHeaders = false;
    protected String authenticationChain = null;
    protected TrustAuthorityConfig taconfig = null;
    protected Set samlAttributes = null;
    protected boolean includeMemberships = false;
    protected String nameIDMapper = null;
    protected String attributeNS = null;
    private static Class adapterClass;

    public List getSecurityMechanisms() {
        return this.secMech;
    }

    public void setSecurityMechanisms(List authMech) {
        this.secMech = authMech;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public void setProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public String getWSPEndpoint() {
        return this.wspEndpoint;
    }

    public void setWSPEndpoint(String endpoint) {
        this.wspEndpoint = endpoint;
    }

    public String getWSSProxyEndpoint() {
        return this.wssProxyEndpoint;
    }

    public void setWSSProxyEndpoint(String endpoint) {
        this.wssProxyEndpoint = endpoint;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setUsers(List usercredentials) {
        this.usercredentials = usercredentials;
    }

    public List getUsers() {
        return this.usercredentials;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStoreFile() {
        return this.ksFile;
    }

    public String getKeyStorePassword() {
        return Crypt.decrypt(this.ksPasswd);
    }

    public String getKeyStoreEncryptedPasswd() {
        return this.ksPasswd;
    }

    public String getKeyPassword() {
        return Crypt.decrypt(this.keyPasswd);
    }

    public String getKeyEncryptedPassword() {
        return this.keyPasswd;
    }

    public void setKeyStore(String fileName, String keyStorePassword, String keyPassword) throws ProviderException {
        this.ksFile = fileName;
        this.ksPasswd = Crypt.encrypt(keyStorePassword);
        this.keyPasswd = Crypt.encrypt(keyPassword);
        try {
            File file = new File(fileName);
            if (file.exists()) {
                FileInputStream inputStream = new FileInputStream(fileName);
                this.keyStore = KeyStore.getInstance("JKS");
                this.keyStore.load(inputStream, keyStorePassword.toCharArray());
            }
        }
        catch (Exception ex) {
            ProviderUtils.debug.error("ProviderConfig.setKeyStore: Could notset the key store file information", ex);
            throw new ProviderException(ProviderUtils.bundle.getString("invalidKeyStore"));
        }
    }

    public void setKeyStore(KeyStore keyStore, String password) {
        this.keyStore = keyStore;
        this.ksPasswd = password;
    }

    public String getKeyType() {
        return this.privateKeyType;
    }

    public void setKeyType(String keyType) {
        this.privateKeyType = keyType;
    }

    public String getKeyAlias() {
        return this.privateKeyAlias;
    }

    public void setKeyAlias(String alias) {
        this.privateKeyAlias = alias;
    }

    public String getPublicKeyAlias() {
        return this.publicKeyAlias;
    }

    public void setPublicKeyAlias(String alias) {
        this.publicKeyAlias = alias;
    }

    public boolean useDefaultKeyStore() {
        return this.isDefaultKeyStore;
    }

    public void setDefaultKeyStore(boolean set) {
        this.isDefaultKeyStore = set;
    }

    public Set getSAMLAttributeMapping() {
        return this.samlAttributes;
    }

    public void setSAMLAttributeMapping(Set attributeMap) {
        this.samlAttributes = attributeMap;
    }

    public boolean shouldIncludeMemberships() {
        return this.includeMemberships;
    }

    public void setIncludeMemberships(boolean include) {
        this.includeMemberships = include;
    }

    public String getNameIDMapper() {
        return this.nameIDMapper;
    }

    public void setNameIDMapper(String nameIDMapper) {
        this.nameIDMapper = nameIDMapper;
    }

    public String getSAMLAttributeNamespace() {
        return this.attributeNS;
    }

    public void setSAMLAttributeNamespace(String attributeNS) {
        this.attributeNS = attributeNS;
    }

    public TrustAuthorityConfig getTrustAuthorityConfig() {
        return this.taconfig;
    }

    public void setTrustAuthorityConfig(TrustAuthorityConfig taconfig) {
        this.taconfig = taconfig;
    }

    public boolean isResponseSignEnabled() {
        return this.isResponseSigned;
    }

    public void setResponseSignEnabled(boolean enable) {
        this.isResponseSigned = enable;
    }

    public boolean isResponseEncryptEnabled() {
        return this.isResponseEncrypted;
    }

    public void setResponseEncryptEnabled(boolean enable) {
        this.isResponseEncrypted = enable;
    }

    public boolean isRequestSignEnabled() {
        return this.isRequestSigned;
    }

    public void setRequestSignEnabled(boolean enable) {
        this.isRequestSigned = enable;
    }

    public boolean isRequestEncryptEnabled() {
        return this.isRequestEncrypted;
    }

    public void setRequestEncryptEnabled(boolean enable) {
        this.isRequestEncrypted = enable;
    }

    public boolean isRequestHeaderEncryptEnabled() {
        return this.isRequestHeaderEncrypted;
    }

    public void setRequestHeaderEncryptEnabled(boolean enable) {
        this.isRequestHeaderEncrypted = enable;
    }

    public boolean forceUserAuthentication() {
        return this.forceAuthn;
    }

    public void setForceUserAuthentication(boolean forceAuthn) {
        this.forceAuthn = forceAuthn;
    }

    public boolean preserveSecurityHeader() {
        return this.preserveSecHeaders;
    }

    public void setPreserveSecurityHeader(boolean preserve) {
        this.preserveSecHeaders = preserve;
    }

    public String getAuthenticationChain() {
        return this.authenticationChain;
    }

    public void setAuthenticationChain(String authenticationChain) {
        this.authenticationChain = authenticationChain;
    }

    protected abstract void store() throws ProviderException;

    protected abstract void delete() throws ProviderException;

    protected abstract boolean isExists();

    protected abstract void init(String var1, String var2, SSOToken var3, boolean var4) throws ProviderException;

    public static void saveProvider(ProviderConfig config) throws ProviderException {
        config.store();
    }

    public static ProviderConfig getProvider(String providerName, String providerType) throws ProviderException {
        ProviderConfig pc = ProviderConfig.getConfigAdapter();
        SSOToken adminToken = ProviderConfig.getAdminToken();
        pc.init(providerName, providerType, adminToken, false);
        return pc;
    }

    public static ProviderConfig getProvider(String providerName, String providerType, boolean isEndPoint) throws ProviderException {
        ProviderConfig pc = ProviderConfig.getConfigAdapter();
        SSOToken adminToken = ProviderConfig.getAdminToken();
        pc.init(providerName, providerType, adminToken, isEndPoint);
        return pc;
    }

    public static boolean isProviderExists(String providerName, String providerType) {
        try {
            ProviderConfig config = ProviderConfig.getProvider(providerName, providerType);
            return config.isExists();
        }
        catch (ProviderException pe) {
            ProviderUtils.debug.error("ProviderConfig.isProviderExists:: Provider Exception ", pe);
            return false;
        }
    }

    public static void deleteProvider(String providerName, String providerType) throws ProviderException {
        ProviderConfig pc = ProviderConfig.getConfigAdapter();
        pc.init(providerName, providerType, ProviderConfig.getAdminToken(), false);
        pc.delete();
    }

    public static List getAllSupportedSecurityMech() {
        ArrayList<SecurityMechanism> list = new ArrayList<SecurityMechanism>();
        list.add(SecurityMechanism.WSS_NULL_SAML_SV);
        list.add(SecurityMechanism.WSS_TLS_SAML_SV);
        list.add(SecurityMechanism.WSS_CLIENT_TLS_SAML_SV);
        list.add(SecurityMechanism.WSS_NULL_SAML_HK);
        list.add(SecurityMechanism.WSS_TLS_SAML_HK);
        list.add(SecurityMechanism.WSS_CLIENT_TLS_SAML_HK);
        list.add(SecurityMechanism.WSS_NULL_X509_TOKEN);
        list.add(SecurityMechanism.WSS_TLS_X509_TOKEN);
        list.add(SecurityMechanism.WSS_CLIENT_TLS_X509_TOKEN);
        list.add(SecurityMechanism.WSS_NULL_USERNAME_TOKEN);
        list.add(SecurityMechanism.WSS_TLS_USERNAME_TOKEN);
        list.add(SecurityMechanism.WSS_CLIENT_TLS_USERNAME_TOKEN);
        list.add(SecurityMechanism.WSS_NULL_SAML2_SV);
        list.add(SecurityMechanism.WSS_TLS_SAML2_SV);
        list.add(SecurityMechanism.WSS_CLIENT_TLS_SAML2_SV);
        list.add(SecurityMechanism.WSS_NULL_SAML2_HK);
        list.add(SecurityMechanism.WSS_TLS_SAML2_HK);
        list.add(SecurityMechanism.WSS_CLIENT_TLS_SAML2_HK);
        list.add(SecurityMechanism.WSS_NULL_ANONYMOUS);
        list.add(SecurityMechanism.WSS_TLS_ANONYMOUS);
        list.add(SecurityMechanism.WSS_CLIENT_TLS_ANONYMOUS);
        list.add(SecurityMechanism.WSS_NULL_USERNAME_TOKEN_PLAIN);
        list.add(SecurityMechanism.WSS_TLS_USERNAME_TOKEN_PLAIN);
        list.add(SecurityMechanism.WSS_CLIENT_TLS_USERNAME_TOKEN_PLAIN);
        list.add(SecurityMechanism.STS_SECURITY);
        return list;
    }

    public static List getAllMessageLevelSecurityMech() {
        ArrayList<SecurityMechanism> list = new ArrayList<SecurityMechanism>();
        list.add(SecurityMechanism.WSS_NULL_SAML_SV);
        list.add(SecurityMechanism.WSS_NULL_SAML_HK);
        list.add(SecurityMechanism.WSS_NULL_X509_TOKEN);
        list.add(SecurityMechanism.WSS_NULL_USERNAME_TOKEN);
        list.add(SecurityMechanism.WSS_NULL_SAML2_SV);
        list.add(SecurityMechanism.WSS_NULL_SAML2_HK);
        list.add(SecurityMechanism.WSS_NULL_ANONYMOUS);
        list.add(SecurityMechanism.WSS_NULL_USERNAME_TOKEN_PLAIN);
        list.add(SecurityMechanism.STS_SECURITY);
        return list;
    }

    private static ProviderConfig getConfigAdapter() throws ProviderException {
        if (adapterClass == null) {
            String adapterName = SystemConfigurationUtil.getProperty(WSS_PROVIDER_CONFIG_PLUGIN, "com.sun.identity.wss.provider.plugins.AgentProvider");
            try {
                adapterClass = Class.forName(adapterName);
            }
            catch (Exception ex) {
                ProviderUtils.debug.error("ProviderConfig.getConfigAdapter: Failed in obtaining class", ex);
                throw new ProviderException(ProviderUtils.bundle.getString("initializationFailed"));
            }
        }
        try {
            return (ProviderConfig)adapterClass.newInstance();
        }
        catch (Exception ex) {
            ProviderUtils.debug.error("ProviderConfig.getConfigAdapter: Failed in initialization", ex);
            throw new ProviderException(ProviderUtils.bundle.getString("initializationFailed"));
        }
    }

    private static SSOToken getAdminToken() throws ProviderException {
        SSOToken adminToken = null;
        try {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            SSOTokenManager.getInstance().refreshSession(adminToken);
        }
        catch (SSOException se) {
            ProviderUtils.debug.message("ProviderConfig.getAdminToken:: Trying second time ....");
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return adminToken;
    }
}

