/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.PluginInterface;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ServiceSchemaManagerImpl {
    private String serviceName;
    private String version;
    private int instanceID;
    private String i18nKey;
    private String i18nFileName;
    private String i18nJarURL;
    private String serviceHierarchy;
    private String viewBeanURL;
    private int revisionNumber;
    private ServiceManager sm;
    private CachedSMSEntry smsEntry;
    private HashMap listenerObjects;
    private String xmlSchema;
    private Document document;
    private Node schemaRoot;
    private Map subSchemas;
    private Map pluginInterfaces;
    private static Debug debug = SMSEntry.debug;
    private static Map schemaManagers = new HashMap();
    private static final String schemaMgrMutex = "SchemaManagerMutext";
    private static final int DEFAULT_REVISION = 10;
    private static final int REVISION_ERROR = -1;

    private ServiceSchemaManagerImpl(SSOToken t, String serviceName, String version) throws SMSException, SSOException {
        ServiceManager.checkServiceNameAndVersion(t, serviceName, version);
        this.serviceName = serviceName;
        this.version = version;
        this.instanceID = SMSUtils.getInstanceID();
        this.listenerObjects = new HashMap();
        this.subSchemas = new HashMap();
        this.pluginInterfaces = new HashMap();
        this.smsEntry = CachedSMSEntry.getInstance(t, this, serviceName, version);
        this.update();
    }

    public String getName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    String getI18NKey() {
        return this.i18nKey;
    }

    void setI18NKey(String fn) throws SMSException, SSOException {
        this.i18nKey = fn;
        Node schemaNode = XMLUtils.getRootNode(this.getDocument(), "Schema");
        ((Element)schemaNode).setAttribute("i18nKey", fn);
    }

    int getRevisionNumber() {
        return this.revisionNumber;
    }

    void setRevisionNumber(int revisionNumber) throws SMSException, SSOException {
        this.revisionNumber = revisionNumber;
        Node schemaNode = XMLUtils.getRootNode(this.getDocument(), "Schema");
        ((Element)schemaNode).setAttribute("revisionNumber", Integer.toString(revisionNumber));
    }

    String getI18NFileName() {
        return this.i18nFileName;
    }

    void setI18NFileName(String fn) throws SMSException, SSOException {
        this.i18nFileName = fn;
        Node schemaNode = XMLUtils.getRootNode(this.getDocument(), "Schema");
        ((Element)schemaNode).setAttribute("i18nFileName", fn);
    }

    String getI18NJarURL() {
        return this.i18nJarURL;
    }

    void setI18NJarURL(String url) throws SMSException, SSOException {
        this.i18nJarURL = url;
        Node schemaNode = XMLUtils.getRootNode(this.getDocument(), "Schema");
        ((Element)schemaNode).setAttribute("i18nJarURL", url);
    }

    String getServiceHierarchy() {
        return this.serviceHierarchy;
    }

    void setServiceHierarchy(String newhierarchy) throws SMSException, SSOException {
        this.serviceHierarchy = newhierarchy;
        Node schemaNode = XMLUtils.getRootNode(this.getDocument(), "Schema");
        ((Element)schemaNode).setAttribute("serviceHierarchy", newhierarchy);
    }

    String getPropertiesViewBeanURL() {
        return this.viewBeanURL;
    }

    void setPropertiesViewBeanURL(String newhierarchy) throws SMSException, SSOException {
        this.viewBeanURL = newhierarchy;
        Node schemaNode = XMLUtils.getRootNode(this.getDocument(), "Schema");
        ((Element)schemaNode).setAttribute("propertiesViewBeanURL", newhierarchy);
    }

    Set getSchemaTypes() throws SMSException {
        return new HashSet(this.subSchemas.keySet());
    }

    ServiceSchemaImpl getSchema(SchemaType type) {
        ServiceSchemaImpl answer = (ServiceSchemaImpl)this.subSchemas.get(type);
        return answer;
    }

    InputStream getSchema() {
        return new ByteArrayInputStream(this.xmlSchema.getBytes());
    }

    CachedSMSEntry getCachedSMSEntry() {
        return this.smsEntry;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceSchemaManagerImpl) {
            ServiceSchemaManagerImpl ssm = (ServiceSchemaManagerImpl)o;
            if (this.serviceName.equals(ssm.serviceName) && this.version.equals(ssm.version) && this.instanceID == ssm.instanceID) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\nService Schema Manager: ").append(this.serviceName).append("\n\tVersion: ").append(this.version);
        sb.append("\nI18n file name: " + this.getI18NFileName());
        sb.append("\nI18n Jar URL: " + this.getI18NJarURL());
        sb.append("\nService hierarchy: " + this.getServiceHierarchy());
        sb.append("\nProperty View Bean: " + this.getPropertiesViewBeanURL());
        ServiceSchemaImpl ss = this.getSchema(SchemaType.GLOBAL);
        if (ss != null) {
            sb.append("\nGlobal Schema:\n").append(ss.toString());
        }
        if ((ss = this.getSchema(SchemaType.ORGANIZATION)) != null) {
            sb.append("Organization Schema:\n").append(ss.toString());
        }
        if ((ss = this.getSchema(SchemaType.DYNAMIC)) != null) {
            sb.append("Dynamic Schema:\n").append(ss.toString());
        }
        if ((ss = this.getSchema(SchemaType.USER)) != null) {
            sb.append("User Schema:\n").append(ss.toString());
        }
        if ((ss = this.getSchema(SchemaType.POLICY)) != null) {
            sb.append("Policy Schema:\n").append(ss.toString());
        }
        return sb.toString();
    }

    synchronized String addListener(ServiceListener listener) {
        String id = SMSUtils.getUniqueID();
        this.listenerObjects.put(id, listener);
        return id;
    }

    synchronized void removeListener(String listenerID) {
        this.listenerObjects.remove(listenerID);
    }

    Set getPluginInterfaceNames() {
        return new HashSet(this.pluginInterfaces.keySet());
    }

    PluginInterface getPluginInterface(String piName) {
        return (PluginInterface)this.pluginInterfaces.get(piName);
    }

    void setServiceManager(ServiceManager sm) {
        this.sm = sm;
    }

    Document getDocument() {
        return this.document;
    }

    Document getDocumentCopy() throws SMSException {
        String schema = this.xmlSchema;
        if (schema == null || schema.length() == 0) {
            schema = SMSSchema.getDummyXML(this.serviceName, this.version);
        }
        return SMSSchema.getXMLDocument(schema, false);
    }

    protected void finalize() throws Throwable {
        this.smsEntry.removeServiceListener(this);
    }

    synchronized void updateAndNotifyListeners() {
        this.update();
        HashMap lo = (HashMap)this.listenerObjects.clone();
        Iterator lObjects = lo.values().iterator();
        while (lObjects.hasNext()) {
            ServiceListener listener = (ServiceListener)lObjects.next();
            listener.schemaChanged(this.serviceName, this.version);
        }
    }

    synchronized void update() {
        this.xmlSchema = this.smsEntry.getXMLSchema();
        if (this.xmlSchema == null) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaManagerImpl:: schema is null " + this.serviceName + "(" + this.version + ")");
            }
            return;
        }
        try {
            this.document = SMSSchema.getXMLDocument(SMSSchema.getServiceSchemaInputStream(this.xmlSchema), false);
            this.schemaRoot = XMLUtils.getRootNode(this.document, "Schema");
        }
        catch (Exception e) {
            debug.error("ServiceSchemaManagerImpl: XML parser error: " + this.serviceName + "(" + this.version + ")", e);
            return;
        }
        if (this.schemaRoot == null) {
            debug.warning("ServiceSchemaManagerImpl: " + this.serviceName + "no schema found");
            return;
        }
        this.i18nKey = XMLUtils.getNodeAttributeValue(this.schemaRoot, "i18nKey");
        this.i18nFileName = XMLUtils.getNodeAttributeValue(this.schemaRoot, "i18nFileName");
        this.i18nJarURL = XMLUtils.getNodeAttributeValue(this.schemaRoot, "i18nJarURL");
        this.serviceHierarchy = XMLUtils.getNodeAttributeValue(this.schemaRoot, "serviceHierarchy");
        this.viewBeanURL = XMLUtils.getNodeAttributeValue(this.schemaRoot, "propertiesViewBeanURL");
        String revNum = XMLUtils.getNodeAttributeValue(this.schemaRoot, "revisionNumber");
        try {
            this.revisionNumber = revNum != null ? Integer.parseInt(revNum) : 10;
        }
        catch (Exception e) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaManagerImpl ==> " + this.serviceName + ": Invalid revision revision number: " + revNum, e);
            }
            this.revisionNumber = -1;
        }
        this.updateSchema(SchemaType.GLOBAL, "Global");
        this.updateSchema(SchemaType.ORGANIZATION, "Organization");
        this.updateSchema(SchemaType.DYNAMIC, "Dynamic");
        this.updateSchema(SchemaType.USER, "User");
        this.updateSchema(SchemaType.POLICY, "Policy");
        this.updateSchema(SchemaType.GROUP, "Group");
        this.updateSchema(SchemaType.DOMAIN, "Domain");
        this.updateGenericSchema("Generic");
        Iterator pins = XMLUtils.getChildNodes(this.schemaRoot, "PluginInterface").iterator();
        while (pins.hasNext()) {
            PluginInterface pi = new PluginInterface(this, (Node)pins.next());
            this.pluginInterfaces.put(pi.getName(), pi);
        }
    }

    void updateGenericSchema(String schemaName) {
        Iterator nodes = XMLUtils.getChildNodes(this.schemaRoot, schemaName).iterator();
        while (nodes.hasNext()) {
            Node childNode = (Node)nodes.next();
            String stype = XMLUtils.getNodeAttributeValue(childNode, "type");
            if (stype == null) continue;
            SchemaType type = new SchemaType(stype.toUpperCase());
            ServiceSchemaImpl ss = (ServiceSchemaImpl)this.subSchemas.get(type);
            if (ss != null) {
                ss.update(childNode);
                continue;
            }
            this.subSchemas.put(type, new ServiceSchemaImpl(this, childNode));
        }
    }

    void updateSchema(SchemaType type, String schemaName) {
        Node childNode = XMLUtils.getChildNode(this.schemaRoot, schemaName);
        if (childNode == null) {
            this.subSchemas.remove(type);
        } else {
            ServiceSchemaImpl ss = (ServiceSchemaImpl)this.subSchemas.get(type);
            if (ss != null) {
                ss.update(childNode);
            } else {
                this.subSchemas.put(type, new ServiceSchemaImpl(this, childNode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceSchemaManagerImpl getInstance(SSOToken t, String serviceName, String version) throws SMSException, SSOException {
        String cacheName = ServiceManager.getCacheIndex(serviceName, version);
        ServiceSchemaManagerImpl ssmi = (ServiceSchemaManagerImpl)schemaManagers.get(cacheName);
        if (ssmi != null && !ssmi.smsEntry.isValid()) {
            ssmi = null;
        }
        if (ssmi != null) {
            if (!SMSEntry.cacheSMSEntries) {
                ssmi.update();
            }
            return ssmi;
        }
        String string = schemaMgrMutex;
        synchronized (schemaMgrMutex) {
            ssmi = (ServiceSchemaManagerImpl)schemaManagers.get(cacheName);
            if (ssmi == null || !ssmi.smsEntry.isValid()) {
                ssmi = new ServiceSchemaManagerImpl(t, serviceName, version);
                HashMap<String, ServiceSchemaManagerImpl> sudoSchemaManagers = new HashMap<String, ServiceSchemaManagerImpl>(schemaManagers);
                sudoSchemaManagers.put(cacheName, ssmi);
                schemaManagers = sudoSchemaManagers;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return ssmi;
        }
    }

    static void clearCache() {
        schemaManagers = new HashMap();
    }

    public String toXML(AMEncryption encryptObj) throws SMSException {
        Document doc = this.getDocumentCopy();
        ServiceManager.checkAndEncryptPasswordSyntax(doc, false, encryptObj);
        return SMSSchema.nodeToString(XMLUtils.getRootNode(doc, "Service"));
    }
}

