/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.test.tools;

import com.sun.identity.shared.test.tools.Failure;
import java.text.MessageFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestCase {
    private String name;
    private String classname;
    private float timeTaken;
    private Failure failure;
    private boolean skipped;

    public TestCase(Node node) {
        this.parseNode(node);
    }

    public boolean passed() {
        return !this.failed() && !this.skipped();
    }

    public boolean failed() {
        return this.failure != null;
    }

    public boolean skipped() {
        return this.skipped;
    }

    public String toHTML() {
        String htmlID = "tblTestPassed";
        String status = "Succeeded";
        if (this.failed()) {
            htmlID = "tblTestFailed";
            status = "Failed";
        } else if (this.skipped()) {
            htmlID = "tblTestSkipped";
            status = "Skipped";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("<tr>");
        Object[] params = new Object[]{htmlID, this.name};
        buff.append(MessageFormat.format("<td id=\"{0}\">{1}</td>\n", params));
        params[1] = status;
        buff.append(MessageFormat.format("<td id=\"{0}\">{1}</td>\n", params));
        params[1] = Float.toString(this.timeTaken);
        buff.append(MessageFormat.format("<td id=\"{0}\" class=\"number\">{1}</td>\n", params));
        params[1] = this.failure != null ? "<pre>" + this.failure.getStackTrace() + "</pre>" : "&nbsp;";
        buff.append(MessageFormat.format("<td id=\"{0}\">{1}</td>\n", params));
        buff.append("</tr>");
        return buff.toString();
    }

    private void parseNode(Node node) {
        Element elt = (Element)node;
        this.name = elt.getAttribute("name");
        this.classname = elt.getAttribute("classname");
        this.timeTaken = Float.parseFloat(elt.getAttribute("time"));
        NodeList childElements = node.getChildNodes();
        int numChildElements = childElements.getLength();
        for (int i = 0; i < numChildElements; ++i) {
            Node n = childElements.item(i);
            if (n == null || n.getNodeType() != 1) continue;
            String elementName = n.getNodeName();
            if (elementName.equals("failure")) {
                this.failure = new Failure(n);
                continue;
            }
            if (!elementName.equals("skipped")) continue;
            this.skipped = true;
        }
    }
}

