/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.cert.CertId;
import com.sun.identity.security.cert.CertificateRevokedException;
import com.sun.identity.security.cert.OCSPRequest;
import com.sun.identity.security.cert.OCSPResponse;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.GeneralName;
import sun.security.x509.SerialNumber;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

class OCSPChecker
extends PKIXCertPathChecker {
    public static final String OCSP_ENABLE_PROP = "ocsp.enable";
    public static final String OCSP_URL_PROP = "ocsp.responderURL";
    public static final String OCSP_CERT_SUBJECT_PROP = "ocsp.responderCertSubjectName";
    public static final String OCSP_CERT_ISSUER_PROP = "ocsp.responderCertIssuerName";
    public static final String OCSP_CERT_NUMBER_PROP = "ocsp.responderCertSerialNumber";
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final Debug debug = SecurityDebug.debug;
    private static final boolean dump = false;
    private static final String AUTH_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.1";
    private static final int[] OCSP_NONCE_DATA = new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2};
    private static final ObjectIdentifier OCSP_NONCE_OID = ObjectIdentifier.newInternal((int[])OCSP_NONCE_DATA);
    private int remainingCerts;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;

    OCSPChecker(CertPath certPath, PKIXParameters pkixParams) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pkixParams;
        List<? extends Certificate> tmp = this.cp.getCertificates();
        this.certs = tmp.toArray(new X509Certificate[tmp.size()]);
        this.init(false);
    }

    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certs.length;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        return Collections.EMPTY_SET;
    }

    public void check(Certificate cert, Collection unresolvedCritExts) throws CertPathValidatorException {
        try {
            X509Certificate responderCert = null;
            boolean seekResponderCert = false;
            X500Principal responderSubjectName = null;
            X500Principal responderIssuerName = null;
            BigInteger responderSerialNumber = null;
            String[] properties = OCSPChecker.getOCSPProperties();
            if (properties[1] != null) {
                responderSubjectName = new X500Principal(properties[1]);
            } else if (properties[2] != null && properties[3] != null) {
                responderIssuerName = new X500Principal(properties[2]);
                String value = OCSPChecker.stripOutSeparators(properties[3]);
                responderSerialNumber = new BigInteger(value, 16);
            } else if (properties[2] != null || properties[3] != null) {
                throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
            }
            if (responderSubjectName != null || responderIssuerName != null) {
                seekResponderCert = true;
            }
            boolean seekIssuerCert = true;
            X509CertImpl issuerCertImpl = null;
            X509CertImpl currCertImpl = X509CertImpl.toImpl((X509Certificate)cert);
            --this.remainingCerts;
            if (this.remainingCerts != 0) {
                issuerCertImpl = X509CertImpl.toImpl(this.certs[this.remainingCerts]);
                seekIssuerCert = false;
                if (!seekResponderCert) {
                    responderCert = this.certs[this.remainingCerts];
                    if (debug.messageEnabled()) {
                        debug.message("OCSPChecker.check: Responder's certificate is the same as the issuer of the certificate being validated");
                    }
                }
            }
            if (seekIssuerCert || seekResponderCert) {
                Iterator<TrustAnchor> anchors;
                if (debug.messageEnabled()) {
                    debug.message("OCSPChecker.check: seekIssuerCert = " + seekIssuerCert + ", seekResponderCert = " + seekResponderCert);
                }
                if (!(anchors = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                    throw new CertPathValidatorException("Must specify at least one trust anchor");
                }
                X500Principal certIssuerName = currCertImpl.getIssuerX500Principal();
                while (anchors.hasNext() && (seekIssuerCert || seekResponderCert)) {
                    TrustAnchor anchor = anchors.next();
                    X509Certificate anchorCert = anchor.getTrustedCert();
                    X500Principal anchorSubjectName = anchorCert.getSubjectX500Principal();
                    if (seekIssuerCert && certIssuerName.equals(anchorSubjectName)) {
                        issuerCertImpl = X509CertImpl.toImpl(anchorCert);
                        seekIssuerCert = false;
                        if (!seekResponderCert && responderCert == null) {
                            responderCert = anchorCert;
                            if (debug.messageEnabled()) {
                                debug.message("OCSPChecker.check: Responder's certificate is the same as the issuer of the certificate being validated");
                            }
                        }
                    }
                    if (!seekResponderCert || (responderSubjectName == null || !responderSubjectName.equals(anchorSubjectName)) && (responderIssuerName == null || responderSerialNumber == null || !responderIssuerName.equals(anchorCert.getIssuerX500Principal()) || !responderSerialNumber.equals(anchorCert.getSerialNumber()))) continue;
                    responderCert = anchorCert;
                    seekResponderCert = false;
                }
                if (issuerCertImpl == null) {
                    throw new CertPathValidatorException("No trusted certificate for " + currCertImpl.getIssuerDN());
                }
                if (seekResponderCert) {
                    if (debug.messageEnabled()) {
                        debug.message("OCSPChecker.check: Searching cert stores for responder's certificate");
                    }
                    X509CertSelector filter = null;
                    if (responderSubjectName != null) {
                        filter = new X509CertSelector();
                        filter.setSubject(responderSubjectName.getName());
                    } else if (responderIssuerName != null && responderSerialNumber != null) {
                        filter = new X509CertSelector();
                        filter.setIssuer(responderIssuerName.getName());
                        filter.setSerialNumber(responderSerialNumber);
                    }
                    if (filter != null) {
                        List<CertStore> certStores = this.pkixParams.getCertStores();
                        Iterator<CertStore> iter = certStores.iterator();
                        while (iter.hasNext()) {
                            CertStore certStore = iter.next();
                            Iterator<? extends Certificate> i = certStore.getCertificates(filter).iterator();
                            if (!i.hasNext()) continue;
                            responderCert = (X509Certificate)i.next();
                            seekResponderCert = false;
                            break;
                        }
                    }
                }
            }
            if (seekResponderCert) {
                throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
            }
            OCSPRequest ocspRequest = new OCSPRequest(currCertImpl, issuerCertImpl);
            URL url = OCSPChecker.getOCSPServerURL(currCertImpl, properties);
            HttpURLConnection con = HttpURLConnectionManager.getConnection(url);
            if (debug.messageEnabled()) {
                debug.message("OCSPChecker.check: connecting to OCSP service at: " + url);
            }
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            byte[] bytes = ocspRequest.encodeBytes();
            CertId certId = ocspRequest.getCertId();
            con.setRequestProperty("Content-length", String.valueOf(bytes.length));
            OutputStream out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            if (debug.messageEnabled()) {
                debug.message("OCSPChecker.check: HTTP response code = " + con.getResponseCode() + ", response message = " + con.getResponseMessage());
            }
            InputStream in = con.getInputStream();
            int contentLength = con.getContentLength();
            if (contentLength == -1) {
                contentLength = Integer.MAX_VALUE;
            }
            byte[] response = new byte[contentLength];
            int count = 0;
            for (int total = 0; count != -1 && total < contentLength; total += count) {
                count = in.read(response, total, response.length - total);
            }
            in.close();
            out.close();
            OCSPResponse ocspResponse = new OCSPResponse(response, this.pkixParams, responderCert);
            if (!certId.equals(ocspResponse.getCertId())) {
                throw new CertPathValidatorException("Certificate in the OCSP response does not match the certificate supplied in the OCSP request.");
            }
            SerialNumber serialNumber = new SerialNumber(currCertImpl.getSerialNumber());
            int certOCSPStatus = ocspResponse.getCertStatus(serialNumber);
            if (debug.messageEnabled()) {
                debug.message("OCSPChecker.check: Status of certificate (with serial number " + serialNumber.getNumber() + ") is: " + OCSPResponse.certStatusToText(certOCSPStatus));
            }
            if (certOCSPStatus == 1) {
                throw new CertificateRevokedException("Certificate has been revoked", this.cp, this.remainingCerts);
            }
            if (certOCSPStatus == 2) {
                throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.remainingCerts);
            }
        }
        catch (CertificateRevokedException cre) {
            throw cre;
        }
        catch (CertPathValidatorException cpve) {
            throw cpve;
        }
        catch (Exception e) {
            debug.error("OCSPChecker.check: ", e);
            throw new CertPathValidatorException(e);
        }
    }

    private static URL getOCSPServerURL(X509CertImpl currCertImpl, String[] properties) throws CertificateParsingException, CertPathValidatorException {
        if (properties[0] != null) {
            try {
                return new URL(properties[0]);
            }
            catch (MalformedURLException e) {
                throw new CertPathValidatorException(e);
            }
        }
        Collection c = OCSPChecker.getAuthorityInformationAccess(currCertImpl);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            GeneralName gn;
            AccessDescription ad = (AccessDescription)it.next();
            if (!ad.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (gn = ad.getAccessLocation()).getType() != 6) continue;
            try {
                URIName uri = (URIName)gn.getName();
                return new URL(uri.getName());
            }
            catch (MalformedURLException e) {
                throw new CertPathValidatorException(e);
            }
        }
        return null;
    }

    private static String[] getOCSPProperties() {
        final String[] properties = new String[4];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                properties[0] = Security.getProperty(OCSPChecker.OCSP_URL_PROP);
                properties[1] = Security.getProperty(OCSPChecker.OCSP_CERT_SUBJECT_PROP);
                properties[2] = Security.getProperty(OCSPChecker.OCSP_CERT_ISSUER_PROP);
                properties[3] = Security.getProperty(OCSPChecker.OCSP_CERT_NUMBER_PROP);
                return null;
            }
        });
        return properties;
    }

    private static String stripOutSeparators(String value) {
        char[] chars = value.toCharArray();
        StringBuffer hexNumber = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (HEX_DIGITS.indexOf(chars[i]) == -1) continue;
            hexNumber.append(chars[i]);
        }
        return hexNumber.toString();
    }

    private static Collection getAuthorityInformationAccess(X509Certificate cert) throws CertificateParsingException {
        try {
            byte[] extValue = cert.getExtensionValue(AUTH_INFO_ACCESS_OID);
            if (extValue == null) {
                return Collections.EMPTY_SET;
            }
            HexDumpEncoder enc = new HexDumpEncoder();
            DerInputStream der = new DerInputStream(extValue);
            DerInputStream subDer = new DerInputStream(der.getOctetString());
            DerValue[] derVal = subDer.getSequence(5);
            HashSet<AccessDescription> accessDesc = new HashSet<AccessDescription>(derVal.length);
            for (int i = 0; i < derVal.length; ++i) {
                accessDesc.add(new AccessDescription(derVal[i]));
            }
            return Collections.unmodifiableSet(accessDesc);
        }
        catch (IOException ioe) {
            return Collections.EMPTY_SET;
        }
    }
}

