/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.sun.identity.security.SecurityDebug;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.SerialNumber;
import sun.security.x509.X509CertImpl;

public class CertId {
    private static final Debug debug = SecurityDebug.debug;
    private AlgorithmId hashAlgId;
    private byte[] issuerNameHash;
    private byte[] issuerKeyHash;
    private SerialNumber certSerialNumber;
    private int myhash = -1;

    public CertId(X509CertImpl issuerCert, SerialNumber serialNumber) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        this.hashAlgId = AlgorithmId.get("SHA1");
        md.update(issuerCert.getIssuerX500Principal().getEncoded());
        this.issuerNameHash = md.digest();
        byte[] pubKey = issuerCert.getPublicKey().getEncoded();
        DerValue val = new DerValue(pubKey);
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue()};
        byte[] keyBytes = seq[1].getBitString();
        md.update(keyBytes);
        this.issuerKeyHash = md.digest();
        this.certSerialNumber = serialNumber;
        if (debug.messageEnabled()) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            debug.message("CertId.CertId: Issuer Certificate is " + issuerCert + "\nissuerNameHash is " + encoder.encode(this.issuerNameHash) + "\nissuerKeyHash is " + encoder.encode(this.issuerKeyHash));
        }
    }

    public CertId(DerInputStream derIn) throws IOException {
        this.hashAlgId = AlgorithmId.parse(derIn.getDerValue());
        this.issuerNameHash = derIn.getOctetString();
        this.issuerKeyHash = derIn.getOctetString();
        this.certSerialNumber = new SerialNumber(derIn);
    }

    public AlgorithmId getHashAlgorithm() {
        return this.hashAlgId;
    }

    public byte[] getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public byte[] getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public BigInteger getSerialNumber() {
        return this.certSerialNumber.getNumber();
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.hashAlgId.encode(tmp);
        tmp.putOctetString(this.issuerNameHash);
        tmp.putOctetString(this.issuerKeyHash);
        this.certSerialNumber.encode(tmp);
        out.write((byte)48, tmp);
        if (debug.messageEnabled()) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            debug.message("CertId.encode: Encoded certId is " + encoder.encode(out.toByteArray()));
        }
    }

    public int hashCode() {
        if (this.myhash == -1) {
            int i;
            this.myhash = this.hashAlgId.hashCode();
            for (i = 0; i < this.issuerNameHash.length; ++i) {
                this.myhash += this.issuerNameHash[i] * i;
            }
            for (i = 0; i < this.issuerKeyHash.length; ++i) {
                this.myhash += this.issuerKeyHash[i] * i;
            }
            this.myhash += this.certSerialNumber.getNumber().hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof CertId)) {
            return false;
        }
        CertId that = (CertId)other;
        return this.hashAlgId.equals(that.getHashAlgorithm()) && Arrays.equals(this.issuerNameHash, that.getIssuerNameHash()) && Arrays.equals(this.issuerKeyHash, that.getIssuerKeyHash()) && this.certSerialNumber.getNumber().equals(that.getSerialNumber());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CertId \n");
        sb.append("Algorithm: " + this.hashAlgId.toString() + "\n");
        sb.append("issuerNameHash \n");
        HexDumpEncoder encoder = new HexDumpEncoder();
        sb.append(encoder.encode(this.issuerNameHash));
        sb.append("\nissuerKeyHash: \n");
        sb.append(encoder.encode(this.issuerKeyHash));
        sb.append("\n" + this.certSerialNumber.toString());
        return sb.toString();
    }
}

