/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.cert.OCSPChecker;
import com.sun.identity.shared.debug.Debug;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class AMCertPath {
    private static CertificateFactory cf = null;
    private static CertPathValidator cpv = null;
    private CertStore store = null;
    public static Debug debug = SecurityDebug.debug;

    public AMCertPath(Vector crls) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (crls != null && crls.size() > 0) {
            if (debug.messageEnabled()) {
                X509CRL crl = (X509CRL)crls.elementAt(0);
                debug.message("AMCertPath:AMCertPath: crl =" + crl.toString());
            }
            CollectionCertStoreParameters collection = new CollectionCertStoreParameters(crls);
            this.store = CertStore.getInstance("Collection", collection);
        } else if (debug.messageEnabled()) {
            debug.message("AMCertPath:AMCertPath: no crl");
        }
    }

    public boolean verify(X509Certificate[] certs, boolean crlEnabled, boolean ocspEnabled) {
        if (debug.messageEnabled()) {
            debug.message("AMCertPath.verify: invoked !");
        }
        try {
            List<X509Certificate> certList = Arrays.asList(certs);
            CertPath cp = cf.generateCertPath(certList);
            Class<?> trustMgrClass = Class.forName("com.sun.identity.security.keystore.AMX509TrustManager");
            Object trustMgr = trustMgrClass.newInstance();
            Method method = trustMgrClass.getMethod("getKeyStore", null);
            KeyStore keystore = (KeyStore)method.invoke(trustMgr, null);
            PKIXParameters pkixparams = new PKIXParameters(keystore);
            if (ocspEnabled) {
                OCSPChecker ocspChecker = new OCSPChecker(cp, pkixparams);
                pkixparams.addCertPathChecker(ocspChecker);
            }
            if (debug.messageEnabled()) {
                debug.message("AMCertPath.verify: crlEnabled ---> " + crlEnabled);
            }
            pkixparams.setRevocationEnabled(crlEnabled);
            if (this.store != null) {
                pkixparams.addCertStore(this.store);
            }
            CertPathValidatorResult cpvResult = cpv.validate(cp, pkixparams);
            if (debug.messageEnabled()) {
                debug.message("AMCertPath.verify: PASS" + cpvResult.toString());
            }
        }
        catch (Throwable t) {
            debug.error("AMCertPath.verify: FAILED", t);
            return false;
        }
        return true;
    }

    static {
        try {
            cf = CertificateFactory.getInstance("X509");
            cpv = CertPathValidator.getInstance("PKIX");
        }
        catch (Exception e) {
            debug.error("AMCertPath.Static:", e);
        }
    }
}

