/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AssertionIDRef;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.protocol.AssertionIDRequest;
import com.sun.identity.saml2.protocol.impl.RequestAbstractImpl;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AssertionIDRequestImpl
extends RequestAbstractImpl
implements AssertionIDRequest {
    protected List assertionIDRefs;

    public AssertionIDRequestImpl() {
        this.elementName = "AssertionIDRequest";
        this.isMutable = true;
    }

    public AssertionIDRequestImpl(Element element) throws SAML2Exception {
        this.parseDOMElement(element);
        this.elementName = "AssertionIDRequest";
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print(element);
        }
    }

    public AssertionIDRequestImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument(xmlString, SAML2Utils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorObtainingElement"));
        }
        this.parseDOMElement(xmlDocument.getDocumentElement());
        this.elementName = "AssertionIDRequest";
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
    }

    public List getAssertionIDRefs() {
        return this.assertionIDRefs;
    }

    public void setAssertionIDRefs(List assertionIDRefs) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("objectImmutable"));
        }
        this.assertionIDRefs = assertionIDRefs;
    }

    protected void getXMLString(Set namespaces, StringBuffer attrs, StringBuffer childElements, boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateData();
        if (declareNS) {
            namespaces.add(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"".trim());
            namespaces.add(" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"".trim());
        }
        super.getXMLString(namespaces, attrs, childElements, includeNSPrefix, declareNS);
        Iterator iter = this.assertionIDRefs.iterator();
        while (iter.hasNext()) {
            AssertionIDRef assertionIDRef = (AssertionIDRef)iter.next();
            childElements.append(assertionIDRef.toXMLString(includeNSPrefix, declareNS)).append("\n");
        }
    }

    protected void validateData() throws SAML2Exception {
        if (this.assertionIDRefs == null || this.assertionIDRefs.isEmpty()) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestImpl.getXMLString: AssertionIDRef is expected");
            }
            throw new SAML2Exception(SAML2Utils.bundle.getString("schemaViolation"));
        }
    }

    protected void parseDOMAttributes(Element element) throws SAML2Exception {
        super.parseDOMAttributes(element);
    }

    protected void parseDOMChileElements(ListIterator iter) throws SAML2Exception {
        super.parseDOMChileElements(iter);
        AssertionFactory aFactory = AssertionFactory.getInstance();
        while (iter.hasNext()) {
            Element childElement = (Element)iter.next();
            String localName = childElement.getLocalName();
            if ("AssertionIDRef".equals(localName)) {
                AssertionIDRef assertionIDRef = aFactory.createAssertionIDRef(childElement);
                if (this.assertionIDRefs == null) {
                    this.assertionIDRefs = new ArrayList();
                }
                this.assertionIDRefs.add(assertionIDRef);
                continue;
            }
            iter.previous();
            break;
        }
        if (this.assertionIDRefs == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("schemaViolation"));
        }
    }
}

