/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.common;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import java.util.StringTokenizer;

public class NameIDInfoKey {
    private static final String DELIM = "|";
    private String _hostEntityID = null;
    private String _remoteEntityID = null;
    private String _nameIDValue = null;

    private NameIDInfoKey() {
    }

    public NameIDInfoKey(String nameIDValue, String hostEntityID, String remoteEntityID) throws SAML2Exception {
        if (nameIDValue == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullNameIDValue"));
        }
        if (hostEntityID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullHostEntityID"));
        }
        if (remoteEntityID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullRemoteEntityID"));
        }
        this._nameIDValue = nameIDValue;
        this._hostEntityID = hostEntityID;
        this._remoteEntityID = remoteEntityID;
    }

    public String getNameIDValue() {
        return this._nameIDValue;
    }

    public String getHostEntityID() {
        return this._hostEntityID;
    }

    public String getRemoteEntityID() {
        return this._remoteEntityID;
    }

    public String toValueString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._hostEntityID).append(DELIM).append(this._remoteEntityID).append(DELIM).append(this._nameIDValue);
        return sb.toString();
    }

    public static NameIDInfoKey parse(String infoKey) throws SAML2Exception {
        if (infoKey == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullNameIDInfoKey"));
        }
        StringTokenizer st = new StringTokenizer(infoKey, DELIM);
        if (st.countTokens() != 3) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("inValidNameIDInfoKey"));
        }
        String hostID = st.nextToken();
        String remoteID = st.nextToken();
        String nameID = st.nextToken();
        return new NameIDInfoKey(nameID, hostID, remoteID);
    }
}

