/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.KeyInfoConfirmationData;
import com.sun.identity.saml2.assertion.impl.SubjectConfirmationDataImpl;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfoConfirmationDataImpl
extends SubjectConfirmationDataImpl
implements KeyInfoConfirmationData {
    public final String elementName = "KeyInfoConfirmationData";
    private List keyInfo = null;

    public KeyInfoConfirmationDataImpl() {
        this.mutable = true;
    }

    public KeyInfoConfirmationDataImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        this.makeImmutable();
    }

    public KeyInfoConfirmationDataImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception("");
        }
        this.parseElement(doc.getDocumentElement());
        this.makeImmutable();
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("KeyInfoConfirmationDataImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("KeyInfoConfirmationData")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("KeyInfoConfirmationDataImpl.parseElement: not EncryptedIDImpl.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NamedNodeMap attrs = element.getAttributes();
        this.parseAttributes(attrs);
        this.parseContent(element);
        this.parseKeyInfo(element);
    }

    private void parseKeyInfo(Element element) throws SAML2Exception {
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null || !childName.equals("KeyInfo")) continue;
            this.getKeyInfo().add(XMLUtils.print((Element)child));
        }
    }

    public List getKeyInfo() {
        if (this.keyInfo == null) {
            this.keyInfo = new ArrayList();
        }
        return this.keyInfo;
    }

    public void setKeyInfo(List info) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.keyInfo = info;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        StringBuffer xml = new StringBuffer();
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        xml.append("<").append(appendNS).append("KeyInfoConfirmationData");
        xml.append(NS).append(" ");
        xml.append(this.getElementValue(includeNSPrefix, declareNS));
        if (!this.getKeyInfo().isEmpty()) {
            Iterator it = this.keyInfo.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                xml.append(key);
            }
        }
        xml.append("</").append(appendNS).append("KeyInfoConfirmationData").append(">");
        return xml.toString();
    }

    public void makeImmutable() {
        if (!this.mutable) {
            return;
        }
        super.makeImmutable();
        if (this.keyInfo != null && !this.keyInfo.isEmpty()) {
            this.keyInfo = Collections.unmodifiableList(this.keyInfo);
        }
    }
}

