/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthnContextImpl
implements AuthnContext {
    private String authnContextClassRef = null;
    private String authnContextDecl = null;
    private String authnContextDeclRef = null;
    private List authenticatingAuthority = null;
    private boolean mutable = true;

    private void validateData() throws SAML2Exception {
        if (!(this.authnContextClassRef != null && this.authnContextClassRef.trim().length() != 0 || this.authnContextDecl != null && this.authnContextDecl.trim().length() != 0 || this.authnContextDeclRef != null && this.authnContextDeclRef.trim().length() != 0)) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnContextImpl.validateData: missing AuthnContextClassRef or AuthnContextDecl(Ref).");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElement"));
        }
        if (this.authnContextDecl != null && this.authnContextDecl.trim().length() != 0 && this.authnContextDeclRef != null && this.authnContextDeclRef.trim().length() != 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnContextImpl.validateData: AuthnContextDecl and AuthnContextDeclRef cannot present the same time.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("AuthnContext")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: not AuthnContext.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("AuthnContextClassRef")) {
                if (this.authnContextClassRef != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: included more than one AuthnContextClassRef.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                if (this.authnContextDecl != null || this.authnContextDeclRef != null || this.authenticatingAuthority != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: AuthnContextClassRef should be the first child element.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
                }
                this.authnContextClassRef = XMLUtils.getElementValue((Element)child);
                if (this.authnContextClassRef != null && this.authnContextClassRef.trim().length() != 0) continue;
                if (SAML2SDKUtils.debug.messageEnabled()) {
                    SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: value for AuthnContextClassRef is empty.");
                }
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElementValue"));
            }
            if (childName.equals("AuthnContextDecl")) {
                if (this.authnContextDecl != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: included more than one AuthnContextDecl.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                this.authnContextDecl = XMLUtils.print(child);
                if (this.authnContextDecl != null && this.authnContextDecl.trim().length() != 0) continue;
                if (SAML2SDKUtils.debug.messageEnabled()) {
                    SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: value for AuthnContextDecl is empty.");
                }
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElementValue"));
            }
            if (childName.equals("AuthnContextDeclRef")) {
                if (this.authnContextDeclRef != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: included more than one AuthnContextDeclRef.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                this.authnContextDeclRef = XMLUtils.getElementValue((Element)child);
                if (this.authnContextDeclRef != null && this.authnContextDeclRef.trim().length() != 0) continue;
                if (SAML2SDKUtils.debug.messageEnabled()) {
                    SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: value for AuthnContextDeclRef is empty.");
                }
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElementValue"));
            }
            if (childName.equals("AuthenticatingAuthority")) {
                String authority = XMLUtils.getElementValue((Element)child);
                if (authority == null || authority.trim().length() == 0) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: value for AuthenticatingAuthority is empty.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElementValue"));
                }
                if (this.authenticatingAuthority == null) {
                    this.authenticatingAuthority = new ArrayList();
                }
                this.authenticatingAuthority.add(authority);
                continue;
            }
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnContextImpl.parseElement: Invalid element:" + childName);
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidElement"));
        }
        if (this.authenticatingAuthority != null) {
            this.authenticatingAuthority = Collections.unmodifiableList(this.authenticatingAuthority);
        }
        this.mutable = false;
    }

    public AuthnContextImpl() {
    }

    public AuthnContextImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public AuthnContextImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
    }

    public void makeImmutable() {
        if (this.mutable && this.authenticatingAuthority != null) {
            this.authenticatingAuthority = Collections.unmodifiableList(this.authenticatingAuthority);
        }
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public void setAuthnContextClassRef(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.authnContextClassRef = value;
    }

    public String getAuthnContextDeclRef() {
        return this.authnContextDeclRef;
    }

    public void setAuthnContextDeclRef(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.authnContextDeclRef = value;
    }

    public String getAuthnContextDecl() {
        return this.authnContextDecl;
    }

    public void setAuthnContextDecl(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.authnContextDecl = value;
    }

    public void setAuthenticatingAuthority(List value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.authenticatingAuthority = value;
    }

    public List getAuthenticatingAuthority() {
        return this.authenticatingAuthority;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        this.validateData();
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        result.append("<").append(prefix).append("AuthnContext").append(uri).append(">");
        if (this.authnContextClassRef != null && this.authnContextClassRef.trim().length() != 0) {
            result.append("<").append(prefix).append("AuthnContextClassRef").append(uri).append(">").append(this.authnContextClassRef).append("</").append(prefix).append("AuthnContextClassRef>");
        }
        if (this.authnContextDecl != null && this.authnContextDecl.trim().length() != 0) {
            result.append(this.authnContextDecl);
        } else if (this.authnContextDeclRef != null && this.authnContextDeclRef.trim().length() != 0) {
            result.append("<").append(prefix).append("AuthnContextDeclRef").append(uri).append(">").append(this.authnContextDeclRef).append("</").append(prefix).append("AuthnContextDeclRef>");
        }
        if (this.authenticatingAuthority != null) {
            Iterator iter = this.authenticatingAuthority.iterator();
            while (iter.hasNext()) {
                String authority = (String)iter.next();
                if (authority == null || authority.trim().length() == 0) continue;
                result.append("<").append(prefix).append("AuthenticatingAuthority").append(uri).append(">").append(authority).append("</").append(prefix).append("AuthenticatingAuthority>");
            }
        }
        result.append("</").append(prefix).append("AuthnContext>");
        return result.toString();
    }
}

