/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.assertion.Action;
import com.sun.identity.saml.assertion.Evidence;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.SubjectQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthorizationDecisionQuery
extends SubjectQuery {
    protected String resource = null;
    protected List actions = Collections.EMPTY_LIST;
    protected Evidence evidence = null;

    protected AuthorizationDecisionQuery() {
    }

    public AuthorizationDecisionQuery(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AuthorizationDecisionQuery: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtils.checkQuery(element, "AuthorizationDecisionQuery");
        if (!valid) {
            SAMLUtils.debug.message("AuthorizationDecisionQuery: wrong inout.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.resource = element.getAttribute("Resource");
        if (this.resource == null || this.resource.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: Missing attribute Resource.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int k = 0; k < length; ++k) {
            Node child = nl.item(k);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Subject")) {
                if (this.subject != null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AuthorizationDecisionQuery: contained more than one <Subject>");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                }
                this.subject = new Subject((Element)child);
                continue;
            }
            if (childName.equals("Action")) {
                if (this.actions == Collections.EMPTY_LIST) {
                    this.actions = new ArrayList();
                }
                this.actions.add(new Action((Element)child));
                continue;
            }
            if (childName.equals("Evidence")) {
                if (this.evidence != null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AuthorizationDecisionQuery: contained more than one <Evidence>");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                }
                this.evidence = new Evidence((Element)child);
                continue;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: included wrong element:" + childName);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: missing <Subject>");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        if (this.actions == Collections.EMPTY_LIST) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: missing <Action>");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    private void buildAuthZQuery(Subject theSubject, List theActions, Evidence theEvidence, String theResource) throws SAMLException {
        int length;
        if (theSubject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: input <Subject> is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this.subject = theSubject;
        Object temp = null;
        if (theActions != null && (length = theActions.size()) != 0) {
            for (int i = 0; i < length; ++i) {
                temp = theActions.get(i);
                if (temp instanceof Action) continue;
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AuthorizationDecisionQuery: Wrong input for Action.");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
            }
            this.actions = theActions;
        }
        if (this.actions == Collections.EMPTY_LIST) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: missing <Action> in input.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this.evidence = theEvidence;
        if (theResource == null || theResource.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: Missing attribute Resource.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        this.resource = theResource;
    }

    public AuthorizationDecisionQuery(Subject theSubject, List theActions, Evidence theEvidence, String theResource) throws SAMLException {
        this.buildAuthZQuery(theSubject, theActions, theEvidence, theResource);
    }

    public AuthorizationDecisionQuery(Subject theSubject, List theActions, String theResource) throws SAMLException {
        this.buildAuthZQuery(theSubject, theActions, null, theResource);
    }

    public List getAction() {
        return this.actions;
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    public String getResource() {
        return this.resource;
    }

    public int getQueryType() {
        return 1;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(200);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        xml.append("<").append(prefix).append("AuthorizationDecisionQuery").append(uri).append(" Resource=\"").append(this.resource).append("\">\n").append(this.subject.toString(true, true));
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            xml.append(((Action)iterator.next()).toString(true, true));
        }
        if (this.evidence != null) {
            xml.append(this.evidence.toString(true, true));
        }
        xml.append("</").append(prefix).append("AuthorizationDecisionQuery>\n");
        return xml.toString();
    }
}

