/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.encode.Base64;

public class AssertionArtifact {
    protected String artifact;
    protected String assertionHandle = null;
    protected String sourceID = null;
    protected byte[] typeCode = null;
    static final int ARTIFACT_1_LENGTH = 42;
    static final byte ARTIFACT_1_TYPE_CODE_0 = 0;
    static final byte ARTIFACT_1_TYPE_CODE_1 = 1;
    static final byte[] ARTIFACT_1_TYPE_CODE = new byte[]{0, 1};

    protected AssertionArtifact() {
    }

    public AssertionArtifact(String theArtifact) throws SAMLException {
        if (theArtifact == null || theArtifact.length() == 0) {
            SAMLUtils.debug.message("AssertionArtifact: empty input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        byte[] raw = null;
        try {
            raw = Base64.decode(theArtifact);
        }
        catch (Exception e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionArtifact: exception decode input:", e);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (raw.length != 42) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionArtifact: the length is not 42:" + raw.length);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (raw[0] != 0 || raw[1] != 1) {
            SAMLUtils.debug.message("AssertionArtifact: wrong typecode.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.typeCode = ARTIFACT_1_TYPE_CODE;
        this.artifact = theArtifact;
        byte[] sBytes = new byte[20];
        byte[] aBytes = new byte[20];
        System.arraycopy(raw, 2, sBytes, 0, 20);
        System.arraycopy(raw, 22, aBytes, 0, 20);
        try {
            this.sourceID = SAMLUtils.byteArrayToString(sBytes);
            this.assertionHandle = SAMLUtils.byteArrayToString(aBytes);
        }
        catch (Exception e) {
            SAMLUtils.debug.error("AssertionArtifact: encoding exception: ", e);
            this.sourceID = new String(sBytes);
            this.assertionHandle = new String(aBytes);
        }
    }

    public AssertionArtifact(String id, String handle) throws SAMLException {
        if (id == null || handle == null) {
            SAMLUtils.debug.message("AssertionArtifact: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        byte[] idBytes = null;
        byte[] handleBytes = null;
        try {
            idBytes = SAMLUtils.stringToByteArray(id);
            handleBytes = SAMLUtils.stringToByteArray(handle);
        }
        catch (Exception e) {
            SAMLUtils.debug.error("AssertionArtifact: encoding exception: ", e);
            idBytes = id.getBytes();
            handleBytes = handle.getBytes();
        }
        if (idBytes.length != 20 || handleBytes.length != 20) {
            SAMLUtils.debug.message("AssertionArtifact: wrong input length.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.sourceID = id;
        this.assertionHandle = handle;
        byte[] raw = new byte[42];
        raw[0] = 0;
        raw[1] = 1;
        for (int i = 0; i < 20; ++i) {
            raw[2 + i] = idBytes[i];
            raw[22 + i] = handleBytes[i];
        }
        try {
            this.artifact = Base64.encode(raw).trim();
        }
        catch (Exception e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionArtifact: exception encode input:", e);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        this.typeCode = ARTIFACT_1_TYPE_CODE;
    }

    public String getAssertionArtifact() {
        return this.artifact;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public String getAssertionHandle() {
        return this.assertionHandle;
    }

    public byte[] getTypeCode() {
        return this.typeCode;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(100);
        String prefix = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        String uri = "";
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        xml.append("<").append(prefix).append("AssertionArtifact").append(uri).append(">").append(this.artifact).append("</").append(prefix).append("AssertionArtifact>\n");
        return xml.toString();
    }
}

