/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SAMLCertUtils {
    private static Map certdbCerts;

    public static CertEntry getMatchingCertEntry(X509Certificate inCert) {
        String inCertName = inCert.getIssuerDN().getName().trim();
        BigInteger inCertSerialNumber = inCert.getSerialNumber();
        Iterator it = certdbCerts.entrySet().iterator();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Found " + certdbCerts.entrySet().size() + " jks certs");
        }
        while (it.hasNext()) {
            CertEntry certEntry = (CertEntry)it.next().getValue();
            if (!inCertName.equals(certEntry.getIssuerDN().getName()) || !inCertSerialNumber.equals(certEntry.getSerialNumber())) continue;
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Matching cert found.");
            }
            return certEntry;
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Matching cert not found.");
        }
        return null;
    }

    static {
        KeyStore ks;
        JKSKeyProvider kp;
        certdbCerts = Collections.synchronizedMap(new HashMap());
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Start loading certs from jks key store");
        }
        if ((kp = new JKSKeyProvider()) != null && (ks = kp.getKeyStore()) != null) {
            try {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                    CertEntry certEntry = new CertEntry(alias, cert.getIssuerDN(), cert.getSerialNumber());
                    certdbCerts.put(alias, certEntry);
                }
            }
            catch (KeyStoreException kes) {
                SAMLUtils.debug.error("Key store has problem.", kes);
            }
        }
    }

    public static class CertEntry {
        private String nickName = null;
        private Principal issuerDN = null;
        private BigInteger serialNumber;

        public CertEntry(String nickName, Principal issuerDN, BigInteger serialNumber) {
            this.nickName = nickName;
            this.issuerDN = issuerDN;
            this.serialNumber = serialNumber;
        }

        public String getNickName() {
            return this.nickName;
        }

        public Principal getIssuerDN() {
            return this.issuerDN;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }
    }
}

