/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.client.InvalidAppSSOTokenException;
import com.sun.identity.policy.client.PolicyProperties;
import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.AppSSOTokenProvider;
import com.sun.identity.shared.debug.Debug;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class PolicyEvaluator {
    static Debug debug = Debug.getInstance("amRemotePolicy");
    private PolicyProperties policyProperties;
    private String serviceName;
    private SSOTokenManager ssoTokenManager;
    private ResourceResultCache resourceResultCache;
    AppSSOTokenProvider appSSOTokenProvider;
    static Logger accessLogger;
    static Logger errorLogger;
    private static final String GET_RESPONSE_ATTRIBUTES = "Get_Response_Attributes";
    private SSOToken appSSOToken;
    private static final int RETRY_COUNT = 3;
    private String logActions;

    public PolicyEvaluator(String serviceName) throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator():Creating PolicyEvaluator:serviceName=" + serviceName);
        }
        this.init(serviceName, null);
    }

    PolicyEvaluator(String serviceName, AppSSOTokenProvider appSSOTokenProvider) throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator():Creating PolicyEvaluator:serviceName=" + serviceName + ":appSSOTokenProvider=" + appSSOTokenProvider);
        }
        if (serviceName == null) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyEvaluator():serviceName is null");
            }
            return;
        }
        this.init(serviceName, appSSOTokenProvider);
    }

    private void init(String serviceName, AppSSOTokenProvider appSSOTokenProvider) throws PolicyException, SSOException {
        this.ssoTokenManager = SSOTokenManager.getInstance();
        this.serviceName = serviceName;
        this.appSSOTokenProvider = appSSOTokenProvider;
        this.policyProperties = new PolicyProperties();
        this.logActions = this.policyProperties.getLogActions();
        this.resourceResultCache = ResourceResultCache.getInstance(this.policyProperties);
        this.appSSOToken = this.getNewAppSSOToken();
        if (PolicyProperties.previouslyNotificationEnabled()) {
            this.resourceResultCache.removeRemotePolicyListener(this.appSSOToken, serviceName, PolicyProperties.getPreviousNotificationURL());
        }
        if (this.policyProperties.notificationEnabled()) {
            if (debug.messageEnabled()) {
                debug.message("PolicyEvaluator.init():adding remote policy listener with policy service");
            }
            this.resourceResultCache.addRemotePolicyListener(this.appSSOToken, serviceName, this.policyProperties.getNotificationURL());
        }
        ActionDecision.setClientClockSkew(this.policyProperties.getClientClockSkew());
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:initialized PolicyEvaluator");
        }
    }

    public boolean isAllowed(SSOToken token, String resourceName, String actionName) throws PolicyException, SSOException {
        return this.isAllowed(token, resourceName, actionName, null);
    }

    public boolean isAllowed(SSOToken token, String resourceName, String actionName, Map envParameters) throws PolicyException, SSOException {
        Set set;
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:isAllowed():token=" + token.getPrincipal().getName() + ":resourceName=" + resourceName + ":actionName=" + actionName + ":envParameters) : entering");
        }
        boolean actionAllowed = false;
        HashSet<String> actionNames = new HashSet<String>(1);
        actionNames.add(actionName);
        PolicyDecision policyDecision = this.getPolicyDecision(token, resourceName, actionNames, envParameters);
        ActionDecision actionDecision = (ActionDecision)policyDecision.getActionDecisions().get(actionName);
        String trueValue = this.policyProperties.getTrueValue(this.serviceName, actionName);
        String falseValue = this.policyProperties.getFalseValue(this.serviceName, actionName);
        if (actionDecision != null && trueValue != null && falseValue != null && (set = actionDecision.getValues()) != null) {
            if (set.contains(falseValue)) {
                actionAllowed = false;
            } else if (set.contains(trueValue)) {
                actionAllowed = true;
            }
        }
        String result = actionAllowed ? "ALLOW" : "DENY";
        Object[] objs = new String[]{resourceName, actionName, result};
        if ("ALLOW".equals(this.logActions) && actionAllowed) {
            this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_allow", objs), token);
        } else if ("DENY".equals(this.logActions) && !actionAllowed) {
            this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_deny", objs), token);
        } else if ("BOTH".equals(this.logActions) || "DECISION".equals(this.logActions)) {
            this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_result", objs), token);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.isAllowed():token=" + token.getPrincipal().getName() + ":resourceName=" + resourceName + ":actionName=" + actionName + ":returning: " + actionAllowed);
        }
        return actionAllowed;
    }

    public PolicyDecision getPolicyDecision(SSOToken token, String resourceName, Set actionNames) throws PolicyException, SSOException {
        return this.getPolicyDecision(token, resourceName, actionNames, null);
    }

    public PolicyDecision getPolicyDecision(SSOToken token, String resourceName, Set actionNames, Map envParameters) throws PolicyException, SSOException {
        this.ssoTokenManager.validateToken(token);
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:getPolicyDecision():token=" + token.getPrincipal().getName() + ":resourceName=" + resourceName + ":actionName=" + actionNames + ":entering");
        }
        PolicyDecision pd = null;
        try {
            pd = this.resourceResultCache.getPolicyDecision(this.appSSOToken, this.serviceName, token, resourceName, actionNames, envParameters, 3);
        }
        catch (InvalidAppSSOTokenException e) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyEvaluator.getPolicyDecision():InvalidAppSSOTokenException occured:getting new appssotoken");
            }
            this.appSSOToken = this.getNewAppSSOToken();
            if (this.policyProperties.notificationEnabled()) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyEvaluator.getPolicyDecision():InvalidAppSSOTokenException occured:reRegistering remote policy listener");
                }
                this.reRegisterRemotePolicyListener(this.appSSOToken);
            }
            pd = this.resourceResultCache.getPolicyDecision(this.appSSOToken, this.serviceName, token, resourceName, actionNames, envParameters, 3);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:getPolicyDecision():token=" + token.getPrincipal().getName() + ":resourceName=" + resourceName + ":actionNames=" + actionNames + ":returning policyDecision:" + pd.toXML());
        }
        Object[] objs = new Object[]{resourceName, actionNames, pd.toXML()};
        if ("DECISION".equals(this.logActions)) {
            this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_decision", objs), token);
        }
        return pd;
    }

    private SSOToken getNewAppSSOToken() throws PolicyException {
        SSOToken token = null;
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getNewAppSSOToken():entering");
        }
        if (this.appSSOTokenProvider != null) {
            token = this.appSSOTokenProvider.getAppSSOToken();
            try {
                this.ssoTokenManager.refreshSession(token);
                if (!this.ssoTokenManager.isValidToken(token)) {
                    if (debug.messageEnabled()) {
                        debug.message("PolicyEvaluator.getNewAppSSOToken():AdminTokenAction returned  expired token, trying again");
                    }
                    token = this.appSSOTokenProvider.getAppSSOToken();
                }
            }
            catch (SSOException e) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyEvaluator.getNewAppSSOToken():could not refresh session:", e);
                }
                token = this.appSSOTokenProvider.getAppSSOToken();
            }
        } else {
            token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                this.ssoTokenManager.refreshSession(token);
                if (!this.ssoTokenManager.isValidToken(token)) {
                    if (debug.messageEnabled()) {
                        debug.message("PolicyEvaluator.getNewAppSSOToken():AdminTokenAction returned  expired token, trying again");
                    }
                    token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
            }
            catch (SSOException e) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyEvaluator.getNewAppSSOToken():could not refresh session:", e);
                }
                token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            }
        }
        if (token == null) {
            debug.error("PolicyEvaluator.getNewAppSSOToken():, cannot obtain application SSO token");
            throw new PolicyException("amPolicy", "can_not_create_app_sso_token", null, null);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getNewAppSSOToken():returning token");
        }
        return token;
    }

    private void logAccessMessage(Level level, String message, SSOToken token) {
        block4: {
            try {
                if (accessLogger == null && (accessLogger = (Logger)Logger.getLogger("amRemotePolicy.access")) == null) {
                    if (debug.warningEnabled()) {
                        debug.warning("PolicyEvaluator.logAccessMessage:Failed to create Logger");
                    }
                    return;
                }
                LogRecord lr = new LogRecord(level, message, token);
                accessLogger.log(lr, this.appSSOToken);
            }
            catch (Throwable ex) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("PolicyEvaluator.logAccessMessage:Error writing access logs");
            }
        }
    }

    AppSSOTokenProvider getAppSSOTokenProvider() {
        return this.appSSOTokenProvider;
    }

    public Set getAdvicesHandleableByAM(boolean refetchFromServer) throws InvalidAppSSOTokenException, PolicyEvaluationException, PolicyException, SSOException {
        Set advicesHandleableByAM = null;
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getAdvicesHandleableByAM(): EnteringrefetchFromServer=" + refetchFromServer);
        }
        try {
            advicesHandleableByAM = this.resourceResultCache.getAdvicesHandleableByAM(this.appSSOToken, refetchFromServer);
        }
        catch (InvalidAppSSOTokenException e) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyEvaluator.getAdvicesHandleableByAM():got InvalidAppSSOTokenException,  retrying with new app token");
            }
            advicesHandleableByAM = this.resourceResultCache.getAdvicesHandleableByAM(this.getNewAppSSOToken(), refetchFromServer);
        }
        catch (PolicyException pe) {
            Throwable nestedException = pe.getNestedException();
            if (nestedException != null && nestedException instanceof SessionException) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyEvaluator.getAdvicesHandleableByAM():got SessionException,  retrying with new app token");
                }
                advicesHandleableByAM = this.resourceResultCache.getAdvicesHandleableByAM(this.getNewAppSSOToken(), refetchFromServer);
            }
            throw pe;
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getAdvicesHandleableByAM(): Returning advicesHandleableByAM=" + advicesHandleableByAM);
        }
        return advicesHandleableByAM;
    }

    public String getCompositeAdvice(ActionDecision actionDecision) throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getCompositeAdvice(): entering, actionDecision = " + actionDecision.toXML());
        }
        String compositeAdvice = null;
        boolean matchFound = false;
        Map advices = null;
        if (actionDecision != null) {
            advices = actionDecision.getAdvices();
        }
        Set handleableAdvices = this.getAdvicesHandleableByAM(false);
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getCompositeAdvice(): handleableAdvices = " + handleableAdvices);
        }
        if (advices != null && !advices.isEmpty() && handleableAdvices != null && !handleableAdvices.isEmpty()) {
            Set adviceKeys = advices.keySet();
            if (debug.messageEnabled()) {
                debug.message("PolicyEvaluator.getCompositeAdvice(): adviceKeys = " + adviceKeys);
            }
            Iterator keyIter = adviceKeys.iterator();
            while (keyIter.hasNext()) {
                Object adviceKey = keyIter.next();
                if (!handleableAdvices.contains(adviceKey)) continue;
                matchFound = true;
                if (!debug.messageEnabled()) break;
                debug.message("PolicyEvaluator.getCompositeAdvice(): matchFound = " + matchFound);
                debug.message("PolicyEvaluator.getCompositeAdvice(): common key = " + adviceKey);
                break;
            }
        }
        if (matchFound) {
            compositeAdvice = PolicyUtils.advicesToXMLString(advices);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getCompositeAdvice(): returning, compositeAdvcie = " + compositeAdvice);
        }
        return compositeAdvice;
    }

    void reRegisterRemotePolicyListener(SSOToken appToken) throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.reRegisterRemotePolicyListener():entering");
        }
        this.resourceResultCache.addRemotePolicyListener(this.appSSOToken, this.serviceName, this.policyProperties.getNotificationURL(), true);
        this.resourceResultCache.clearCachedDecisionsForService(this.serviceName);
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.reRegisterRemotePolicyListener():returning");
        }
    }
}

