/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceAttributeValidator;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class ResourceComparatorValidator
implements ServiceAttributeValidator {
    String separator = "|";
    private static final Debug debug = Debug.getInstance("amPolicy");

    public boolean validate(Set values) {
        if (values != null && !values.isEmpty()) {
            Iterator valIterator = values.iterator();
            while (valIterator.hasNext()) {
                String elemVal = (String)valIterator.next();
                if (elemVal == null) continue;
                StringTokenizer st = new StringTokenizer(elemVal, "|");
                String[] tokens = new String[6];
                int count = 0;
                while (st.hasMoreTokens()) {
                    tokens[count++] = st.nextToken();
                    if (count <= 5) continue;
                }
                String wildcardPattern = null;
                String oneLevelPattern = null;
                for (int i = 0; i < count; ++i) {
                    int equal = tokens[i].indexOf("=");
                    String name = tokens[i].substring(0, equal);
                    String value = tokens[i].substring(equal + 1);
                    if (name == null) {
                        debug.error("ResourceComparatorValidator.validate(): name is null");
                        continue;
                    }
                    if (value == null) {
                        debug.error("ResourceComparatorValidator.validate(): value is null");
                        continue;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("ResourceComparatorValidator.validate():Attr Name = " + name + " Attr Value = " + value);
                    }
                    if (name.equalsIgnoreCase("wildcard")) {
                        wildcardPattern = value;
                        continue;
                    }
                    if (!name.equalsIgnoreCase("oneLevelWildcard")) continue;
                    oneLevelPattern = value;
                }
                if (wildcardPattern == null || oneLevelPattern == null) continue;
                if (wildcardPattern.equals(oneLevelPattern)) {
                    debug.error("ResourceComparatorValidator.validate()Wildcard and one level wildcard pattern cannot be same");
                    return false;
                }
                if (wildcardPattern.indexOf(oneLevelPattern) != -1 || oneLevelPattern.indexOf(wildcardPattern) != -1) continue;
                boolean overlap = false;
                if (debug.messageEnabled()) {
                    debug.message("ResourceComparatorValidator.validate():about to do overlap check");
                }
                int oneLevelWildLength = oneLevelPattern.length();
                int wildcardLength = wildcardPattern.length();
                char[] wildcard = wildcardPattern.toCharArray();
                char[] oneWildcard = oneLevelPattern.toCharArray();
                for (int i = 0; i < wildcardPattern.length(); ++i) {
                    for (int j = 0; j < oneLevelPattern.length(); ++j) {
                        if (wildcard[i] != oneWildcard[j]) continue;
                        String remString1 = String.valueOf(wildcard, i, wildcardLength - i);
                        String remString2 = String.valueOf(oneWildcard, j, oneLevelWildLength - j);
                        if (!oneLevelPattern.startsWith(remString1) && !wildcardPattern.startsWith(remString2)) continue;
                        overlap = true;
                        break;
                    }
                    if (overlap) break;
                }
                if (!overlap) continue;
                debug.error("ResourceComparatorValidator.validate():Wildcard and one level wildcard pattern cannot be overlapping");
                return false;
            }
        }
        return true;
    }
}

