/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.ConditionTypeManager;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.ResourceIndexManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResponseProviderTypeManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SharedSubject;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.Subjects;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class PolicyManager {
    public static final String POLICY_SERVICE_NAME = "iPlanetAMPolicyService";
    public static final String POLICY_DEBUG_NAME = "amPolicy";
    public static final String ORGANIZATION_NAME = "OrganizationName";
    public static final String DELEGATION_REALM = "/sunamhiddenrealmdelegationservicepermissions";
    static final String NAMED_POLICY = "Policies";
    static final String REALM_SUBJECTS = "RealmSubjects";
    static final String XML_REALM_SUBJECTS = "xmlRealmSubjects";
    private static final String NAMED_POLICY_ID = "NamedPolicy";
    static final String RESOURCES_POLICY = "Resources";
    static final String RESOURCES_POLICY_ID = "ServiceType";
    private static final String SUBJECTS_POLICY = "Subjects";
    static final String SUBJECT_POLICY = "Subject";
    static final String REALM_SUBJECT_POLICY = "RealmSubject";
    static final String CONDITION_POLICY = "Condition";
    static final String RESP_PROVIDER_POLICY = "ResponseProvider";
    static final String REFERRAL_POLICY = "Referral";
    static final String REFERRALS_POLICY = "Referrals";
    private static final String POLICY_XML = "xmlpolicy";
    static final String POLICY_VERSION = "1.0";
    static final String POLICY_ROOT_NODE = "Policy";
    static final String POLICY_RULE_NODE = "Rule";
    static final String POLICY_SUBJECTS_NODE = "Subjects";
    static final String POLICY_CONDITIONS_NODE = "Conditions";
    static final String POLICY_RESP_PROVIDERS_NODE = "ResponseProviders";
    static final String POLICY_REFERRALS_NODE = "Referrals";
    static final String POLICY_RULE_SERVICE_NODE = "ServiceName";
    static final String POLICY_RULE_RESOURCE_NODE = "ResourceName";
    static final String ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
    static final String ATTR_NODE = "Attribute";
    static final String ATTR_VALUE_NODE = "Value";
    static final String NAME_ATTRIBUTE = "name";
    static final String TYPE_ATTRIBUTE = "type";
    static final String DESCRIPTION_ATTRIBUTE = "description";
    static final String PRIORITY_ATTRIBUTE = "priority";
    static final String STATUS_ATTRIBUTE = "priority";
    static final String STATUS_ACTIVE = "active";
    static final String STATUS_INACTIVE = "inactive";
    static final String SERVICE_TYPE_NAME_ATTRIBUTE = "serviceName";
    static final String POLICY_INDEX_ROOT_NODE = "PolicyCrossReferences";
    static final String POLICY_INDEX_ROOT_NODE_NAME_ATTR = "name";
    static final String POLICY_INDEX_ROOT_NODE_TYPE_ATTR = "type";
    static final String POLICY_INDEX_ROOT_NODE_TYPE_ATTR_RESOURCES_VALUE = "Resources";
    static final String POLICY_INDEX_REFERENCE_NODE = "Reference";
    static final String POLICY_INDEX_REFERENCE_NODE_NAME_ATTR = "name";
    static final String POLICY_INDEX_POLICYNAME_NODE = "PolicyName";
    static final String POLICY_INDEX_POLICYNAME_NODE_NAME_ATTR = "name";
    static final long DEFAULT_SUBJECTS_RESULT_TTL = 600000L;
    static final String WEB_AGENT_SERVICE = "iPlanetAMWebAgentService";
    static final String ID_REPO_SERVICE = "sunIdentityRepositoryService";
    static final String ORG_ALIAS = "sunOrganizationAliases";
    static final String ORG_ALIAS_URL_HTTP_PREFIX = "http://";
    static final String ORG_ALIAS_URL_HTTPS_PREFIX = "https://";
    static final String ORG_ALIAS_URL_SUFFIX = ":*";
    private String org = "/";
    private String givenOrgName = "";
    private ServiceConfigManager scm;
    private OrganizationConfigManager ocm;
    private ResourceManager rm;
    private ServiceTypeManager svtm;
    private SubjectTypeManager stm;
    private ConditionTypeManager ctm;
    private ResponseProviderTypeManager rpm;
    private ReferralTypeManager rtm;
    private PolicyCache policyCache;
    private ResourceIndexManager rim;
    private static ServiceSchemaManager ssm;
    SSOToken token;
    static Debug debug;
    static DN delegationRealm;

    public PolicyManager(SSOToken token) throws SSOException, PolicyException {
        this(token, "");
        if (debug.messageEnabled()) {
            debug.message("Policy Manager constructed using SSO token");
        }
    }

    public PolicyManager(SSOToken token, String name) throws SSOException, NameNotFoundException, PolicyException {
        SSOTokenManager.getInstance().validateToken(token);
        this.token = token;
        try {
            this.scm = new ServiceConfigManager(POLICY_SERVICE_NAME, token);
        }
        catch (SMSException se) {
            debug.error("In constructor for PolicyManager with orgNameUnable to get service config manager", se);
            throw new PolicyException(se);
        }
        this.org = this.verifyOrgName(name);
        this.givenOrgName = name;
        this.rm = new ResourceManager(token, this.org, this.scm);
        if (debug.messageEnabled()) {
            debug.message("Policy Manager constructed with SSO token  for organization: " + this.org);
        }
        this.policyCache = PolicyCache.getInstance();
        this.svtm = ServiceTypeManager.getServiceTypeManager();
        this.rim = new ResourceIndexManager(this.rm);
    }

    public String getOrganizationName() {
        return this.givenOrgName;
    }

    public Map getPolicyConfig() {
        Map policyConfig = null;
        try {
            policyConfig = PolicyConfig.getPolicyConfig(this.org);
        }
        catch (PolicyException pe) {
            debug.error("PolicyManager:can not get policy config  for org : " + this.org, pe);
        }
        if (policyConfig != null) {
            HashSet<String> set = new HashSet<String>();
            set.add(this.org);
            policyConfig.put(ORGANIZATION_NAME, set);
        } else {
            debug.error("PolicyManager: policy config is null for org:" + this.org + ". Most likely it has been unregistered." + " It is not recommended to unregister the policy" + " configuration serivce. If you do so, the result" + " is undefined.");
        }
        return policyConfig;
    }

    String getOrganizationDN() {
        return this.org;
    }

    public Set getPolicyNames() throws SSOException, NoPermissionException, PolicyException {
        return this.getPolicyNames("*");
    }

    public Set getPolicyNames(String pattern) throws SSOException, NoPermissionException, PolicyException {
        try {
            ServiceConfig namedPolicy;
            ServiceConfig oConfig = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig serviceConfig = namedPolicy = oConfig == null ? null : oConfig.getSubConfig(NAMED_POLICY);
            if (namedPolicy == null) {
                return Collections.EMPTY_SET;
            }
            if (pattern.equals("*")) {
                return namedPolicy.getSubConfigNames();
            }
            return namedPolicy.getSubConfigNames(pattern);
        }
        catch (SMSException se) {
            debug.error("Unable to get named policies for organization: " + this.org);
            Object[] objs = new String[]{this.org};
            if (se.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policies_for_organization", objs, se);
        }
    }

    public String getPolicyDN(String policyName) throws SSOException, NoPermissionException, NameNotFoundException, PolicyException {
        this.getPolicy(policyName);
        StringBuffer answer = new StringBuffer(100);
        answer.append("ou=");
        answer.append(policyName);
        answer.append(",ou=");
        answer.append(NAMED_POLICY);
        answer.append(",ou=default,ou=organizationConfig,ou=");
        answer.append(POLICY_VERSION);
        answer.append(",ou=");
        answer.append(POLICY_SERVICE_NAME);
        answer.append(",ou=services,");
        answer.append(this.org);
        return answer.toString();
    }

    public Policy getPolicy(String policyName) throws SSOException, NoPermissionException, InvalidFormatException, NameNotFoundException, InvalidNameException, PolicyException {
        if (policyName == null) {
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 1);
        }
        if (debug.messageEnabled()) {
            debug.message("searching for named policy: " + policyName + " in organization: " + this.org);
        }
        Policy answer = null;
        try {
            ServiceConfig oConfig = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig namedPolicy = oConfig == null ? null : oConfig.getSubConfig(NAMED_POLICY);
            ServiceConfig policy = null;
            Map attrs = null;
            Set res = null;
            if (namedPolicy == null || (policy = namedPolicy.getSubConfig(policyName)) == null || (attrs = policy.getAttributes()) == null || (res = (Set)attrs.get(POLICY_XML)) == null || res.size() <= 0) {
                if (debug.warningEnabled()) {
                    debug.warning("Unable to find named policy: " + policyName + " in organization: " + this.org);
                }
                Object[] objs = new String[]{policyName, this.org};
                throw new NameNotFoundException(POLICY_DEBUG_NAME, "policy_not_found_in_organization", objs, policyName, 1);
            }
            Iterator it = res.iterator();
            String policyXml = (String)it.next();
            Document doc = null;
            try {
                doc = XMLUtils.getXMLDocument(new ByteArrayInputStream(policyXml.getBytes("UTF8")));
            }
            catch (Exception xmle) {
                debug.error("XML parsing error for policy: " + policyName + " in organization: " + this.org);
                throw new PolicyException(xmle);
            }
            Node rootNode = XMLUtils.getRootNode(doc, POLICY_ROOT_NODE);
            if (rootNode == null) {
                debug.error("invalid xml policy blob for named policy: " + policyName + " in organization: " + this.org);
                throw new InvalidFormatException(POLICY_DEBUG_NAME, "invalid_xml_policy_root_node", null, policyName, 1);
            }
            if (debug.messageEnabled()) {
                debug.message("returning named policy: " + policyName + " for organization: " + this.org);
            }
            answer = new Policy(this, rootNode);
            Map policyConfig = this.getPolicyConfig();
            if (policyConfig != null) {
                answer.setSubjectsResultTtl(PolicyConfig.getSubjectsResultTtl(policyConfig));
            }
            return answer;
        }
        catch (SMSException se) {
            debug.error("SMS error in finding named policy: " + policyName + " in organization: " + this.org);
            Object[] objs = new String[]{policyName, this.org};
            if (se.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy", objs, se);
        }
    }

    public void addPolicy(Policy policy) throws SSOException, NameAlreadyExistsException, NoPermissionException, InvalidFormatException, PolicyException {
        String realmName = this.getOrganizationDN();
        realmName = new DN(realmName).toRFCString().toLowerCase();
        String subjectRealm = policy.getSubjectRealm();
        Object[] realmNames = new String[]{realmName, subjectRealm};
        if (subjectRealm != null && !subjectRealm.equals(realmName)) {
            if (debug.messageEnabled()) {
                debug.message("Can not add policy in realm :" + realmName + ", policy has realm subjects " + " from realm : " + subjectRealm);
            }
            throw new InvalidFormatException(POLICY_DEBUG_NAME, "policy_realm_does_not_match", realmNames, null, realmName, 1);
        }
        this.validateForResourcePrefix(policy);
        this.validateReferrals(policy);
        String policyXml = policy.toXML();
        HashMap attrs = new HashMap();
        HashSet<String> set = new HashSet<String>();
        set.add(policyXml);
        attrs.put(POLICY_XML, set);
        ServiceConfig namedPolicy = PolicyManager.createOrGetPolicyConfig(NAMED_POLICY, NAMED_POLICY, this.scm, this.org);
        try {
            namedPolicy.addSubConfig(policy.getName(), NAMED_POLICY_ID, 0, attrs);
            this.rim.addPolicyToResourceTree(this.svtm, this.token, policy);
        }
        catch (ServiceAlreadyExistsException e) {
            Object[] objs = new String[]{policy.getName(), this.org};
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage("POLICY_ALREADY_EXISTS_IN_REALM", (String[])objs, this.token);
            }
            throw new NameAlreadyExistsException(POLICY_DEBUG_NAME, "policy_already_exists_in_org", objs, policy.getName(), 1);
        }
        catch (SMSException se) {
            Object[] objs = new String[]{policy.getName(), this.org};
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage("UNABLE_TO_ADD_POLICY", (String[])objs, this.token);
            }
            debug.error("SMS error in add policy: " + policy.getName() + " for org: " + this.org, se);
            if (se.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_add_policy", objs, se);
        }
        if (PolicyUtils.logStatus) {
            String[] objs = new String[]{policy.getName(), this.org};
            PolicyUtils.logAccessMessage("POLICY_CREATE_SUCCESS", objs, this.token);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replacePolicy(Policy policy) throws SSOException, NameNotFoundException, NoPermissionException, InvalidFormatException, PolicyException {
        String name;
        block14: {
            String realmName = this.getOrganizationDN();
            String subjectRealm = policy.getSubjectRealm();
            Object[] realmNames = new String[]{realmName, subjectRealm};
            if (subjectRealm != null && !subjectRealm.equals(realmName)) {
                if (debug.messageEnabled()) {
                    debug.message("Can not replace policy in realm :" + realmName + ", policy has realm subjects " + " from realm : " + subjectRealm);
                }
                throw new InvalidFormatException(POLICY_DEBUG_NAME, "policy_realm_does_not_match", realmNames, null, realmName, 1);
            }
            String policyXml = policy.toXML();
            HashMap attrs = new HashMap();
            HashSet<String> set = new HashSet<String>();
            set.add(policyXml);
            attrs.put(POLICY_XML, set);
            name = null;
            ServiceConfig namedPolicy = PolicyManager.createOrGetPolicyConfig(NAMED_POLICY, NAMED_POLICY, this.scm, this.org);
            try {
                String policyName = policy.getName();
                String oldPolicyName = policy.getOriginalName();
                ServiceConfig policyEntry = namedPolicy.getSubConfig(policyName);
                ServiceConfig oldPolicyEntry = null;
                if (oldPolicyName != null) {
                    oldPolicyEntry = namedPolicy.getSubConfig(oldPolicyName);
                    name = oldPolicyName;
                } else {
                    name = policy.getName();
                }
                if (policyEntry == null) {
                    if (oldPolicyEntry == null) {
                        Object[] objs = new String[]{policy.getName(), this.org};
                        throw new NameNotFoundException(POLICY_DEBUG_NAME, "policy_not_found_in_organization", objs, policy.getName(), 1);
                    }
                    this.removePolicy(oldPolicyName);
                    this.addPolicy(policy);
                    policy.resetOriginalName();
                    break block14;
                }
                Object[] objs = new String[]{policy.getName(), this.org};
                if (oldPolicyName != null && !policy.getName().equalsIgnoreCase(oldPolicyName)) {
                    if (PolicyUtils.logStatus) {
                        PolicyUtils.logErrorMessage("DID_NOT_REPLACE_POLICY", (String[])objs, this.token);
                    }
                    throw new NameAlreadyExistsException(POLICY_DEBUG_NAME, "policy_already_exists_in_org", objs, policy.getName(), 1);
                }
                Policy oldPolicy = this.getPolicy(policy.getName());
                this.validateForResourcePrefix(policy);
                this.validateReferrals(policy);
                policyEntry.setAttributes(attrs);
                if (oldPolicy != null) {
                    this.rim.replacePolicyInResourceTree(this.svtm, this.token, oldPolicy, policy);
                }
            }
            catch (SMSException se) {
                Object[] objs = new String[]{name, this.org};
                if (PolicyUtils.logStatus) {
                    PolicyUtils.logErrorMessage("UNABLE_TO_REPLACE_POLICY", (String[])objs, this.token);
                }
                debug.error("SMS error in replacing policy: " + policy.getOriginalName() + " for org: " + this.org, se);
                if (se.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                    throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
                }
                throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_replace_policy", objs, se);
            }
        }
        if (PolicyUtils.logStatus) {
            String[] objs = new String[]{name, this.org};
            PolicyUtils.logAccessMessage("POLICY_MODIFY_SUCCESS", objs, this.token);
        }
    }

    public void removePolicy(String policyName) throws SSOException, NoPermissionException, PolicyException {
        if (policyName == null) {
            if (debug.warningEnabled()) {
                debug.warning("In PolicyManager::removePolicy(), name is null");
            }
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 1);
        }
        try {
            ServiceConfig namedPolicy;
            ServiceConfig oConfig = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig serviceConfig = namedPolicy = oConfig == null ? null : oConfig.getSubConfig(NAMED_POLICY);
            if (namedPolicy != null) {
                Policy policy = this.getPolicy(policyName);
                namedPolicy.removeSubConfig(policyName);
                if (policy != null) {
                    this.rim.removePolicyFromResourceTree(this.svtm, this.token, policy);
                }
            }
        }
        catch (ServiceNotFoundException snfe) {
            debug.error("Error while removing policy : " + snfe.getMessage());
        }
        catch (SMSException smse) {
            Object[] objs = new String[]{policyName, this.org};
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage("UNABLE_TO_REMOVE_POLICY", (String[])objs, this.token);
            }
            debug.error("SMS error in deleting policy: " + policyName + " for org: " + this.org, smse);
            if (smse.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_remove_policy", objs, smse);
        }
        String[] objs = new String[]{policyName, this.org};
        if (PolicyUtils.logStatus) {
            PolicyUtils.logAccessMessage("POLICY_REMOVE_SUCCESS", objs, this.token);
        }
    }

    public ResourceManager getResourceManager() {
        return this.rm;
    }

    public SubjectTypeManager getSubjectTypeManager() {
        if (this.stm == null) {
            this.stm = new SubjectTypeManager(this);
        }
        return this.stm;
    }

    public ConditionTypeManager getConditionTypeManager() {
        if (this.ctm == null) {
            this.ctm = new ConditionTypeManager(this);
        }
        return this.ctm;
    }

    public ResponseProviderTypeManager getResponseProviderTypeManager() {
        if (this.rpm == null) {
            this.rpm = new ResponseProviderTypeManager(this);
        }
        return this.rpm;
    }

    static ServiceConfig createOrGetPolicyConfig(String configName, String configId, ServiceConfigManager scm, String org) throws NoPermissionException, PolicyException, SSOException {
        ServiceConfig sConfig = null;
        try {
            ServiceConfig oConfig = scm.getOrganizationConfig(org, null);
            ServiceConfig serviceConfig = sConfig = oConfig == null ? null : oConfig.getSubConfig(configName);
            if (sConfig == null) {
                if (debug.messageEnabled()) {
                    debug.message("Creating the " + configName + " tree for org: " + org);
                }
                PolicyManager.createPolicyTree(configName, configId, scm, org);
                if (oConfig == null) {
                    oConfig = scm.getOrganizationConfig(org, null);
                }
                if (oConfig == null || (sConfig = oConfig.getSubConfig(configName)) == null) {
                    Object[] objs = new String[]{configName};
                    throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy_node", objs, null);
                }
            }
        }
        catch (SMSException smse) {
            debug.error("SMS error in creating " + configName + " node for org: " + org, smse);
            if (smse.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                Object[] objs = new String[]{configName};
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", objs);
            }
            Object[] objs = new String[]{configName};
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy_node", objs, smse);
        }
        return sConfig;
    }

    static void createPolicyTree(String configName, String configId, ServiceConfigManager scm, String org) throws NoPermissionException, PolicyException, SSOException {
        try {
            ServiceConfig pConfig = scm.getOrganizationConfig(org, null);
            if (pConfig == null) {
                scm.createOrganizationConfig(org, null);
                pConfig = scm.getOrganizationConfig(org, null);
            }
            pConfig.addSubConfig(configName, configId, 0, null);
        }
        catch (ServiceAlreadyExistsException se) {
            if (debug.messageEnabled()) {
                debug.message("PolicyManager->createPolicyTree: Name: " + configName + " ID: " + configId + " Policy service already exists under org->" + org);
            }
        }
        catch (SMSException e) {
            Object[] objs = new String[]{org};
            if (e.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_create_policy_for_org", objs, e);
        }
    }

    String verifyOrgName(String name) throws InvalidNameException, NameNotFoundException, SSOException {
        String orgName = null;
        if (name == null) {
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 4);
        }
        orgName = DNMapper.orgNameToDN(name);
        if (!SMSEntry.checkIfEntryExists(orgName, this.token)) {
            if (debug.warningEnabled()) {
                debug.warning("Checking for organization name: " + orgName + " failed since entry does not exist");
            }
            Object[] objs = new String[]{name};
            throw new NameNotFoundException(POLICY_DEBUG_NAME, "org_not_found", objs, orgName, 4);
        }
        return orgName;
    }

    Set getSubOrganizationNames() throws SSOException, NoPermissionException, PolicyException {
        throw new UnsupportedOperationException();
    }

    Set getSubOrganizationNames(String filter) throws SSOException, PolicyException {
        throw new UnsupportedOperationException();
    }

    PolicyManager getSubOrganizationPolicyManager(String subOrgName) throws SSOException, PolicyException {
        return new PolicyManager(this.token, this.org + "/" + subOrgName);
    }

    ServiceTypeManager getServiceTypeManager() {
        return this.svtm;
    }

    public ReferralTypeManager getReferralTypeManager() {
        if (this.rtm == null) {
            this.rtm = new ReferralTypeManager(this);
        }
        return this.rtm;
    }

    static Set getPluginSchemaNames(String interfaceName) {
        if (ssm == null) {
            try {
                ssm = new ServiceSchemaManager(POLICY_SERVICE_NAME, ServiceTypeManager.getSSOToken());
            }
            catch (Exception se) {
                debug.error("Cannot create service schema manager for policy", se);
                return Collections.EMPTY_SET;
            }
        }
        Set answer = null;
        try {
            answer = ssm.getPluginSchemaNames(interfaceName, null);
        }
        catch (Exception e) {
            debug.error("Cannot get plugin schemas: " + interfaceName + " for policy", e);
            return Collections.EMPTY_SET;
        }
        return answer == null ? Collections.EMPTY_SET : answer;
    }

    static PluginSchema getPluginSchema(String interfaceName, String pluginName) {
        Set plugins = PolicyManager.getPluginSchemaNames(interfaceName);
        if (plugins.contains(pluginName)) {
            try {
                return ssm.getPluginSchema(pluginName, interfaceName, null);
            }
            catch (Exception e) {
                debug.error("Cannot get plugin schemas: " + interfaceName + " for policy", e);
            }
        }
        return null;
    }

    static String getViewBeanURL(String pluginType, String pluginClassName) {
        String viewBeanURL = null;
        if (pluginType != null) {
            Iterator items = PolicyManager.getPluginSchemaNames(pluginType).iterator();
            while (items.hasNext()) {
                String pluginName = (String)items.next();
                PluginSchema ps = PolicyManager.getPluginSchema(pluginType, pluginName);
                if (!pluginClassName.equals(ps.getClassName())) continue;
                viewBeanURL = ps.getPropertiesViewBeanURL();
                break;
            }
        }
        return viewBeanURL;
    }

    Policy getPolicy(String policyName, boolean useCache) throws SSOException, NoPermissionException, InvalidFormatException, NameNotFoundException, InvalidFormatException, PolicyException {
        Policy policy = null;
        policy = useCache ? this.policyCache.getPolicy(this.org, policyName) : this.getPolicy(policyName);
        return policy;
    }

    ResourceIndexManager getResourceIndexManager() {
        return this.rim;
    }

    private boolean validateResourceForPrefix(ServiceType resourceType, String resourceName) throws PolicyException {
        boolean validResource = false;
        Set resourcePrefixes = this.getManagedResourceNames(resourceType.getName());
        Iterator iter = resourcePrefixes.iterator();
        while (iter.hasNext()) {
            boolean interpretWildCard;
            String prefix = (String)iter.next();
            ResourceMatch rm = resourceType.compare(resourceName, prefix, interpretWildCard = true);
            if (!rm.equals(ResourceMatch.SUPER_RESOURCE_MATCH) && !rm.equals(ResourceMatch.WILDCARD_MATCH) && !rm.equals(ResourceMatch.EXACT_MATCH)) continue;
            validResource = true;
            break;
        }
        return validResource;
    }

    private void validateForResourcePrefix(Policy policy) throws SSOException, PolicyException {
        DN orgDN = new DN(this.org);
        DN baseDN = new DN(ServiceManager.getBaseDN());
        Set prefixes = this.getManagedResourceNames();
        if (!(orgDN.equals(baseDN) || orgDN.equals(delegationRealm) || prefixes != null && !prefixes.isEmpty())) {
            Object[] objs = new String[]{this.org};
            throw new PolicyException(POLICY_DEBUG_NAME, "no_referral_can_not_create_policy", objs, null);
        }
        Iterator ruleNames = policy.getRuleNames().iterator();
        while (ruleNames.hasNext()) {
            String ruleName = (String)ruleNames.next();
            Rule rule = policy.getRule(ruleName);
            String serviceTypeName = rule.getServiceTypeName();
            ServiceType resourceType = this.getServiceTypeManager().getServiceType(serviceTypeName);
            String ruleResource = rule.getResourceName();
            boolean validResource = true;
            if (!orgDN.equals(baseDN) && !orgDN.equals(delegationRealm)) {
                validResource = this.validateResourceForPrefix(resourceType, ruleResource);
            }
            if (validResource) continue;
            Object[] objs = new String[]{ruleResource, resourceType.getName()};
            throw new PolicyException(POLICY_DEBUG_NAME, "resource_name_not_permitted_by_prefix_names", objs, null);
        }
    }

    private void validateReferrals(Policy policy) throws SSOException, PolicyException {
        Set candidateOrgs = policy.getReferredToOrganizations();
        if (candidateOrgs.contains(this.org.toLowerCase())) {
            Object[] objs = new String[]{this.org};
            throw new PolicyException(POLICY_DEBUG_NAME, "invalid_referral_pointing_to_self", objs, null);
        }
        Iterator iter = candidateOrgs.iterator();
        while (iter.hasNext()) {
            String candidateOrg = (String)iter.next();
            this.verifyOrgName(candidateOrg);
        }
    }

    void saveRealmSubjects(Subjects subjects) throws PolicyException, SSOException {
        ServiceConfig realmSubjects = PolicyManager.createOrGetPolicyConfig(REALM_SUBJECTS, REALM_SUBJECTS, this.scm, this.org);
        HashMap attributes = new HashMap(1);
        HashSet<String> values = new HashSet<String>(1);
        String subjectsXML = subjects.toXML();
        values.add(subjectsXML);
        attributes.put(XML_REALM_SUBJECTS, values);
        try {
            realmSubjects.setAttributes(attributes);
        }
        catch (SMSException se) {
            debug.error("SMS error in saving realm subjects  in organization: " + this.org);
            Object[] objs = new String[]{this.org};
            if (se.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new PolicyException(POLICY_DEBUG_NAME, "insufficient_access_rights", null, se);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_save_realm_subjects", objs, se);
        }
        if (debug.messageEnabled()) {
            debug.message("saved realm subjects:" + subjectsXML);
        }
    }

    Subjects readRealmSubjects() throws PolicyException, SSOException {
        Subjects subjects = null;
        ServiceConfig realmSubjects = PolicyManager.createOrGetPolicyConfig(REALM_SUBJECTS, REALM_SUBJECTS, this.scm, this.org);
        Set values = null;
        values = (Set)realmSubjects.getAttributes().get(XML_REALM_SUBJECTS);
        if (values != null && !values.isEmpty()) {
            String xmlSubjects = (String)values.iterator().next();
            Document doc = null;
            try {
                doc = XMLUtils.getXMLDocument(new ByteArrayInputStream(xmlSubjects.getBytes("UTF8")));
            }
            catch (Exception xmle) {
                debug.error("XML parsing error for realmSubjects:  in organization: " + this.org);
                throw new PolicyException(xmle);
            }
            Node subjectsNode = XMLUtils.getRootNode(doc, "Subjects");
            if (subjectsNode == null) {
                debug.error("invalid xmlRealmSubjects blob  in organization: " + this.org);
                throw new InvalidFormatException(POLICY_DEBUG_NAME, "invalid_xml_realmsubjects_root_node", null, this.org, 1);
            }
            subjects = new Subjects(this, subjectsNode);
        } else {
            subjects = new Subjects();
        }
        if (debug.messageEnabled()) {
            debug.message("read realm subjects:" + subjects.toXML());
        }
        subjects.setPolicyConfig(this.getPolicyConfig());
        return subjects;
    }

    public Set getPoliciesUsingRealmSubject(String subjectName) throws PolicyException, SSOException {
        HashSet<Policy> policies = new HashSet<Policy>();
        Set policyNames = this.getPolicyNames();
        Iterator policyIter = policyNames.iterator();
        while (policyIter.hasNext()) {
            Subject subject;
            String policyName = (String)policyIter.next();
            Policy policy = this.getPolicy(policyName);
            Set subjectNames = policy.getSubjectNames();
            if (!subjectNames.contains(subjectName) || !((subject = policy.getSubject(subjectName)) instanceof SharedSubject)) continue;
            policies.add(policy);
        }
        return policies;
    }

    Policy getPolicyUsingRealmSubject(String subjectName) throws PolicyException, SSOException {
        Policy policy = null;
        Set policyNames = this.getPolicyNames();
        Iterator policyIter = policyNames.iterator();
        while (policyIter.hasNext()) {
            Subject subject;
            String policyName = (String)policyIter.next();
            Policy p = this.getPolicy(policyName);
            Set subjectNames = p.getSubjectNames();
            if (!subjectNames.contains(subjectName) || !((subject = p.getSubject(subjectName)) instanceof SharedSubject)) continue;
            policy = p;
            break;
        }
        return policy;
    }

    private Set getOrgAliasMappedResourceNames() throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("PolicyManager.getOrgAliasMappedResourceNames():  entering:orgName = " + this.org);
        }
        HashSet<String> managedResourceNames = new HashSet<String>(3);
        if (this.ocm == null) {
            try {
                this.ocm = new OrganizationConfigManager(this.token, this.givenOrgName);
            }
            catch (SMSException sme) {
                Object[] objs = new String[]{this.org};
                throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_org_config_manager_for_org", objs, sme);
            }
        }
        Set orgAliases = null;
        try {
            Map orgAttributes = this.ocm.getAttributes(ID_REPO_SERVICE);
            orgAliases = (Set)orgAttributes.get(ORG_ALIAS);
            if (debug.messageEnabled()) {
                debug.message("PolicyManager.getOrgAliasMappedResourceNames():  orgName = " + this.org + ":orgAliases=" + orgAliases);
            }
        }
        catch (SMSException sme) {
            Object[] objs = new String[]{this.org};
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_org_alias_for_org", objs, sme);
        }
        if (orgAliases != null) {
            Iterator iter = orgAliases.iterator();
            while (iter.hasNext()) {
                String orgAlias = (String)iter.next();
                managedResourceNames.add(ORG_ALIAS_URL_HTTP_PREFIX + orgAlias.trim() + ORG_ALIAS_URL_SUFFIX);
                managedResourceNames.add(ORG_ALIAS_URL_HTTPS_PREFIX + orgAlias.trim() + ORG_ALIAS_URL_SUFFIX);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyManager.getOrgAliasMappedResourceNames():  returning: orgName = " + this.org + ":orgAliases=" + orgAliases + ":managedResourceNames=" + managedResourceNames);
        }
        return managedResourceNames;
    }

    public Set getManagedResourceNames(String serviceName) throws PolicyException {
        HashSet managedResourceNames = new HashSet();
        Set delegatedResourceNames = this.rm.getManagedResourceNames(serviceName);
        if (delegatedResourceNames != null) {
            managedResourceNames.addAll(delegatedResourceNames);
        }
        if (WEB_AGENT_SERVICE.equalsIgnoreCase(serviceName) && PolicyConfig.orgAliasMappedResourcesEnabled()) {
            managedResourceNames.addAll(this.getOrgAliasMappedResourceNames());
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyManager.getManagedResourceNames():  returning: orgName = " + this.org + ":serviceName=" + serviceName + ":managedResourceNames=" + managedResourceNames);
        }
        return managedResourceNames;
    }

    public Set getManagedResourceNames() throws PolicyException {
        HashSet managedResourceNames = this.rm.getManagedResourceNames();
        if (managedResourceNames == null || managedResourceNames == Collections.EMPTY_SET) {
            managedResourceNames = new HashSet();
        }
        managedResourceNames.addAll(this.getOrgAliasMappedResourceNames());
        if (debug.messageEnabled()) {
            debug.message("PolicyManager.getManagedResourceNames():  returning: orgName = " + this.org + ":managedResourceNames=" + managedResourceNames);
        }
        return managedResourceNames;
    }

    String getOrgAliasWithResource(String resourceName) throws PolicyException, SSOException {
        String orgAlias;
        block4: {
            if (debug.messageEnabled()) {
                debug.message("PolicyManager.getOrgAliasWithResource():  orgName = " + this.org + ", resourceName = " + resourceName);
            }
            if (resourceName == null) {
                return null;
            }
            orgAlias = null;
            try {
                URL url = new URL(resourceName);
                orgAlias = url.getHost();
            }
            catch (MalformedURLException mfe) {
                String[] objs = new String[]{resourceName};
                if (!debug.messageEnabled()) break block4;
                debug.message("PolicyManager.getOrgAliasWithResource():  orgName = " + this.org + ", resourceName = " + resourceName + " is invalid URL, no org alias mapping can be found");
            }
        }
        return orgAlias;
    }

    String getOrgNameWithAlias(String orgAlias) throws PolicyException, SSOException {
        String aliasMappedOrg;
        block3: {
            aliasMappedOrg = null;
            try {
                aliasMappedOrg = IdUtils.getOrganization(this.token, orgAlias);
            }
            catch (IdRepoException re) {
                if (!debug.messageEnabled()) break block3;
                debug.message("PolicyManager.getOrgNameWithAlias():  can not get orgName for orgAlias = " + orgAlias);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyManager.getOrgNameWithAlias():  orgAlias = " + orgAlias + ", mapped org = " + aliasMappedOrg);
        }
        return aliasMappedOrg;
    }

    static {
        debug = Debug.getInstance(POLICY_DEBUG_NAME);
        delegationRealm = new DN(DNMapper.orgNameToDN(DELEGATION_REALM));
    }
}

